/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils;

import android.animation.AnimatorInflater;
import android.animation.StateListAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.ColorRes;
import androidx.annotation.RequiresApi;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import java.lang.ref.WeakReference;

public class ResourceUtils {
    private static WeakReference<Context> sContextWeakReference;

    private static Resources getResources() {
        return ResourceUtils.getContext().getResources();
    }

    public static void setContext(Context context) {
        if (context == null) {
            return;
        }
        sContextWeakReference = new WeakReference<Context>(context);
    }

    private static Context getContext() {
        Context context = null;
        if (sContextWeakReference != null && sContextWeakReference.get() != null) {
            context = (Context)sContextWeakReference.get();
        }
        return context != null ? context : RuntimeContext.sApplicationContext;
    }

    public static int getColor(@ColorRes int colorId) {
        return ResourceUtils.getResources().getColor(colorId);
    }

    public static ColorStateList getColorStateList(@ColorRes int colorId) {
        if (Build.VERSION.SDK_INT >= 23) {
            return ResourceUtils.getResources().getColorStateList(colorId, ResourceUtils.getContext().getTheme());
        }
        return ResourceUtils.getResources().getColorStateList(colorId);
    }

    public static int getDimen(int dimen) {
        return ResourceUtils.getResources().getDimensionPixelSize(dimen);
    }

    public static Drawable getDrawable(int drawableId) {
        return ResourceUtils.getResources().getDrawable(drawableId);
    }

    public static void setImageRes(int resId, ImageView imageView) {
        if (imageView != null) {
            imageView.setImageResource(resId);
        }
    }

    public static void setBackground(int resId, View view) {
        if (view != null) {
            view.setBackgroundResource(resId);
        }
    }

    public static String getString(int stringId) {
        return ResourceUtils.getResources().getString(stringId);
    }

    public static String getString(int stringId, Object ... formatArgs) {
        try {
            return ResourceUtils.getResources().getString(stringId, formatArgs);
        }
        catch (Throwable e) {
            if (RuntimeContext.isInGray()) {
                throw new RuntimeException(e);
            }
            MLog.error("ResourceUtils", e);
            return "";
        }
    }

    public static String getQuantityString(int stringId, int count) {
        return ResourceUtils.getResources().getQuantityString(stringId, count);
    }

    public static int[] getIntArray(int intArrayId) {
        return ResourceUtils.getResources().getIntArray(intArrayId);
    }

    public static String[] getStringArray(int intArrayId) {
        return ResourceUtils.getResources().getStringArray(intArrayId);
    }

    public static int[] getDrawableSize(int aResID) {
        Drawable d = ResourceUtils.getDrawable(aResID);
        int[] ret = null == d ? new int[]{0, 0} : new int[]{d.getIntrinsicWidth(), d.getIntrinsicHeight()};
        return ret;
    }

    @RequiresApi(api=21)
    public static StateListAnimator getStateListAnimator(int animId) {
        return AnimatorInflater.loadStateListAnimator((Context)ResourceUtils.getContext(), (int)animId);
    }

    public static void asynLoadDrawable(final int resId, final View view) {
        YYTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                final Drawable drawable = ResourceUtils.getDrawable(resId);
                final WeakReference<View> weakReference = new WeakReference<View>(view);
                YYTaskExecutor.postToMainThread(new Runnable(){

                    @Override
                    public void run() {
                        View v = (View)weakReference.get();
                        if (v != null) {
                            if (v instanceof ImageView) {
                                ((ImageView)v).setImageDrawable(drawable);
                            } else {
                                v.setBackgroundDrawable(drawable);
                            }
                        }
                    }
                });
            }
        });
    }
}

