/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils;

import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Utils {
    private static final String TAG = "MD5Utils";
    protected static MessageDigest messagedigest = null;

    public static String fileMd5(String filePath) {
        if (StringUtils.isEmpty(filePath)) {
            return "";
        }
        try {
            return MD5Utils.getFileMd5String(filePath);
        }
        catch (Exception e) {
            MLog.warn(TAG, "get file [%s] md5 error", filePath);
            return "";
        }
    }

    public static String fileMd5(File file) {
        if (file == null) {
            return "";
        }
        try {
            return MD5Utils.getFileMD5String(file);
        }
        catch (Exception e) {
            MLog.warn(TAG, "get file [%s] md5 error", file.getAbsoluteFile());
            return "";
        }
    }

    public static String getFileMd5String(String path) throws IOException {
        if (path == null || path.length() == 0) {
            return null;
        }
        File big = new File(path);
        return MD5Utils.getFileMD5String(big);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileMD5String(File file) throws IOException {
        if (file == null || !file.exists()) {
            return null;
        }
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuilder stringbuffer = null;
        FileInputStream in = new FileInputStream(file);
        FileChannel ch = in.getChannel();
        try {
            MappedByteBuffer byteBuffer = ch.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
            MessageDigest messagedigest = MessageDigest.getInstance("MD5");
            messagedigest.update(byteBuffer);
            byte[] bytes = messagedigest.digest();
            int n = bytes.length;
            stringbuffer = new StringBuilder(2 * n);
            for (byte bt : bytes) {
                char c0 = hexDigits[(bt & 0xF0) >> 4];
                char c1 = hexDigits[bt & 0xF];
                stringbuffer.append(c0);
                stringbuffer.append(c1);
            }
        }
        catch (Exception e) {
            MLog.error(TAG, e);
        }
        finally {
            ch.close();
            in.close();
        }
        return stringbuffer != null ? stringbuffer.toString() : "";
    }

    public static String getMD5String(String s) {
        if (s == null) {
            return null;
        }
        return MD5Utils.getMD5String(s.getBytes());
    }

    public static String getMD5String(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        String md5 = null;
        try {
            if (messagedigest != null) {
                messagedigest.update(bytes);
                md5 = MD5Utils.bufferToHex(messagedigest.digest());
            }
        }
        catch (Throwable ex) {
            MLog.error(TAG, ex);
        }
        return md5;
    }

    public static String getMd5StringNew(String s) {
        if (s == null) {
            return null;
        }
        return MD5Utils.getMd5StringNew(s.getBytes());
    }

    public static String getMd5StringNew(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        String md5 = null;
        try {
            MessageDigest messagedigest = MessageDigest.getInstance("MD5");
            if (messagedigest != null) {
                messagedigest.update(bytes);
                md5 = MD5Utils.bufferToHex(messagedigest.digest());
            }
        }
        catch (Throwable ex) {
            MLog.error(TAG, ex);
        }
        return md5;
    }

    private static String bufferToHex(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return MD5Utils.bufferToHex(bytes, 0, bytes.length);
    }

    private static String bufferToHex(byte[] bytes, int start, int len) {
        if (bytes == null || start < 0 || len < 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(2 * len);
        int max = start + len;
        for (int i = start; i < max; ++i) {
            String hex = Integer.toHexString(0xFF & bytes[i]);
            if (hex.length() == 1) {
                hex = "0" + hex;
            }
            stringBuilder.append(hex);
        }
        return stringBuilder.toString();
    }

    static {
        try {
            messagedigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            MLog.error((Object)TAG, "get message digest failed! " + e.toString(), new Object[0]);
        }
    }
}

