/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.text.TextUtils;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class ImageUriComp {
    private static final String TAG = "ImageUriComp";

    ImageUriComp() {
    }

    private static String getRealFilePath(Context context, Uri uri) {
        return ImageUriComp.getDataColumn(context, uri, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        String sdPath;
        String[] projection;
        String path = uri.getPath();
        ContentResolver resolver = context.getContentResolver();
        Cursor cursor = resolver.query(uri, projection = new String[]{"_data"}, selection, selectionArgs, null);
        if (cursor != null && cursor.moveToFirst()) {
            try {
                int index = cursor.getColumnIndexOrThrow(projection[0]);
                if (index != -1) {
                    path = cursor.getString(index);
                }
            }
            catch (IllegalArgumentException e) {
                MLog.error(TAG, e);
                path = null;
            }
            finally {
                cursor.close();
            }
        }
        if (!(!TextUtils.isEmpty((CharSequence)path) && new File(path).exists() || path.startsWith(sdPath = Environment.getExternalStorageDirectory().getAbsolutePath()))) {
            int sepIndex = path.indexOf(File.separator, 1);
            path = sepIndex == -1 ? null : sdPath + path.substring(sepIndex);
        }
        return path;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"NewApi"})
    public static String getPath(Context context, Uri uri) {
        boolean isKitKat;
        block21: {
            boolean bl = isKitKat = Build.VERSION.SDK_INT >= 19;
            if (isKitKat && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
                MLog.info(TAG, "isKitKat = " + isKitKat + "  isDocumentUri", new Object[0]);
                if (ImageUriComp.isExternalStorageDocument(uri)) {
                    String docId = DocumentsContract.getDocumentId((Uri)uri);
                    String[] split = docId.split(":");
                    String type = split[0];
                    if ("primary".equalsIgnoreCase(type)) {
                        String path = Environment.getExternalStorageDirectory() + "/" + split[1];
                        MLog.info(TAG, "isKitKat = " + isKitKat + "  isDocumentUri  type = primary path = " + path, new Object[0]);
                        return path;
                    }
                } else {
                    if (ImageUriComp.isDownloadsDocument(uri)) {
                        String id2 = DocumentsContract.getDocumentId((Uri)uri);
                        Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(id2));
                        String path = ImageUriComp.getDataColumn(context, contentUri, null, null);
                        MLog.info(TAG, "isKitKat = " + isKitKat + "  isDownloadsDocument  path = " + path, new Object[0]);
                        return path;
                    }
                    if (ImageUriComp.isMediaDocument(uri)) {
                        String docId = DocumentsContract.getDocumentId((Uri)uri);
                        String[] split = docId.split(":");
                        String type = split[0];
                        Uri contentUri = null;
                        if ("image".equals(type)) {
                            contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                        } else if ("video".equals(type)) {
                            contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                        } else if ("audio".equals(type)) {
                            contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                        }
                        String selection = "_id=?";
                        String[] selectionArgs = new String[]{split[1]};
                        String path = ImageUriComp.getDataColumn(context, contentUri, "_id=?", selectionArgs);
                        MLog.info(TAG, "isKitKat = " + isKitKat + "  isMediaDocument  path = " + path, new Object[0]);
                        return path;
                    }
                }
            } else {
                if ("content".equalsIgnoreCase(uri.getScheme())) {
                    if (ImageUriComp.isGooglePhotosUri(uri)) {
                        String path = uri.getLastPathSegment();
                        MLog.info(TAG, "isKitKat = " + isKitKat + "  isGooglePhotosUri  path = " + path, new Object[0]);
                        return path;
                    }
                    if (ImageUriComp.isGooglePlayPhotosUri(uri)) {
                        String path = ImageUriComp.getImagePathFromInputStreamUri(context, uri);
                        MLog.info(TAG, "isKitKat = " + isKitKat + "  isGooglePlayPhotosUri  uri = " + uri + "  path = " + path, new Object[0]);
                        return path;
                    }
                    if (ImageUriComp.isHuaWeiUri(uri)) {
                        String uriPath;
                        String string2 = uriPath = StringUtils.isEmpty(uri.getPath()) ? uri.getPath() : uri.toString();
                        if (uriPath.startsWith("/root")) {
                            return uriPath.replace("/root", "");
                        }
                        break block21;
                    } else {
                        String path = null;
                        try {
                            path = ImageUriComp.getRealFilePath(context, uri);
                            MLog.info(TAG, "isKitKat = " + isKitKat + "  android4.4\u4ee5\u4e0b\u83b7\u53d6\u56fe\u7247path\u65b9\u6cd5  path = " + path, new Object[0]);
                            return path;
                        }
                        catch (Exception e) {
                            path = uri.getPath();
                            MLog.error((Object)TAG, e.getMessage(), new Object[0]);
                        }
                        return path;
                    }
                }
                if ("file".equalsIgnoreCase(uri.getScheme())) {
                    String path = uri.getPath();
                    MLog.info(TAG, "isKitKat = " + isKitKat + "  uri.getScheme() = " + uri.getScheme() + "  path = " + path, new Object[0]);
                    return path;
                }
            }
        }
        MLog.info(TAG, "isKitKat = " + isKitKat + "\u4ee5\u4e0a\u65b9\u6cd5\u90fd\u4e0d\u662f path null", new Object[0]);
        return null;
    }

    private static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    private static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    private static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    private static boolean isGooglePhotosUri(Uri uri) {
        return "com.google.android.apps.photos.content".equals(uri.getAuthority());
    }

    private static boolean isGooglePlayPhotosUri(Uri uri) {
        return "com.google.android.apps.photos.contentprovider".equals(uri.getAuthority());
    }

    private static boolean isHuaWeiUri(Uri uri) {
        return "com.huawei.hidisk.fileprovider".equals(uri.getAuthority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getImagePathFromInputStreamUri(Context context, Uri uri) {
        InputStream inputStream = null;
        String filePath = null;
        if (uri.getAuthority() != null) {
            try {
                inputStream = context.getContentResolver().openInputStream(uri);
                File photoFile = ImageUriComp.createTemporalFileFrom(inputStream);
                filePath = photoFile.getPath();
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return filePath;
    }

    private static File createTemporalFileFrom(InputStream inputStream) throws IOException {
        File targetFile = null;
        if (inputStream != null) {
            int read;
            byte[] buffer = new byte[8192];
            targetFile = ImageUriComp.createTemporalFile();
            FileOutputStream outputStream = new FileOutputStream(targetFile);
            while ((read = inputStream.read(buffer)) != -1) {
                ((OutputStream)outputStream).write(buffer, 0, read);
            }
            outputStream.flush();
            try {
                ((OutputStream)outputStream).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return targetFile;
    }

    private static File createTemporalFile() {
        return new File(FileStorageUtils.getInstance().getTempDir(), "tempFile.jpg");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Uri getImageUrlWithAuthority(Context context, Uri uri) {
        InputStream is = null;
        if (uri.getAuthority() != null) {
            try {
                is = context.getContentResolver().openInputStream(uri);
                Bitmap bmp = BitmapFactory.decodeStream((InputStream)is);
                Uri uri2 = ImageUriComp.writeToTempImageAndGetPathUri(context, bmp);
                return uri2;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private static Uri writeToTempImageAndGetPathUri(Context inContext, Bitmap inImage) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        inImage.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bytes);
        String path = MediaStore.Images.Media.insertImage((ContentResolver)inContext.getContentResolver(), (Bitmap)inImage, (String)"__selectphoto", null);
        return Uri.parse((String)path);
    }
}

