/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils;

import android.util.Log;
import com.yy.base.logger.MLog;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class GzipUtils {
    public static final int BUFFER = 2048;

    public static byte[] decompressForGzip(byte[] gzipStr) {
        ByteArrayOutputStream out = null;
        ByteArrayInputStream in = null;
        GZIPInputStream gzip = null;
        try {
            byte[] buff = new byte[1024];
            int len = 0;
            out = new ByteArrayOutputStream();
            in = new ByteArrayInputStream(gzipStr);
            gzip = new GZIPInputStream(in);
            StringBuilder result = new StringBuilder();
            while ((len = gzip.read(buff)) != -1) {
                out.write(buff, 0, len);
            }
            byte[] byteArray = out.toByteArray();
            gzip.close();
            in.close();
            out.close();
            return byteArray;
        }
        catch (IOException e) {
            MLog.error("GzipUtils", e);
            try {
                if (gzip != null) {
                    gzip.close();
                }
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e1) {
                MLog.error("GzipUtils", e1);
            }
            return null;
        }
    }

    public static void zip(String[] _files, String zipFileName) {
        try {
            BufferedInputStream origin = null;
            FileOutputStream dest = new FileOutputStream(zipFileName);
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));
            byte[] data = new byte[1024];
            for (int i = 0; i < _files.length; ++i) {
                int count;
                Log.v((String)"Compress", (String)("Adding: " + _files[i]));
                FileInputStream fi = new FileInputStream(_files[i]);
                origin = new BufferedInputStream(fi, 2048);
                ZipEntry entry = new ZipEntry(_files[i].substring(_files[i].lastIndexOf("/") + 1));
                out.putNextEntry(entry);
                while ((count = origin.read(data, 0, 2048)) != -1) {
                    out.write(data, 0, count);
                }
                origin.close();
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

