/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils;

import android.annotation.SuppressLint;
import android.graphics.Color;
import android.text.TextUtils;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import java.util.HashMap;
import java.util.Locale;
import org.json.JSONObject;

public class ColorUtils {
    private static final String TAG = "ColorUtils";
    public static final int BLACK = -16777216;
    public static final int DKGRAY = -12303292;
    public static final int GRAY = -7829368;
    public static final int LTGRAY = -3355444;
    public static final int WHITE = -1;
    public static final int RED = -65536;
    public static final int GREEN = -16711936;
    public static final int BLUE = -16776961;
    public static final int YELLOW = -256;
    public static final int CYAN = -16711681;
    public static final int MAGENTA = -65281;
    public static final int TRANSPARENT = 0;
    private static final HashMap<String, Integer> sColorNameMap = new HashMap();
    private static final String DEFAULT_COLOR = "#f3f3f3";

    public static boolean isRGB(String colorString) {
        try {
            if (TextUtils.isEmpty((CharSequence)colorString)) {
                return false;
            }
            if (colorString.charAt(0) == '#') {
                long color = Long.parseLong(colorString.substring(1), 16);
                if (colorString.length() == 7) {
                    color |= 0xFFFFFFFFFF000000L;
                } else if (colorString.length() != 9) {
                    return false;
                }
                return true;
            }
            Integer color = sColorNameMap.get(colorString.toLowerCase(Locale.ROOT));
            if (color != null) {
                return true;
            }
        }
        catch (Exception e) {
            MLog.warn(TAG, e.getMessage(), new Object[0]);
            return false;
        }
        return false;
    }

    public static int alphaColor(String color, int alpha) {
        return ColorUtils.alphaColor(ColorUtils.parseColor(color), alpha);
    }

    public static int alphaColor(int color, int alpha) {
        return (int)((float)alpha / 100.0f * 255.0f + 0.5f) << 24 | 0xFFFFFF & color;
    }

    public static int parseColor(String parse) {
        return ColorUtils.parseColor(parse, 0);
    }

    @SuppressLint(value={"colorParseUsage"})
    public static int parseColor(String parse, int defaultColor) {
        if (TextUtils.isEmpty((CharSequence)parse)) {
            return defaultColor;
        }
        try {
            defaultColor = Color.parseColor((String)parse.trim());
        }
        catch (Exception e) {
            MLog.error(TAG, e);
        }
        return defaultColor;
    }

    @SuppressLint(value={"colorParseUsage"})
    public static int getCardBgColor(String bgColor, String defaultColor) {
        block4: {
            if (!TextUtils.isEmpty((CharSequence)bgColor) && !TextUtils.isEmpty((CharSequence)bgColor.trim())) {
                try {
                    String temp = bgColor.trim();
                    if (!temp.startsWith("#")) {
                        temp = "#" + temp;
                        MLog.error((Object)TAG, "getCardBgColor", new IllegalArgumentException("color invalid: " + bgColor), new Object[0]);
                    }
                    return Color.parseColor((String)temp);
                }
                catch (Exception e) {
                    MLog.error((Object)TAG, "getCardBgColor %s", e, JSONObject.quote((String)bgColor));
                    if (!bgColor.startsWith("##")) break block4;
                    return ColorUtils.getCardBgColor(bgColor.replace("##", "#"), defaultColor);
                }
            }
        }
        return Color.parseColor((String)defaultColor);
    }

    public static int getCardBgColor(String bgColor) {
        return ColorUtils.getCardBgColor(bgColor, DEFAULT_COLOR);
    }

    public static String correct(String color) {
        if (!FP.empty(color)) {
            if ((color = color.trim()).startsWith("##")) {
                return color.replace("##", "#");
            }
            if (color.startsWith("#")) {
                return color;
            }
            return "#" + color;
        }
        return "";
    }

    static {
        sColorNameMap.put("black", -16777216);
        sColorNameMap.put("darkgray", -12303292);
        sColorNameMap.put("gray", -7829368);
        sColorNameMap.put("lightgray", -3355444);
        sColorNameMap.put("white", -1);
        sColorNameMap.put("red", -65536);
        sColorNameMap.put("green", -16711936);
        sColorNameMap.put("blue", -16776961);
        sColorNameMap.put("yellow", -256);
        sColorNameMap.put("cyan", -16711681);
        sColorNameMap.put("magenta", -65281);
        sColorNameMap.put("aqua", -16711681);
        sColorNameMap.put("fuchsia", -65281);
        sColorNameMap.put("darkgrey", -12303292);
        sColorNameMap.put("grey", -7829368);
        sColorNameMap.put("lightgrey", -3355444);
        sColorNameMap.put("lime", -16711936);
        sColorNameMap.put("maroon", -8388608);
        sColorNameMap.put("navy", -16777088);
        sColorNameMap.put("olive", -8355840);
        sColorNameMap.put("purple", -8388480);
        sColorNameMap.put("silver", -4144960);
        sColorNameMap.put("teal", -16744320);
    }
}

