/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.taskexecutor;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.MessageQueue;
import android.os.Process;
import android.os.SystemClock;
import android.util.Log;
import com.opensource.svgaplayer.hago.SVGAExecutorService;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.DefaultThreadFactory;
import com.yy.base.taskexecutor.ExecutorRunnableCache;
import com.yy.base.taskexecutor.FrequencyLimitExecutor;
import com.yy.base.taskexecutor.HandlEx;
import com.yy.base.taskexecutor.HookThreadPool;
import com.yy.base.taskexecutor.IFrequencyLimitExecutor;
import com.yy.base.taskexecutor.IIdleExecutor;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.Prioritized;
import com.yy.base.taskexecutor.ReflectionHelper;
import com.yy.base.taskexecutor.SdkNormalExecutorAdapter;
import com.yy.base.taskexecutor.YYNormalScheduledThreadPoolExecutor;
import com.yy.base.taskexecutor.YYNormalThreadPoolExecutor;
import com.yy.base.taskexecutor.YYTaskFifoPriorityThreadPoolExecutor;
import com.yy.base.taskexecutor.glideadapter.GlideExecutorDelegate;
import com.yy.base.utils.HardwareUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemUtils;
import com.yy.hago.xlog.KLogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class YYTaskExecutor {
    public static final int THREAD_PRIORITY_TYPE_NONE = 1;
    public static final int THREAD_PRIORITY_TYPE_USE_HIGH_PRIORITY_POOL = 2;
    public static final int THREAD_PRIORITY_TYPE_NOT_USE_HIGH_PRIORITY_POOL = 3;
    public static final int THREAD_POOL_TYPE_NONE = 1;
    public static final int THREAD_POOL_TYPE_ALL_USE_SCHEDULED_POOL = 2;
    public static final int THREAD_POOL_TYPE_NOT_ALL_USE_SCHEDULED_PRIORITY_POOL = 3;
    public static final int THREAD_PRIORITY_BACKGROUND = 10;
    public static final int THREAD_WORK_PRIORITY = 5;
    private static final int MIN_THREADPOOL_SIZE = HardwareUtils.getCpuCoreCount() > 4 && RuntimeContext.sPhoneType > 1 ? 20 : 15;
    public static final int MAX_THREADPOOL_SIZE = YYTaskExecutor.getMaxThreadSize();
    private static final ExecutorRunnableCache sDelayExecutorRunnableCache = new ExecutorRunnableCache();
    private static final ExecutorRunnableCache sExecutorRunnableCache = new ExecutorRunnableCache();
    private static final ExecutorRunnableCache sMainExecutorRunnableCache = YYTaskExecutor.mainCacheEnable() ? new ExecutorRunnableCache() : null;
    private static final HashMap<Runnable, CustomIdelHandler> sMainThreadIdelRunnableCache = new HashMap();
    private static volatile ThreadPoolExecutor sThreadPool = null;
    private static volatile ScheduledThreadPoolExecutor sScheduledThreadPool = null;
    private static volatile ThreadPoolExecutor sWorkPriorityScheduledThreadPool = null;
    private static volatile HandlEx sMainThreadHandler;
    private static Thread sMainThread;
    private static volatile int sThreadPriorityType;
    private static volatile int sThreadPoolType;
    private static HashMap<String, TaskWithStartTime> sEndlessLoopMonitorMap;
    private static HandlerThread sDelayExecuteQueueThread;
    private static volatile Handler sDelayExecuteQueueHandler;
    private static Object sDelayExecuteLock;
    private static volatile boolean sDelayUseMainThread;
    private static Object sInitThreadLock;
    public static volatile IIdleExecutor sDefaultIdleExecutor;
    private static Handler mDefaultHandler;
    private static HandlerThread mHandlerThread;
    private static ITaskMonitor sTaskMonitor;
    private static IIdleExecutorProxy sIdleExecutorProxy;

    private static int getMaxThreadSize() {
        int max = -1;
        if (SettingFlags.hasInited()) {
            max = RuntimeContext.getPhoneType() == 1 || HardwareUtils.getCpuCoreCount() <= 0 ? SettingFlags.getIntValue("maxthreadnum_lowphone", 20) : SettingFlags.getIntValue("maxthreadnum", 30);
        } else if (SystemUtils.isShowEnvSetting() && RuntimeContext.sIsMainProcess) {
            throw new RuntimeException("YYTask use must after SettingFlags inited!");
        }
        if (max < MIN_THREADPOOL_SIZE) {
            max = HardwareUtils.getCpuCoreCount() > 4 && RuntimeContext.sPhoneType > 1 ? 30 : 20;
        }
        return max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Handler getDelayExecuteQueueThread() {
        if (sDelayExecuteQueueHandler != null) {
            return sDelayExecuteQueueHandler;
        }
        Object object = sDelayExecuteLock;
        synchronized (object) {
            if (sDelayExecuteQueueHandler != null) {
                return sDelayExecuteQueueHandler;
            }
            if (sDelayExecuteQueueThread == null) {
                sDelayExecuteQueueThread = new HandlerThread("DelayExecuteQueueThread", 5);
                sDelayExecuteQueueThread.start();
                sDelayExecuteQueueHandler = new Handler(sDelayExecuteQueueThread.getLooper());
            }
            return sDelayExecuteQueueHandler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initNormalThreadPool() {
        if (sThreadPool != null) {
            return;
        }
        Object object = sInitThreadLock;
        synchronized (object) {
            if (sThreadPool == null) {
                if (sThreadPriorityType == 2) {
                    int maxSize;
                    int minSize = MIN_THREADPOOL_SIZE - 2;
                    int n = maxSize = minSize < MAX_THREADPOOL_SIZE - 5 ? MAX_THREADPOOL_SIZE - 5 : MIN_THREADPOOL_SIZE;
                    if (sThreadPoolType != 2) {
                        sThreadPool = new YYNormalThreadPoolExecutor(minSize, maxSize, RuntimeContext.sIsDebuggable ? YYNormalThreadPoolExecutor.UncaughtThrowableStrategy.THROW : YYNormalThreadPoolExecutor.UncaughtThrowableStrategy.LOG);
                    } else {
                        YYNormalScheduledThreadPoolExecutor threadPool = new YYNormalScheduledThreadPoolExecutor(maxSize, RuntimeContext.sIsDebuggable ? YYNormalScheduledThreadPoolExecutor.UncaughtThrowableStrategy.THROW : YYNormalScheduledThreadPoolExecutor.UncaughtThrowableStrategy.LOG, "YYNormalScheduledPool");
                        sThreadPool = threadPool;
                        sScheduledThreadPool = threadPool;
                    }
                } else {
                    sThreadPool = new YYTaskFifoPriorityThreadPoolExecutor(MIN_THREADPOOL_SIZE, MAX_THREADPOOL_SIZE, RuntimeContext.sIsDebuggable ? YYTaskFifoPriorityThreadPoolExecutor.UncaughtThrowableStrategy.THROW : YYTaskFifoPriorityThreadPoolExecutor.UncaughtThrowableStrategy.LOG);
                }
            }
            if (sScheduledThreadPool == null) {
                sScheduledThreadPool = new YYNormalScheduledThreadPoolExecutor(RuntimeContext.isPhoneSuperLow() ? 3 : 5, RuntimeContext.sIsDebuggable ? YYNormalScheduledThreadPoolExecutor.UncaughtThrowableStrategy.THROW : YYNormalScheduledThreadPoolExecutor.UncaughtThrowableStrategy.LOG, "YYScheduledExecutor");
            }
        }
    }

    public static synchronized void setThreadOptType(int priorityType, int poolType) {
        if (sThreadPriorityType != -1) {
            return;
        }
        sThreadPriorityType = priorityType;
        sThreadPoolType = poolType;
        if (!SystemUtils.isShowEnvSetting() || sThreadPool != null) {
            // empty if block
        }
        YYTaskExecutor.initNormalThreadPool();
        SVGAExecutorService.Companion.setExecutorService((Executor)sThreadPool);
        HookThreadPool.takeOverAndroidThreadPool();
    }

    public static int getThreadPriorityType() {
        return sThreadPriorityType;
    }

    private static ThreadPoolExecutor getThreadPool() {
        if (RuntimeContext.isInGray()) {
            if (KLogUtils.isInitialized()) {
                MLog.info("YYTaskExecutor", "getThreadPool!", new Object[0]);
            } else if (RuntimeContext.isLocalBuild()) {
                Log.i((String)"YYTaskExecutor", (String)"getThreadPool!");
            }
        }
        if (sThreadPool == null) {
            YYTaskExecutor.initNormalThreadPool();
        }
        return sThreadPool;
    }

    static ScheduledThreadPoolExecutor getScheduledThreadPool() {
        if (RuntimeContext.isInGray()) {
            if (KLogUtils.isInitialized()) {
                MLog.info("YYTaskExecutor", "getScheduledThreadPool", new Object[0]);
            } else if (RuntimeContext.isLocalBuild()) {
                Log.i((String)"YYTaskExecutor", (String)"getScheduledThreadPool");
            }
        }
        if (sThreadPool == null) {
            YYTaskExecutor.initNormalThreadPool();
        }
        return sScheduledThreadPool;
    }

    private static synchronized ThreadPoolExecutor getWorkPriorityThreadPool() {
        if (RuntimeContext.isInGray()) {
            if (KLogUtils.isInitialized()) {
                MLog.info("YYTaskExecutor", "getgetWorkPriorityScheduledThreadPool", new Object[0]);
            } else if (RuntimeContext.isLocalBuild()) {
                Log.i((String)"YYTaskExecutor", (String)"getWorkPriorityScheduledThreadPool");
            }
        }
        if (sWorkPriorityScheduledThreadPool != null) {
            return sWorkPriorityScheduledThreadPool;
        }
        sWorkPriorityScheduledThreadPool = new YYNormalThreadPoolExecutor(5, HardwareUtils.getCpuCoreCount() > 4 && RuntimeContext.sPhoneType > 2 ? 9 : 7, 30L, TimeUnit.SECONDS, new DefaultThreadFactory("YYWorkTask", 5), RuntimeContext.sIsDebuggable ? YYNormalThreadPoolExecutor.UncaughtThrowableStrategy.THROW : YYNormalThreadPoolExecutor.UncaughtThrowableStrategy.LOG);
        return sWorkPriorityScheduledThreadPool;
    }

    public static ExecutorService newGlideExecutorDelegate(int threadCount, String name) {
        SdkNormalExecutorAdapter executorAdapter = new SdkNormalExecutorAdapter(threadCount, name);
        if (YYTaskExecutor.getThreadPriorityType() == 3) {
            return new GlideExecutorDelegate(YYTaskExecutor.getThreadPool(), executorAdapter, false);
        }
        return new GlideExecutorDelegate(YYTaskExecutor.getWorkPriorityThreadPool(), executorAdapter, true);
    }

    public static void execute(Runnable task) {
        YYTaskExecutor.execute(task, 0L);
    }

    public static void execute(int executorType, Runnable task) {
        YYTaskExecutor.execute(executorType, task, 0L);
    }

    public static void executeByReportPriority(Runnable task) {
        YYTaskExecutor.execute(task, null, 0L, 10);
    }

    public static void execute(Runnable task, long delayMillis) {
        YYTaskExecutor.execute(task, null, delayMillis, 10);
    }

    public static void execute(int executorType, Runnable task, long delayMillis) {
        YYTaskExecutor.execute(executorType, task, null, delayMillis, 10);
    }

    public static void execute(Runnable task, long delayMillis, int priority) {
        YYTaskExecutor.execute(task, null, delayMillis, priority);
    }

    public static void execute(int executorType, Runnable task, long delayMillis, int priority) {
        YYTaskExecutor.execute(executorType, task, null, delayMillis, priority);
    }

    public static void execute(Runnable task, Runnable callbackInMainThread, long delayMillis) {
        YYTaskExecutor.execute(task, callbackInMainThread, delayMillis, 10);
    }

    public static void execute(int executorType, Runnable task, Runnable callbackInMainThread, long delayMillis) {
        YYTaskExecutor.execute(executorType, task, callbackInMainThread, delayMillis, 10);
    }

    public static void execute(Runnable task, Runnable callbackInMainThread) {
        YYTaskExecutor.execute(task, callbackInMainThread, 0L);
    }

    public static void execute(int executorType, Runnable task, Runnable callbackInMainThread) {
        YYTaskExecutor.execute(executorType, task, callbackInMainThread, 0L);
    }

    public static void execute(Runnable task, Runnable callbackInMainThread, long delayMillis, int thePriority) {
        YYTaskExecutor.execute(-3, task, callbackInMainThread, delayMillis, thePriority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(int executorType, Runnable task, Runnable callbackInMainThread, long delayMillis, int thePriority) {
        if (SystemUtils.isShowEnvSetting()) {
            MLog.debug("YYTaskExecuter", "execute:%s", task.toString());
        }
        if (task == null) {
            return;
        }
        if (delayMillis < 0L) {
            delayMillis = 0L;
        }
        if (thePriority != 5) {
            thePriority = 10;
        }
        int priority = thePriority;
        ExecutorRunnable theExecutorRunnable = ExecutorRunnable.obtain();
        if (theExecutorRunnable == null) {
            theExecutorRunnable = new ExecutorRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        if (sThreadPriorityType != 2 && this.priority != 10) {
                            Process.setThreadPriority((int)this.priority);
                        }
                        ExecutorRunnableCache executorRunnableCache = sExecutorRunnableCache;
                        synchronized (executorRunnableCache) {
                            if (sExecutorRunnableCache.size() > 0) {
                                sExecutorRunnableCache.removeExecuteTask(this);
                            }
                        }
                        long beforeExecute = 0L;
                        if (sTaskMonitor != null && this.submitMills > 0L && ((beforeExecute = SystemClock.uptimeMillis()) - this.submitMills > 3000L || SystemUtils.isShowEnvSetting()) && !(this.task instanceof ExecutorRunnable)) {
                            sTaskMonitor.onTaskRealStartExecute(this.submitMills, beforeExecute, this.task, sThreadPool);
                        }
                        this.task.run();
                        if (sTaskMonitor != null && this.submitMills > 0L && !(this.task instanceof ExecutorRunnable)) {
                            sTaskMonitor.onTaskExecuted(this.submitMills, beforeExecute, this.task, sThreadPool);
                        }
                        if (this.callBack != null) {
                            YYTaskExecutor.getMainThreadHandler().post(this.callBack);
                        }
                    }
                    catch (Throwable t) {
                        try {
                            ExecutorRunnableCache executorRunnableCache = sExecutorRunnableCache;
                            synchronized (executorRunnableCache) {
                                if (sExecutorRunnableCache.size() > 0) {
                                    sExecutorRunnableCache.removeExecuteTask(this);
                                }
                            }
                            YYTaskExecutor.onTaskException(t, this.task);
                        }
                        catch (Throwable t2) {
                            MLog.error("YYTaskExecutor error:", t2);
                            Log.e((String)"YYTaskExecutor error:", (String)(t2 != null ? t2.toString() : ""));
                        }
                        MLog.error("YYTaskExecutor error:", t);
                        Log.e((String)"YYTaskExecutor error:", (String)(t != null ? t.toString() : ""));
                        if (SystemUtils.isShowEnvSetting()) {
                            YYTaskExecutor.getMainThreadHandler().post(new Runnable(){

                                @Override
                                public void run() {
                                    throw new RuntimeException(YYTaskExecutor.getStackTraceString(t), t);
                                }
                            });
                        }
                    }
                    finally {
                        if (sThreadPriorityType != 2 && this.priority != 10) {
                            try {
                                Process.setThreadPriority((int)10);
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                        }
                        this.recycle();
                    }
                }
            };
        }
        final ExecutorRunnable executorRunnable = theExecutorRunnable;
        executorRunnable.task = task;
        executorRunnable.callBack = callbackInMainThread;
        executorRunnable.priority = priority;
        if (SystemUtils.isShowEnvSetting() && task instanceof ExecutorRunnable) {
            executorRunnable.needStat = false;
        }
        if (delayMillis > 0L) {
            ExecutorRunnable delayDelayExecutorRunnable = new ExecutorRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ExecutorRunnableCache executorRunnableCache = sDelayExecutorRunnableCache;
                    synchronized (executorRunnableCache) {
                        if (sDelayExecutorRunnableCache.size() > 0) {
                            sDelayExecutorRunnableCache.removeExecuteTask(this);
                        }
                    }
                    YYTaskExecutor.execute(executorRunnable);
                }
            };
            delayDelayExecutorRunnable.task = task;
            ExecutorRunnableCache executorRunnableCache = sDelayExecutorRunnableCache;
            synchronized (executorRunnableCache) {
                sDelayExecutorRunnableCache.putTask(task, delayDelayExecutorRunnable);
            }
            if (!YYTaskExecutor.delayUseMainThread()) {
                YYTaskExecutor.getDelayExecuteQueueThread().postDelayed((Runnable)delayDelayExecutorRunnable, delayMillis);
            } else {
                YYTaskExecutor.postToMainThread(delayDelayExecutorRunnable, delayMillis);
            }
        } else {
            YYTaskExecutor.execute(executorRunnable);
        }
    }

    static boolean delayUseMainThread() {
        return sDelayUseMainThread;
    }

    public static void setDelayUseMainThread(boolean delayUseMainThread) {
        sDelayUseMainThread = delayUseMainThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void execute(ExecutorRunnable task) {
        block23: {
            if (task == null || task.task == null) {
                return;
            }
            if (sThreadPool == null) {
                YYTaskExecutor.initNormalThreadPool();
            }
            try {
                if (sThreadPool.isShutdown()) break block23;
                Object object = sExecutorRunnableCache;
                synchronized (object) {
                    sExecutorRunnableCache.putTask(task.task, task);
                }
                if (sTaskMonitor != null) {
                    task.submitMills = SystemClock.uptimeMillis();
                    if (SystemUtils.isShowEnvSetting()) {
                        if (sEndlessLoopMonitorMap == null) {
                            sEndlessLoopMonitorMap = new HashMap();
                        }
                        object = sEndlessLoopMonitorMap;
                        synchronized (object) {
                            String info = task.task.toString();
                            if (info != null) {
                                String[] strings = info.split("@", 2);
                                info = strings[0];
                            }
                            if (info != null) {
                                long curTime = SystemClock.elapsedRealtime();
                                TaskWithStartTime taskWithStartTime = sEndlessLoopMonitorMap.get(info);
                                if (taskWithStartTime == null) {
                                    taskWithStartTime = new TaskWithStartTime();
                                    taskWithStartTime.startTime = curTime;
                                }
                                if ((long)taskWithStartTime.num > sTaskMonitor.getOneMinuteNumLimit() && curTime - taskWithStartTime.startTime < 60000L) {
                                    sTaskMonitor.onTaskProbablyEndlessLoop(task.task, taskWithStartTime.num, 1);
                                } else if ((long)taskWithStartTime.num > sTaskMonitor.getFiveSecondNumLimit() && curTime - taskWithStartTime.startTime < 5000L) {
                                    sTaskMonitor.onTaskProbablyEndlessLoop(task.task, taskWithStartTime.num, 2);
                                } else {
                                    taskWithStartTime.num = curTime - taskWithStartTime.startTime > 60000L ? 0 : ++taskWithStartTime.num;
                                }
                            }
                        }
                    }
                }
                if (task.priority == 5 && sThreadPriorityType == 2) {
                    YYTaskExecutor.getWorkPriorityThreadPool().execute(task);
                } else {
                    sThreadPool.execute(task);
                }
            }
            catch (Throwable e) {
                if (SystemUtils.isShowEnvSetting()) {
                    YYTaskExecutor.getMainThreadHandler().post(new Runnable(){

                        @Override
                        public void run() {
                            throw new RuntimeException(YYTaskExecutor.getStackTraceString(e), e);
                        }
                    });
                }
                MLog.error("YYTaskExecutor execute error two:", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTask(Runnable task) {
        if (task == null) {
            return;
        }
        ExecutorRunnable delayExecutorRunnable = null;
        ExecutorRunnableCache executorRunnableCache = sDelayExecutorRunnableCache;
        synchronized (executorRunnableCache) {
            if (sDelayExecutorRunnableCache.size() > 0) {
                delayExecutorRunnable = sDelayExecutorRunnableCache.removeTask(task);
            }
        }
        if (delayExecutorRunnable != null) {
            if (sDelayExecuteQueueHandler != null) {
                YYTaskExecutor.getDelayExecuteQueueThread().removeCallbacks((Runnable)delayExecutorRunnable);
            }
            YYTaskExecutor.getMainThreadHandler().removeCallbacks(delayExecutorRunnable);
        }
        ExecutorRunnable executorRunnable = null;
        ExecutorRunnableCache executorRunnableCache2 = sExecutorRunnableCache;
        synchronized (executorRunnableCache2) {
            if (sExecutorRunnableCache.size() > 0) {
                executorRunnable = sExecutorRunnableCache.removeTask(task);
            }
        }
        YYTaskExecutor.removeRunnableFromMainThread(task);
        if (executorRunnable != null) {
            try {
                if (sThreadPool != null) {
                    sThreadPool.remove(executorRunnable);
                }
                YYTaskExecutor.getWorkPriorityThreadPool().remove(executorRunnable);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static IQueueTaskExecutor createAQueueExcuter() {
        return new QueueRunnableExcuter();
    }

    public static IQueueTaskExecutor createAQueueExcuter(boolean useWorkThreadPool) {
        return new QueueRunnableExcuter(useWorkThreadPool, true);
    }

    public static IQueueTaskExecutor createAQueueExcuter(boolean useWorkThreadPool, boolean statTask) {
        return new QueueRunnableExcuter(useWorkThreadPool, statTask);
    }

    public static IFrequencyLimitExecutor createAFrequencyLimitExecut(long time, boolean runInMainThread) {
        return new FrequencyLimitExecutor(time, runInMainThread);
    }

    public static IFrequencyLimitExecutor createAFrequencyLimitExecut(long time, IQueueTaskExecutor taskExecutor) {
        return new FrequencyLimitExecutor(time, false, taskExecutor);
    }

    public static IIdleExecutor createAIdleExecutor(String id2) {
        if (sIdleExecutorProxy != null) {
            return sIdleExecutorProxy.createAIdleExecutor(id2);
        }
        IIdleExecutor iIdleExecutor = new IIdleExecutor(){

            @Override
            public void execute(Runnable task) {
                YYTaskExecutor.execute(task);
            }

            @Override
            public void execute(Runnable task, long delayTime) {
                this.execute(task, delayTime, Integer.MAX_VALUE);
            }

            @Override
            public void execute(Runnable task, long delayTime, long maxWaitTime) {
                YYTaskExecutor.execute(task, delayTime);
            }

            @Override
            public void remove(Runnable task) {
                YYTaskExecutor.removeTask(task);
            }
        };
        return iIdleExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IIdleExecutor getDefaultIdleExecutor() {
        if (sDefaultIdleExecutor != null) {
            return sDefaultIdleExecutor;
        }
        Class<YYTaskExecutor> clazz = YYTaskExecutor.class;
        synchronized (YYTaskExecutor.class) {
            if (sDefaultIdleExecutor == null) {
                sDefaultIdleExecutor = YYTaskExecutor.createAIdleExecutor("YYTask_DefaultIdle");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sDefaultIdleExecutor;
        }
    }

    public static void postToMainThread(Runnable task, long delayMillis) {
        if (task == null) {
            return;
        }
        if (sTaskMonitor != null && YYTaskExecutor.mainCacheEnable()) {
            ExecutorRunnable runnable = ExecutorRunnable.obtain();
            if (runnable == null) {
                runnable = new ExecutorRunnable(){

                    @Override
                    public void run() {
                        this.submitMills = SystemClock.uptimeMillis();
                        if (this.delayMills > 0L && sTaskMonitor != null) {
                            sTaskMonitor.onTaskStartInMainThread(this.submitMills, this.task);
                        }
                        if (sMainExecutorRunnableCache != null) {
                            sMainExecutorRunnableCache.removeExecuteTask(this);
                        }
                        try {
                            this.task.run();
                        }
                        catch (Throwable e) {
                            MLog.error("YYTask", e);
                        }
                        if (sTaskMonitor != null) {
                            sTaskMonitor.onTaskExecutedInMainThread(this.submitMills, this.task);
                        }
                    }
                };
            }
            runnable.task = task;
            runnable.delayMills = delayMillis;
            if (delayMillis <= 0L) {
                runnable.submitMills = SystemClock.uptimeMillis();
                sTaskMonitor.onTaskStartInMainThread(runnable.submitMills, runnable.task);
            }
            if (sMainExecutorRunnableCache != null) {
                sMainExecutorRunnableCache.putTask(task, runnable);
            }
            YYTaskExecutor.getMainThreadHandler().postDelayed(runnable, delayMillis);
        } else {
            YYTaskExecutor.getMainThreadHandler().postDelayed(task, delayMillis);
        }
    }

    private static boolean mainCacheEnable() {
        return false;
    }

    public static void postToMainThread(Runnable task) {
        if (task == null) {
            return;
        }
        YYTaskExecutor.postToMainThread(task, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void postIdleRunnableToMainThread(Runnable runnable) {
        CustomIdelHandler idelHandler = new CustomIdelHandler(runnable);
        HashMap<Runnable, CustomIdelHandler> hashMap = sMainThreadIdelRunnableCache;
        synchronized (hashMap) {
            sMainThreadIdelRunnableCache.put(runnable, idelHandler);
        }
        idelHandler.post();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeRunnableFromMainThread(Runnable task) {
        if (task == null) {
            return;
        }
        YYTaskExecutor.getMainThreadHandler().removeCallbacks(task);
        CustomIdelHandler idelHandler = null;
        HashMap<Runnable, CustomIdelHandler> hashMap = sMainThreadIdelRunnableCache;
        synchronized (hashMap) {
            if (sMainThreadIdelRunnableCache.size() > 0) {
                idelHandler = sMainThreadIdelRunnableCache.remove(task);
            }
        }
        if (sMainExecutorRunnableCache != null) {
            ExecutorRunnable runnable = sMainExecutorRunnableCache.getExecutorRunnable(task);
            if (runnable != null) {
                YYTaskExecutor.getMainThreadHandler().removeCallbacks(runnable);
            }
            sMainExecutorRunnableCache.removeTask(task);
        }
        if (idelHandler != null) {
            idelHandler.stop();
        }
    }

    public static boolean isMainThread() {
        Looper looper;
        Thread current = Thread.currentThread();
        if (sMainThread == null && (looper = Looper.getMainLooper()) != null) {
            sMainThread = looper.getThread();
        }
        return sMainThread == current;
    }

    public static synchronized void destroy() {
        if (sThreadPool != null) {
            try {
                sThreadPool.shutdown();
            }
            catch (Throwable t) {
                Log.e((String)"YYTaskExecutor", (String)"Empty Catch on destroy", (Throwable)t);
            }
            sThreadPool = null;
        }
    }

    public static synchronized Handler getLooperThreadHandler() {
        if (mDefaultHandler == null) {
            mHandlerThread = new HandlerThread("YYTaskSubThreadHandler");
            mHandlerThread.start();
            mDefaultHandler = new Handler(mHandlerThread.getLooper());
        }
        return mDefaultHandler;
    }

    public static synchronized void stopLooperThreadHandler() {
    }

    protected static HandlEx getMainThreadHandler() {
        if (sMainThreadHandler == null) {
            sMainThreadHandler = new HandlEx("MainThreadHandler + 8", Looper.getMainLooper());
        }
        return sMainThreadHandler;
    }

    private static String getStackTraceString(Throwable tr) {
        return Log.getStackTraceString((Throwable)tr);
    }

    public static void setTaskMonitor(ITaskMonitor taskMonitor) {
        sTaskMonitor = taskMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setIdleExecutorProxy(IIdleExecutorProxy idleExecutor) {
        if (sIdleExecutorProxy != null && idleExecutor != null) {
            return;
        }
        sIdleExecutorProxy = idleExecutor;
        Class<YYTaskExecutor> clazz = YYTaskExecutor.class;
        synchronized (YYTaskExecutor.class) {
            sDefaultIdleExecutor = YYTaskExecutor.createAIdleExecutor("YYTask_DefaultIdle");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static void onTaskException(Throwable e, Runnable task) {
        if (sTaskMonitor != null) {
            sTaskMonitor.onTaskException(e, task);
        }
    }

    private static void onTaskProbablyEndlessLoop(Throwable e, int executeTimes) {
    }

    public static void onTaskRejectedExecution(Runnable task, ThreadPoolExecutor executor) {
        if (sTaskMonitor != null) {
            sTaskMonitor.onTaskRejectedExecution(task);
        }
    }

    static {
        sMainThread = null;
        sThreadPriorityType = -1;
        sThreadPoolType = -1;
        sEndlessLoopMonitorMap = null;
        sDelayExecuteQueueThread = null;
        sDelayExecuteQueueHandler = null;
        sDelayExecuteLock = new Object();
        sDelayUseMainThread = true;
        sInitThreadLock = new Object();
        sDefaultIdleExecutor = null;
        sIdleExecutorProxy = null;
    }

    private static class TaskWithStartTime {
        int num;
        long startTime;

        private TaskWithStartTime() {
        }
    }

    public static interface ITaskMonitor {
        public void onTaskRejectedExecution(Runnable var1);

        public void onTaskException(Throwable var1, Runnable var2);

        public void onTaskStartInMainThread(long var1, Runnable var3);

        public void onTaskExecutedInMainThread(long var1, Runnable var3);

        public void onTaskRealStartExecute(long var1, long var3, Runnable var5, ThreadPoolExecutor var6);

        public void onTaskExecuted(long var1, long var3, Runnable var5, ThreadPoolExecutor var6);

        public void onTaskProbablyEndlessLoop(Runnable var1, int var2, int var3);

        public long getOneMinuteNumLimit();

        public long getFiveSecondNumLimit();
    }

    public static interface IIdleExecutorProxy {
        public IIdleExecutor createAIdleExecutor(String var1);
    }

    private static class CustomIdelHandler
    implements MessageQueue.IdleHandler {
        private static final MessageQueue mMainThreadQueue = (MessageQueue)ReflectionHelper.getFieldValue(Looper.getMainLooper(), "mQueue");
        private static final Handler mHandler = new HandlEx("IdleHandler", Looper.getMainLooper());
        private static final long mRunnableDelayTime = 10000L;
        private Runnable mRunnable;
        private final Runnable mPostRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (mMainThreadQueue != null) {
                    mMainThreadQueue.removeIdleHandler((MessageQueue.IdleHandler)this);
                }
                try {
                    mRunnable.run();
                }
                catch (Throwable e) {
                    if (SystemUtils.isShowEnvSetting()) {
                        YYTaskExecutor.getMainThreadHandler().post(new Runnable(){

                            @Override
                            public void run() {
                                throw new RuntimeException(YYTaskExecutor.getStackTraceString(e), e);
                            }
                        });
                    }
                    YYTaskExecutor.onTaskException(e, mRunnable);
                    MLog.error("YYTaskExecutor CustomIdelHandler error:", e);
                    Log.e((String)"CustomIdel error:", (String)(e != null ? e.toString() : ""));
                }
                HashMap hashMap = sMainThreadIdelRunnableCache;
                synchronized (hashMap) {
                    if (sMainThreadIdelRunnableCache.size() > 0) {
                        sMainThreadIdelRunnableCache.remove(mRunnable);
                    }
                }
            }
        };

        public CustomIdelHandler(Runnable runnable) {
            this.mRunnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean queueIdle() {
            mHandler.removeCallbacks(this.mPostRunnable);
            try {
                this.mRunnable.run();
            }
            catch (Throwable e) {
                if (SystemUtils.isShowEnvSetting()) {
                    YYTaskExecutor.getMainThreadHandler().post(new Runnable(){

                        @Override
                        public void run() {
                            throw new RuntimeException(YYTaskExecutor.getStackTraceString(e), e);
                        }
                    });
                }
                YYTaskExecutor.onTaskException(e, this.mRunnable);
                MLog.error("YYTaskExecutor CustomIdelHandler error:", e);
                Log.e((String)"CustomIdel error:", (String)(e != null ? e.toString() : ""));
            }
            HashMap hashMap = sMainThreadIdelRunnableCache;
            synchronized (hashMap) {
                if (sMainThreadIdelRunnableCache.size() > 0) {
                    sMainThreadIdelRunnableCache.remove(this.mRunnable);
                }
            }
            return false;
        }

        public void post() {
            if (mMainThreadQueue == null) {
                throw new Error("CustomIdelHandler main thread queue is null!");
            }
            mHandler.postDelayed(this.mPostRunnable, 10000L);
            mMainThreadQueue.addIdleHandler((MessageQueue.IdleHandler)this);
        }

        public void stop() {
            if (mMainThreadQueue != null) {
                mMainThreadQueue.removeIdleHandler((MessageQueue.IdleHandler)this);
                mHandler.removeCallbacks(this.mPostRunnable);
            }
        }
    }

    static abstract class ExecutorRunnable
    implements Runnable,
    Prioritized,
    Comparable<Prioritized> {
        private static final int MAX_POOL_SIZE = 100;
        private static volatile int HASH_ID = 1;
        private static final Object sPoolSync = new Object();
        private static int sPoolSize = 0;
        private static ExecutorRunnable sPool;
        Runnable task;
        Runnable callBack;
        int priority;
        int hashId;
        private ExecutorRunnable mNext;
        long submitMills;
        long delayMills;
        boolean needStat = true;

        public ExecutorRunnable() {
            this.resetHashId();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ExecutorRunnable obtain() {
            Object object = sPoolSync;
            synchronized (object) {
                if (sPool != null) {
                    ExecutorRunnable m = sPool;
                    sPool = m.mNext;
                    m.mNext = null;
                    --sPoolSize;
                    return m;
                }
            }
            return null;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        public int hashCode() {
            return this.hashId;
        }

        @Override
        public int compareTo(Prioritized loadTask) {
            return loadTask.getPriority() - this.priority;
        }

        private void reset() {
            this.task = null;
            this.callBack = null;
            this.priority = 10;
            this.submitMills = 0L;
            this.delayMills = 0L;
            this.resetHashId();
            this.needStat = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resetHashId() {
            Class<ExecutorRunnable> clazz = ExecutorRunnable.class;
            synchronized (ExecutorRunnable.class) {
                this.hashId = HASH_ID++;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void recycle() {
            this.reset();
            Object object = sPoolSync;
            synchronized (object) {
                if (sPoolSize < 100) {
                    this.mNext = sPool;
                    sPool = this;
                    ++sPoolSize;
                    this.needStat = true;
                }
            }
        }

        public String toString() {
            if (this.task != null) {
                return super.toString() + "_origin:" + this.task.toString();
            }
            return super.toString();
        }
    }

    private static class QueueRunnableExcuter
    implements IQueueTaskExecutor {
        private ArrayList<Runnable> mTasks = new ArrayList();
        private ExecutorRunnableCache mQueueExecutorRunnables = new ExecutorRunnableCache();
        private ExecutorRunnableCache mQueueDelayRunnables = new ExecutorRunnableCache();
        private boolean mRunning = false;
        private boolean useWorkThreadPool = false;
        private boolean delayUseMainThread = YYTaskExecutor.delayUseMainThread();
        private long lastExecuteNextTime = 0L;
        private boolean statOn = true;

        public QueueRunnableExcuter() {
        }

        public QueueRunnableExcuter(boolean useWorkThreadPool, boolean statTask) {
            this.useWorkThreadPool = useWorkThreadPool;
            this.statOn = statTask;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeNext() {
            ExecutorRunnable runnableToRun = null;
            QueueRunnableExcuter queueRunnableExcuter = this;
            synchronized (queueRunnableExcuter) {
                if (this.mRunning) {
                    if (sTaskMonitor != null && this.lastExecuteNextTime > 0L && this.mTasks.size() > 0 && this.statOn && SystemClock.uptimeMillis() - this.lastExecuteNextTime > 100000L) {
                        sTaskMonitor.onTaskProbablyEndlessLoop(this.mTasks.get(0), (int)(SystemClock.uptimeMillis() - this.lastExecuteNextTime), 3);
                    }
                    return;
                }
                if (this.mTasks.size() > 0 && this.mQueueExecutorRunnables.size() > 0) {
                    runnableToRun = this.mQueueExecutorRunnables.getExecutorRunnable(this.mTasks.get(0));
                    this.mRunning = true;
                    if (sTaskMonitor != null) {
                        this.lastExecuteNextTime = SystemClock.uptimeMillis();
                    }
                }
            }
            if (runnableToRun != null) {
                if (this.useWorkThreadPool) {
                    YYTaskExecutor.execute(runnableToRun, null, runnableToRun.delayMills, 5);
                } else {
                    YYTaskExecutor.execute(runnableToRun, null, runnableToRun.delayMills, runnableToRun.priority);
                }
            }
        }

        @Override
        public void execute(Runnable task, long delayMillis) {
            this.execute(task, delayMillis, 10);
        }

        @Override
        public void execute(Runnable task, long delayMillis, int priority) {
            this.execute(task, null, delayMillis, priority);
        }

        @Override
        public void execute(Runnable task, Runnable callback, long delayMillis) {
            this.execute(task, callback, delayMillis, 10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Runnable task, Runnable callBack, long delayMills, int priority) {
            if (task == null) {
                return;
            }
            if (delayMills > 0L) {
                this.deleteDelayTask(task);
                ExecutorRunnable delayRun = new ExecutorRunnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Runnable realTask = null;
                        QueueRunnableExcuter queueRunnableExcuter = this;
                        synchronized (queueRunnableExcuter) {
                            if (mQueueDelayRunnables.size() > 0 && mQueueDelayRunnables.removeTask(this.task) != null) {
                                realTask = this.task;
                            }
                        }
                        if (realTask != null) {
                            this.execute(realTask, this.callBack, 0L, this.priority);
                        }
                    }
                };
                QueueRunnableExcuter queueRunnableExcuter = this;
                synchronized (queueRunnableExcuter) {
                    delayRun.task = task;
                    delayRun.callBack = callBack;
                    this.mQueueDelayRunnables.putTask(task, delayRun);
                }
                delayRun.needStat = false;
                if (!this.delayUseMainThread) {
                    YYTaskExecutor.getDelayExecuteQueueThread().postDelayed((Runnable)delayRun, delayMills);
                } else {
                    YYTaskExecutor.postToMainThread(delayRun, delayMills);
                }
                return;
            }
            ExecutorRunnable executorRunnable = new ExecutorRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    QueueRunnableExcuter queueRunnableExcuter = this;
                    synchronized (queueRunnableExcuter) {
                        if (mTasks.size() > 0) {
                            mTasks.remove(this.task);
                        }
                        if (mQueueExecutorRunnables.size() > 0) {
                            mQueueExecutorRunnables.removeExecuteTask(this);
                        }
                        if (mTasks.size() > 0) {
                            mTasks.remove(this.task);
                        }
                        if (mQueueExecutorRunnables.size() > 0) {
                            mQueueExecutorRunnables.removeTask(this.task);
                        }
                    }
                    try {
                        if (statOn && sTaskMonitor != null && SystemUtils.isShowEnvSetting()) {
                            long curTime = SystemClock.uptimeMillis();
                            sTaskMonitor.onTaskRealStartExecute(this.submitMills, curTime, this.task, sThreadPool);
                            this.task.run();
                            sTaskMonitor.onTaskExecuted(this.submitMills, curTime, this.task, sThreadPool);
                        } else {
                            this.task.run();
                        }
                    }
                    catch (Throwable e) {
                        try {
                            if (SystemUtils.isShowEnvSetting()) {
                                YYTaskExecutor.getMainThreadHandler().post(new Runnable(){

                                    @Override
                                    public void run() {
                                        throw new RuntimeException(YYTaskExecutor.getStackTraceString(e), e);
                                    }
                                });
                            }
                            YYTaskExecutor.onTaskException(e, this.task);
                            MLog.error("YYTaskExecutor error:", e);
                            Log.e((String)"YYTaskExecutor error:", (String)(e != null ? e.toString() : ""));
                        }
                        catch (Throwable e2) {
                            MLog.error("YYTaskExecutor error:", e2);
                            Log.e((String)"YYTaskExecutor error:", (String)(e2 != null ? e2.toString() : ""));
                        }
                    }
                    QueueRunnableExcuter queueRunnableExcuter2 = this;
                    synchronized (queueRunnableExcuter2) {
                        mRunning = false;
                    }
                    if (this.callBack != null) {
                        YYTaskExecutor.getMainThreadHandler().post(this.callBack);
                    }
                    this.executeNext();
                }
            };
            executorRunnable.task = task;
            executorRunnable.callBack = callBack;
            executorRunnable.delayMills = delayMills;
            executorRunnable.priority = priority;
            executorRunnable.needStat = false;
            this.deleteDelayTask(task);
            QueueRunnableExcuter queueRunnableExcuter = this;
            synchronized (queueRunnableExcuter) {
                if (this.mTasks.size() > 0) {
                    this.mTasks.remove(task);
                }
                this.mTasks.add(task);
                this.mQueueExecutorRunnables.putTask(task, executorRunnable);
            }
            this.executeNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeTask(Runnable task) {
            if (task == null) {
                return;
            }
            this.deleteDelayTask(task);
            ExecutorRunnable executorRunnable = null;
            QueueRunnableExcuter queueRunnableExcuter = this;
            synchronized (queueRunnableExcuter) {
                if (this.mTasks.size() > 0) {
                    this.mTasks.remove(task);
                }
                if (this.mQueueExecutorRunnables.size() > 0) {
                    executorRunnable = this.mQueueExecutorRunnables.removeTask(task);
                }
            }
            if (executorRunnable != null) {
                YYTaskExecutor.removeTask(executorRunnable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deleteDelayTask(Runnable task) {
            if (task == null) {
                return;
            }
            ExecutorRunnable delayRunnable = null;
            QueueRunnableExcuter queueRunnableExcuter = this;
            synchronized (queueRunnableExcuter) {
                if (this.mQueueDelayRunnables.size() > 0) {
                    delayRunnable = this.mQueueDelayRunnables.removeTask(task);
                }
            }
            if (delayRunnable != null) {
                if (!this.delayUseMainThread && sDelayExecuteQueueHandler != null) {
                    YYTaskExecutor.getDelayExecuteQueueThread().removeCallbacks((Runnable)delayRunnable);
                } else {
                    YYTaskExecutor.removeRunnableFromMainThread(delayRunnable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ArrayList<Runnable> removeAllTask() {
            ArrayList<Runnable> tasks = null;
            QueueRunnableExcuter queueRunnableExcuter = this;
            synchronized (queueRunnableExcuter) {
                tasks = new ArrayList<Runnable>(this.mTasks.size());
                if (this.mTasks.size() > 0) {
                    tasks.addAll(this.mTasks);
                    this.mTasks.clear();
                }
                if (this.mQueueExecutorRunnables.size() > 0) {
                    this.mQueueExecutorRunnables.removeAllTask();
                }
                if (this.mQueueDelayRunnables.size() > 0) {
                    this.mQueueDelayRunnables.removeAllTask();
                }
            }
            return tasks;
        }
    }

    public static abstract class RunnableEx
    implements Runnable {
        private Object mArg;
        public boolean needStat = true;

        public Object getArg() {
            return this.mArg;
        }

        public void setArg(Object arg) {
            this.mArg = arg;
        }
    }
}

