/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.taskexecutor;

import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.HardwareUtils;
import com.yy.base.utils.StringUtils;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;

public class SdkNormalExecutorAdapter
implements Executor {
    private static int MAX_CONCURRENCY_TASKS = HardwareUtils.getCpuCoreCount() >= 4 ? 8 : 5;
    private AtomicInteger mCurrentActiveTasks = new AtomicInteger(0);
    private ArrayList<ProtoRunnable> mRunnablesToPost = new ArrayList(5);
    private ArrayList<ProtoRunnable> mRunnablesRunning = new ArrayList(10);
    private int mMaxConcurrencyTasks;
    private String mSdkDes;
    private boolean useWorkPriority = false;

    public SdkNormalExecutorAdapter(int maxConcurrencyTasks, String sdkDes) {
        this.mMaxConcurrencyTasks = maxConcurrencyTasks;
        this.mSdkDes = sdkDes;
        if (this.mMaxConcurrencyTasks <= 0) {
            this.mMaxConcurrencyTasks = MAX_CONCURRENCY_TASKS;
        }
        if (StringUtils.isEmpty(this.mSdkDes)) {
            this.mSdkDes = "SdkNormalExecutorAdapter";
        }
    }

    public void setUseWorkPriority(boolean useWorkPriority) {
        this.useWorkPriority = useWorkPriority;
    }

    @Override
    public void execute(Runnable task) {
        this.execute(task, this.useWorkPriority ? 5 : -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable task, int priority) {
        SdkNormalExecutorAdapter sdkNormalExecutorAdapter = this;
        synchronized (sdkNormalExecutorAdapter) {
            this.mRunnablesToPost.add(new ProtoRunnable(task, priority));
        }
        this.executeNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTaskToRun(Runnable task) {
        SdkNormalExecutorAdapter sdkNormalExecutorAdapter = this;
        synchronized (sdkNormalExecutorAdapter) {
            if (this.mRunnablesToPost.size() > 0) {
                for (ProtoRunnable item : this.mRunnablesToPost) {
                    if (item.mRunnable != task) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTaskFinished(ProtoRunnable runnable) {
        this.mCurrentActiveTasks.decrementAndGet();
        SdkNormalExecutorAdapter sdkNormalExecutorAdapter = this;
        synchronized (sdkNormalExecutorAdapter) {
            if (this.mRunnablesRunning.size() > 0) {
                this.mRunnablesRunning.remove(runnable);
            }
        }
        this.executeNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeNext() {
        ProtoRunnable myRunnable = null;
        SdkNormalExecutorAdapter sdkNormalExecutorAdapter = this;
        synchronized (sdkNormalExecutorAdapter) {
            if (this.mRunnablesToPost.size() > 0 && this.mCurrentActiveTasks.get() < this.mMaxConcurrencyTasks) {
                myRunnable = this.mRunnablesToPost.get(0);
                this.mRunnablesToPost.remove(0);
                this.mRunnablesRunning.add(myRunnable);
                if (myRunnable != null) {
                    this.mCurrentActiveTasks.incrementAndGet();
                }
            }
        }
        if (myRunnable != null) {
            if (myRunnable.getPriority() != -1) {
                YYTaskExecutor.execute((Runnable)myRunnable, 0L, myRunnable.getPriority());
            } else {
                YYTaskExecutor.execute(myRunnable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Runnable task) {
        ProtoRunnable itemFind = null;
        SdkNormalExecutorAdapter sdkNormalExecutorAdapter = this;
        synchronized (sdkNormalExecutorAdapter) {
            if (this.mRunnablesToPost.size() > 0) {
                for (ProtoRunnable item : this.mRunnablesToPost) {
                    if (item.mRunnable != task) continue;
                    this.mRunnablesToPost.remove(item);
                    itemFind = item;
                    break;
                }
            }
            if (itemFind == null) {
                if (this.mRunnablesRunning.size() > 0) {
                    for (ProtoRunnable item : this.mRunnablesRunning) {
                        if (item.mRunnable != task) continue;
                        this.mRunnablesRunning.remove(item);
                        itemFind = item;
                        break;
                    }
                }
                if (itemFind != null) {
                    YYTaskExecutor.removeTask(itemFind);
                }
            }
        }
        return itemFind != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Runnable> removeAll() {
        ArrayList<Runnable> tasksToDelete = new ArrayList<Runnable>();
        ArrayList<ProtoRunnable> tasksToDeleteFromPool = new ArrayList<ProtoRunnable>();
        SdkNormalExecutorAdapter sdkNormalExecutorAdapter = this;
        synchronized (sdkNormalExecutorAdapter) {
            if (this.mRunnablesToPost.size() > 0) {
                tasksToDelete.addAll(this.mRunnablesToPost);
                this.mRunnablesToPost.clear();
            }
            if (this.mRunnablesRunning.size() > 0) {
                tasksToDeleteFromPool.addAll(this.mRunnablesRunning);
                this.mRunnablesRunning.clear();
            }
        }
        for (Runnable runnable : tasksToDeleteFromPool) {
            YYTaskExecutor.removeTask(runnable);
        }
        return tasksToDelete;
    }

    private class ProtoRunnable
    implements Runnable {
        private Runnable mRunnable;
        private int priority = -1;

        public ProtoRunnable(Runnable runnable) {
            this.mRunnable = runnable;
        }

        public ProtoRunnable(Runnable runnable, int priority) {
            this.mRunnable = runnable;
            this.priority = priority;
        }

        public int getPriority() {
            return this.priority;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block6: {
                try {
                    if (this.mRunnable != null) {
                        this.mRunnable.run();
                    }
                    SdkNormalExecutorAdapter.this.onTaskFinished(this);
                    if (!RuntimeContext.sIsDebuggable || this.mRunnable == null) break block6;
                    SdkNormalExecutorAdapter sdkNormalExecutorAdapter = SdkNormalExecutorAdapter.this;
                    synchronized (sdkNormalExecutorAdapter) {
                        MLog.info(SdkNormalExecutorAdapter.this.mSdkDes, "onTaskFinished:" + this.mRunnable + "  RunnablesToPost" + SdkNormalExecutorAdapter.this.mRunnablesToPost.size(), new Object[0]);
                    }
                }
                catch (Throwable throwable) {
                    SdkNormalExecutorAdapter.this.onTaskFinished(this);
                    MLog.info(SdkNormalExecutorAdapter.this.mSdkDes, "onTaskFinished:" + this.mRunnable + " error:" + throwable, new Object[0]);
                    throw throwable;
                }
            }
        }

        public String toString() {
            return "ProtoRunnable{mRunnable=" + this.mRunnable + ", priority=" + this.priority + '}';
        }
    }
}

