/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.taskexecutor;

import android.os.Process;
import com.yy.base.logger.MLog;
import com.yy.base.logger.perf.PerfActionLog;
import com.yy.base.taskexecutor.ThreadHookHelper;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedThreadFactory
implements ThreadFactory {
    private static final AtomicInteger poolNumber = new AtomicInteger(1);
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String name;
    private final int priority;
    private final ThreadFactory factory;
    private final ThreadGroup group;

    public NamedThreadFactory(String name) {
        this(null, name, 10);
    }

    public NamedThreadFactory(String name, int priority) {
        this(null, name, priority);
    }

    public NamedThreadFactory(ThreadFactory factory, String name) {
        this(factory, name, 10);
    }

    public NamedThreadFactory(ThreadFactory factory, String name, int priority) {
        this.factory = factory;
        this.name = name;
        this.priority = priority;
        this.group = Thread.currentThread().getThreadGroup();
    }

    @Override
    public Thread newThread(Runnable r) {
        if (null == this.factory) {
            Runnable wrapperRunnable = () -> {
                try {
                    Process.setThreadPriority((int)this.priority);
                }
                catch (Throwable t) {
                    MLog.error((Object)"YYTaskExecutor", "setThreadPriority threw caught throwable", t, new Object[0]);
                }
                r.run();
            };
            String index = this.name + "#p-" + poolNumber.getAndIncrement() + "-t-" + this.threadNumber.getAndIncrement();
            Thread thread = new Thread(this.group, wrapperRunnable, index, 0L);
            if (thread.isDaemon()) {
                thread.setDaemon(false);
            }
            PerfActionLog.add("ThreadCreate_" + index, new Object[0]);
            return thread;
        }
        return NamedThreadFactory.setThreadName(this.factory.newThread(r), this.name);
    }

    public static Thread setThreadName(Thread t, String prefix) {
        t.setName(ThreadHookHelper.makeThreadName(t.getName(), prefix));
        return t;
    }
}

