/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.taskexecutor;

import android.os.SystemClock;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IFrequencyLimitExecutor;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;

public class FrequencyLimitExecutor
implements IFrequencyLimitExecutor {
    private static final String TAG = "FrequencyLimitExecutor";
    private volatile long mLastNotifyTime = -1L;
    private Runnable mHandleCachedNotifyRunnable = null;
    private volatile long mLastDelayTime = 0L;
    private volatile Runnable taskToRun;
    private long frequencyTime;
    private boolean runInMain;
    private IQueueTaskExecutor queueTaskExecutor;
    private int discardNum;
    private boolean delayUseMainThread;

    public FrequencyLimitExecutor(long time, boolean runInMainThread) {
        this(time, runInMainThread, null);
    }

    public FrequencyLimitExecutor(long time, boolean runInMainThread, IQueueTaskExecutor queueTaskExecutor) {
        this.frequencyTime = time;
        this.runInMain = runInMainThread;
        if (this.frequencyTime <= 0L) {
            throw new RuntimeException("\u9891\u7387\u9650\u5236\u7684\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e0");
        }
        this.queueTaskExecutor = queueTaskExecutor;
        this.delayUseMainThread = YYTaskExecutor.delayUseMainThread() || runInMainThread;
    }

    @Override
    public void updateTime(long time) {
        if (this.frequencyTime != time) {
            this.updateTimeInner(time);
        }
    }

    private synchronized void updateTimeInner(long time) {
        if (this.frequencyTime != time) {
            this.frequencyTime = time;
        }
        if (this.mHandleCachedNotifyRunnable != null) {
            if (this.delayUseMainThread) {
                YYTaskExecutor.removeRunnableFromMainThread(this.mHandleCachedNotifyRunnable);
            } else {
                YYTaskExecutor.getDelayExecuteQueueThread().removeCallbacks(this.mHandleCachedNotifyRunnable);
            }
        }
        this.executeReal();
    }

    @Override
    public synchronized void execute(Runnable task) {
        if (task == null) {
            return;
        }
        this.taskToRun = task;
        if (this.frequencyTime <= 0L) {
            this.executeReal();
            return;
        }
        long refreshTimeMaxGap = this.frequencyTime;
        long curTime = SystemClock.uptimeMillis();
        long timeGap = curTime - this.mLastNotifyTime;
        long delayTime = 0L;
        if (curTime > 0L && this.mLastNotifyTime > 0L && timeGap >= 0L && timeGap < refreshTimeMaxGap) {
            if (timeGap > 0L) {
                delayTime = refreshTimeMaxGap - timeGap;
            } else if (timeGap == 0L) {
                delayTime = this.mLastDelayTime > 0L ? this.mLastDelayTime : refreshTimeMaxGap;
            }
            if (delayTime > refreshTimeMaxGap) {
                delayTime = refreshTimeMaxGap;
            }
            this.mLastDelayTime = delayTime;
        } else {
            this.mLastDelayTime = delayTime;
        }
        if (this.mHandleCachedNotifyRunnable != null) {
            if (this.delayUseMainThread) {
                YYTaskExecutor.removeRunnableFromMainThread(this.mHandleCachedNotifyRunnable);
            } else {
                YYTaskExecutor.getDelayExecuteQueueThread().removeCallbacks(this.mHandleCachedNotifyRunnable);
            }
        } else {
            this.mHandleCachedNotifyRunnable = new Runnable(){

                @Override
                public void run() {
                    FrequencyLimitExecutor.this.executeReal();
                }
            };
        }
        if (delayTime > 0L) {
            ++this.discardNum;
            if (RuntimeContext.sIsDebuggable) {
                MLog.info(TAG, "discard num:%d, task:%s", this.discardNum, task);
            }
            if (this.delayUseMainThread) {
                YYTaskExecutor.postToMainThread(this.mHandleCachedNotifyRunnable, delayTime);
            } else {
                YYTaskExecutor.getDelayExecuteQueueThread().postDelayed(this.mHandleCachedNotifyRunnable, delayTime);
            }
        } else {
            if (RuntimeContext.sIsDebuggable) {
                MLog.info(TAG, "execute task:%s", this.discardNum, task);
            }
            this.executeReal();
        }
    }

    private synchronized void executeReal() {
        this.mLastNotifyTime = SystemClock.uptimeMillis();
        if (this.taskToRun != null) {
            final Runnable task = this.taskToRun;
            if (this.runInMain) {
                YYTaskExecutor.postToMainThread(new Runnable(){

                    @Override
                    public void run() {
                        task.run();
                    }
                });
            } else {
                if (this.queueTaskExecutor == null) {
                    this.queueTaskExecutor = YYTaskExecutor.createAQueueExcuter();
                }
                this.queueTaskExecutor.execute(task, 0L);
            }
            this.taskToRun = null;
        }
    }
}

