/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.stuckminor.loopermintor;

import android.util.Log;
import com.yy.base.logger.MLog;
import com.yy.base.stuckminor.base.IMsgListener;
import com.yy.base.stuckminor.base.MsgInfo;
import com.yy.base.stuckminor.loopermintor.MsgExcuteListener;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;

class LooperMsgMitor
implements MsgExcuteListener {
    private IMsgListener mMsgLis;
    private String mLogFilePath;
    private BufferedOutputStream mBos;

    LooperMsgMitor() {
    }

    public void enableDumpToFile(String path) {
        block6: {
            if (path == null || path.trim().length() == 0) {
                return;
            }
            this.mLogFilePath = path;
            if (this.mBos == null) {
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(path);
                    this.mBos = new BufferedOutputStream(fos);
                }
                catch (Exception e) {
                    if (fos == null) break block6;
                    try {
                        fos.close();
                    }
                    catch (Exception e1) {
                        Log.e((String)"LooperMsgMitor", (String)"Empty Catch on enableDumpToFile", (Throwable)e);
                    }
                }
            }
        }
    }

    public void setMsgListener(IMsgListener msgLis) {
        this.mMsgLis = msgLis;
    }

    @Override
    public void start(String msg, long startRealTime, long startCPUTime) {
    }

    @Override
    public void end(String msg, long startRealTime, long startCPUTime, long consumeRealTime, long consumeCPUTime) {
        if (this.mMsgLis == null) {
            return;
        }
        if (consumeRealTime > 100L) {
            MsgInfo info = LooperMsgMitor.getMsgInfo(msg, consumeRealTime, consumeCPUTime);
            if (info != null) {
                if (this.mLogFilePath != null) {
                    try {
                        this.mBos.write((info.toString() + "\n").getBytes());
                    }
                    catch (Exception e) {
                        MLog.error((Object)"LooperMsgMitor", "Empty Catch on end", e, new Object[0]);
                    }
                }
                this.mMsgLis.onMsgFinished(info);
            }
        } else {
            this.mMsgLis.onMsgFinished(consumeRealTime);
        }
    }

    private static MsgInfo getMsgInfo(String msg, long consumeRealTime, long consumeCPUTime) {
        if (msg == null) {
            return null;
        }
        MsgInfo info = new MsgInfo();
        try {
            info.setMsgID(LooperMsgMitor.getMsgID(msg));
            info.setTarget(LooperMsgMitor.getTarget(msg));
            info.setCallback(LooperMsgMitor.getCallBack(msg));
        }
        catch (Exception e) {
            Log.e((String)"", (String)"printStackTrace", (Throwable)e);
            return null;
        }
        info.setConsumeRealTime(consumeRealTime);
        info.setConsumeCPUTime(consumeCPUTime);
        return info;
    }

    private static String getCallBack(String msg) {
        int index;
        if (msg.contains("null")) {
            return "";
        }
        if (msg.contains("}") && (index = msg.lastIndexOf("}")) != -1 && index + 1 < msg.length()) {
            return msg.substring(index + 1, msg.length());
        }
        return "";
    }

    private static String getTarget(String msg) {
        if (msg.contains("(") && msg.contains(")")) {
            int indexL = msg.indexOf("(");
            int indexR = msg.indexOf(")");
            if (indexL != -1 && indexR != -1 && indexL + 1 < msg.length() && indexR > indexL + 1) {
                return msg.substring(indexL + 1, indexR);
            }
        } else if (msg.contains("{") && msg.contains("}")) {
            int indexL = msg.indexOf("{");
            int indexR = msg.indexOf("}");
            if (indexL != -1 && indexR != -1 && indexL + 1 < msg.length() && indexR > indexL + 1) {
                return msg.substring(indexL + 1, indexR);
            }
        }
        return "";
    }

    private static String getMsgID(String msg) {
        int index = msg.indexOf(":");
        if (index != -1 && index + 2 < msg.length()) {
            return msg.substring(index + 2, msg.length());
        }
        return "";
    }
}

