/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.stuckminor.loopermintor;

import android.content.Context;
import android.os.Looper;
import android.util.Printer;
import com.yy.base.stuckminor.base.IANRListener;
import com.yy.base.stuckminor.base.ILooperMonitor;
import com.yy.base.stuckminor.base.IMsgListener;
import com.yy.base.stuckminor.loopermintor.LooperANRMonitor;
import com.yy.base.stuckminor.loopermintor.LooperLoggerEx;
import com.yy.base.stuckminor.loopermintor.LooperMsgMitor;

public final class LooperMonitor
implements ILooperMonitor {
    private Looper mLooper = Looper.myLooper();
    private LooperLoggerEx mPrinter = new LooperLoggerEx();
    private LooperMsgMitor mStatsPA = new LooperMsgMitor();
    private LooperANRMonitor mANRPA;

    public LooperMonitor() {
        this.mPrinter.registerMsgExcuteListener(this.mStatsPA);
    }

    @Override
    public void start() {
        this.mLooper.setMessageLogging((Printer)this.mPrinter);
    }

    @Override
    public void stop() {
        this.mLooper.setMessageLogging(null);
        if (this.mANRPA != null) {
            this.mANRPA.stop();
        }
    }

    @Override
    public void setMsgListener(IMsgListener msgLis) {
        this.mStatsPA.setMsgListener(msgLis);
    }

    @Override
    public void setANRListener(Context context, IANRListener anrLis) {
        this.setANRListener(context, anrLis, 2000L);
    }

    @Override
    public void setANRListener(Context context, IANRListener anrLis, long timeOutTime) {
        this.setANRListener(context, anrLis, timeOutTime, null);
    }

    @Override
    public void setANRListener(Context context, IANRListener anrLis, long timeOutTime, Thread thread) {
        if (anrLis == null) {
            if (this.mANRPA != null) {
                this.mANRPA.setANRListener(anrLis);
                this.mPrinter.unregisterMsgExcuteListener(this.mANRPA);
            }
            this.mANRPA = null;
        } else {
            if (this.mANRPA == null) {
                this.mANRPA = new LooperANRMonitor(context, timeOutTime, thread);
            }
            this.mANRPA.setANRListener(anrLis);
            this.mPrinter.registerMsgExcuteListener(this.mANRPA);
        }
    }
}

