/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.okhttp.websocket.ws;

import com.yy.base.env.RuntimeContext;
import com.yy.base.okhttp.websocket.StatInitDelegate;
import com.yy.base.okhttp.websocket.ws.StatWebSocketListener;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.network.NetworkUtils;
import java.util.HashMap;

public class RpcStat {
    private static final String SNAME_IKXD_GAMEPROXY_D = "ikxd_gameproxy_d";
    private static final String SNAME_IKXD_ONLINE_D = "ikxd_online_d";
    private static final String STAT_ACT_RPC_PERFORMANCE = "rpcperf";
    public static final String STAT_REQ_TYPE_WS = "ws";
    public static final String STAT_REQ_TYPE_HTTP = "http";
    private static final long STAT_SUCCESS = 0L;
    private static final String STAT_CODE = "code";
    private static final String STAT_ERR_MSG = "err_msg";
    private static final String STAT_USE_TIME = "use_time";
    private static final String STAT_RPC_SNAME = "sname";
    private static final String STAT_RPC_RETRY_TIMES = "retry_times";
    private static final String STAT_RPC_SEND_SIZE = "send_size";
    private static final String STAT_RPC_RECEIVE_SIZE = "receive_size";
    private static final String STAT_IS_FRONT = "is_front";
    private static final String STAT_METHOD_URI = "method_uri";
    private static final String STAT_REQ_TYPE = "req_type";
    private static final String STAT_BIZ_TIME = "biz_time";
    private static final String STAT_DATA_PARSE_TIME = "data_parse_time";
    private static final String STAT_CUR_QUEUE_LENGTH = "cur_queue_length";
    private static final String STAT_METRIC_NET_RT = "net_rt";
    private static final String STAT_METRIC_DATA_PARSE = "data_parse";
    private static final String STAT_METRIC_BIZ_TIME = "biz_time";
    private static final String STAT_METRIC_HOST = "host";
    private static final String STAT_METRIC_AB_VALUE = "ab_value";

    public static void statRpcSuccess(String sName, String methodOrUri, long useTime, int sendSize, int receiveSize, int retryTimes) {
        RpcStat.statRpcSuccess(0L, sName, methodOrUri, useTime, sendSize, receiveSize, retryTimes, "", useTime, useTime, -1);
    }

    public static void statRpcSuccess(long code, String sName, String methodOrUri, long useTime, int sendSize, int receiveSize, int retryTimes, String type, long bizTime, long dataParseTime, int wsQueueLength) {
        if (!StatInitDelegate.isStatSwitchOn(sName, methodOrUri)) {
            return;
        }
        HashMap<String, String> statMap = new HashMap<String, String>();
        statMap.put(STAT_CODE, code + "");
        statMap.put(STAT_USE_TIME, useTime + "");
        statMap.put(STAT_RPC_SNAME, sName);
        statMap.put(STAT_RPC_SEND_SIZE, sendSize + "");
        statMap.put(STAT_RPC_RECEIVE_SIZE, receiveSize + "");
        statMap.put(STAT_RPC_RETRY_TIMES, retryTimes + "");
        statMap.put(STAT_METHOD_URI, methodOrUri);
        statMap.put(STAT_IS_FRONT, RuntimeContext.sIsForeground ? "1" : "0");
        statMap.put(STAT_REQ_TYPE, type);
        statMap.put("biz_time", bizTime + "");
        statMap.put(STAT_DATA_PARSE_TIME, dataParseTime + "");
        statMap.put(STAT_CUR_QUEUE_LENGTH, wsQueueLength + "");
        StatInitDelegate.stat(statMap, STAT_ACT_RPC_PERFORMANCE, false);
    }

    public static HashMap<String, String> buildMetricMoreInfoMap(long code, String sName, int sendSize, int receiveSize, int retryTimes, String type, int wsQueueLength, String errMsg, String host, long netRt, long dataParse, long bizTime, String abValue) {
        HashMap<String, String> statMap = new HashMap<String, String>();
        statMap.put(STAT_CODE, code + "");
        statMap.put(STAT_RPC_SNAME, sName);
        statMap.put(STAT_RPC_SEND_SIZE, sendSize + "");
        statMap.put(STAT_RPC_RECEIVE_SIZE, receiveSize + "");
        statMap.put(STAT_RPC_RETRY_TIMES, retryTimes + "");
        statMap.put(STAT_IS_FRONT, RuntimeContext.sIsForeground ? "1" : "0");
        statMap.put(STAT_REQ_TYPE, type);
        statMap.put(STAT_CUR_QUEUE_LENGTH, wsQueueLength + "");
        statMap.put(STAT_ERR_MSG, errMsg + StatWebSocketListener.sErrorMsg);
        statMap.put(STAT_METRIC_NET_RT, "" + netRt);
        statMap.put(STAT_METRIC_DATA_PARSE, "" + dataParse);
        statMap.put("biz_time", "" + bizTime);
        statMap.put(STAT_METRIC_HOST, host);
        statMap.put(STAT_METRIC_AB_VALUE, abValue);
        return statMap;
    }

    public static void statRpcFail(String sName, String methodOrUri, long useTime, String errMsg, int retryTimes, int code) {
        RpcStat.statRpcFail(sName, methodOrUri, useTime, errMsg, retryTimes, code, "", useTime, useTime);
    }

    public static void statRpcFail(String sName, String methodOrUri, long useTime, String errMsg, int retryTimes, int code, String type, long bizTime, long dataParseTime) {
        if (!StatInitDelegate.isStatSwitchOn(sName, methodOrUri)) {
            return;
        }
        code = NetworkUtils.isNetworkAvailable(RuntimeContext.sApplicationContext) ? (StringUtils.equalsIgnoreCase("" + code, "0") ? 111 : code) : 250;
        HashMap<String, String> statMap = new HashMap<String, String>();
        statMap.put(STAT_CODE, code + "");
        statMap.put(STAT_USE_TIME, useTime + "");
        statMap.put(STAT_RPC_SNAME, sName);
        statMap.put(STAT_RPC_RETRY_TIMES, retryTimes + "");
        statMap.put(STAT_ERR_MSG, errMsg + StatWebSocketListener.sErrorMsg);
        statMap.put(STAT_IS_FRONT, RuntimeContext.sIsForeground ? "1" : "0");
        statMap.put(STAT_METHOD_URI, methodOrUri);
        statMap.put(STAT_REQ_TYPE, type);
        statMap.put("biz_time", bizTime + "");
        statMap.put(STAT_DATA_PARSE_TIME, dataParseTime + "");
        StatInitDelegate.stat(statMap, STAT_ACT_RPC_PERFORMANCE, false);
    }
}

