/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.okhttp.websocket.ws;

import com.yy.base.okhttp.websocket.ws.RealWebSocket;
import com.yy.base.okhttp.websocket.ws.StatWebSocketListener;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Dns;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;

public class OkHttpWsClientWrap
implements WebSocket.Factory,
StatWebSocketListener.WebSocketRequestInfo {
    private OkHttpClient mOkHttpClient;
    private volatile int mNewWebSocketTimes = 0;
    private volatile int mPreWebSocketTimes = 0;
    private volatile int mOpenTimes = 0;
    private volatile long mTimestamp = System.currentTimeMillis();
    private volatile boolean isUseCommonState = true;

    private OkHttpWsClientWrap(Builder build) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(build.connectTimeout, build.connectTimeoutTimeUnit).pingInterval(build.pingInterval, build.pingTimeUnit).connectionPool(new ConnectionPool(1, 3600L, TimeUnit.SECONDS));
        if (build.dns != null) {
            builder.dns(build.dns);
        }
        this.mOkHttpClient = builder.build();
        this.mOkHttpClient.dispatcher().setMaxRequestsPerHost(1);
    }

    public OkHttpWsClientWrap(OkHttpClient.Builder builder) {
        this.mOkHttpClient = builder.build();
    }

    public WebSocket newWebSocket(Request request, WebSocketListener listener) {
        ++this.mNewWebSocketTimes;
        this.mPreWebSocketTimes = this.mNewWebSocketTimes;
        WebSocketListener webSocketListener = this.isUseCommonState ? new StatWebSocketListener(listener, this) : listener;
        RealWebSocket webSocket = new RealWebSocket(request, webSocketListener, new Random(), 0L, 0);
        webSocket.connect(this.mOkHttpClient);
        return webSocket;
    }

    @Override
    public int connectTimes() {
        return this.mPreWebSocketTimes;
    }

    @Override
    public void onOpen() {
        ++this.mOpenTimes;
        this.mNewWebSocketTimes = 0;
        this.mTimestamp = System.currentTimeMillis();
    }

    @Override
    public boolean isFirstConnect() {
        return this.mOpenTimes == 0 || this.mOpenTimes == 1;
    }

    @Override
    public long connectTimestampId() {
        return this.mTimestamp;
    }

    public void setUseCommonState(boolean useCommonState) {
        this.isUseCommonState = useCommonState;
    }

    public static class Builder {
        private long connectTimeout = 10000L;
        private TimeUnit connectTimeoutTimeUnit = TimeUnit.MILLISECONDS;
        private long pingInterval = 0L;
        private TimeUnit pingTimeUnit = TimeUnit.MILLISECONDS;
        private Dns dns;

        public Builder connectTimeout(long timeout, TimeUnit unit) {
            this.connectTimeout = timeout;
            this.connectTimeoutTimeUnit = unit;
            return this;
        }

        public Builder pingInterval(long interval, TimeUnit unit) {
            this.pingInterval = interval;
            this.pingTimeUnit = unit;
            return this;
        }

        public Builder dns(Dns dns) {
            this.dns = dns;
            return this;
        }

        public OkHttpWsClientWrap build() {
            return new OkHttpWsClientWrap(this);
        }
    }
}

