/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.okhttp.websocket;

import android.net.NetworkInfo;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.okhttp.websocket.HeadersCreator;
import com.yy.base.okhttp.websocket.WsCallback;
import com.yy.base.okhttp.websocket.WsStatus;
import com.yy.base.okhttp.websocket.ws.OkHttpWsClientWrap;
import com.yy.base.okhttp.websocket.ws.RealWebSocket;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.network.NetworkChangeListener;
import com.yy.base.utils.network.NetworkUtils;
import java.util.concurrent.TimeUnit;
import okhttp3.Dns;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;

public class WsClient
implements NetworkChangeListener {
    private static final String TAG = "WsClient";
    private static final String TAG_CONNECT = "\u957f\u8fde\u63a5\u72b6\u6001";
    private static final long PING_INTERVAL = 20L;
    private static final long CONNECT_TIMEOUT = 30L;
    private static final long BACKGROUND_MAX_TIME_RECONNECT = 180000L;
    private static final int DEFAULT_RECONNECT_COUNT_MAX = 8;
    private static final String MYSELF_CLOSE_REASON = "close by myself";
    private static HeadersCreator mHeadersCreator;
    private static volatile boolean mUseGzip;
    private String mUri;
    private OkHttpWsClientWrap mHagoWsClient;
    private volatile WebSocket mWebSocket;
    private int mMaxReconnect = 8;
    private WsCallback mWsCallback;
    private volatile WsStatus mCurStatus = WsStatus.CONNECT_NONE;
    private int mCurReconnectCount = 0;
    public int mConnectSeq = 0;
    public static int sSeq;
    public static final int KICKOFF_CODE = 4000;
    public static final int KICKOFF_CODE_BY_OUR_OTHER_APP = 4004;
    public static final int BANNED_CODE = 4002;
    public static final int TOKEN_PARSE_FAIL = 4101;
    public static final int MYSELF_CLOSE_CODE = 1000;
    public static final int TEST_ENV_NOT_IN_WHITE_LIST = 4010;
    public static final int UNKNOWN_DISCONNECT = 0;
    private int disconnectReason = 0;
    public static final int NETWORK_UNAVAILABLE_CODE = -2;
    public static final int UNKNOWN_CODE = -1;
    public static final int NO_TOKEN = 100;
    public static final int ERROR_URL = 101;
    public static final int CONNECT_SUCCESS = 102;
    public static final int CONNECTING = 103;
    private static final int RECONNECT_MAX_TIME = 0;
    private boolean mNetValid;
    private boolean mOpen = false;
    private long mBackgroundTime = -1L;
    private static volatile Dns mDns;
    private final MyRunnable mReConnectTask = new MyRunnable(){

        @Override
        public void run() {
            WsClient.this.tryReconnect(this.tryLog);
        }
    };
    private WebSocketListener mWebSocketListener = new WebSocketListener(){

        public void onOpen(WebSocket webSocket, Response response) {
            super.onOpen(webSocket, response);
            MLog.info(WsClient.TAG, "[socket:%d] onOpen url: %s, response: %s", webSocket.hashCode(), WsClient.this.mUri, response);
            if (webSocket != WsClient.this.mWebSocket) {
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug(WsClient.TAG, "not current websocket onOpen", new Object[0]);
                }
                return;
            }
            YYTaskExecutor.removeTask(WsClient.this.mReConnectTask);
            WsClient.this.setStatus(WsStatus.CONNECT_SUCCESS);
            WsClient.this.mCurReconnectCount = 0;
            if (WsClient.this.mWsCallback != null) {
                WsClient.this.mWsCallback.onConnectSucceed(WsClient.this, WsClient.this.mUri);
            }
        }

        public void onMessage(WebSocket webSocket, String text) {
            super.onMessage(webSocket, text);
            MLog.error((Object)WsClient.TAG, "\u670d\u52a1\u5668\u8fd4\u56de\u9519\u8bef\u7684\u683c\u5f0f", new Object[0]);
            if (webSocket != WsClient.this.mWebSocket) {
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug(WsClient.TAG, "not current websocket onMessage.text", new Object[0]);
                }
                return;
            }
            if (WsClient.this.mWsCallback != null) {
                WsClient.this.mWsCallback.onResponse(WsClient.this, WsClient.this.mUri, text);
            }
        }

        public void onMessage(WebSocket webSocket, ByteString bytes) {
            super.onMessage(webSocket, bytes);
            if (webSocket != WsClient.this.mWebSocket) {
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug(WsClient.TAG, "not current websocket onMessage.bytes", new Object[0]);
                }
                return;
            }
            if (WsClient.this.mWsCallback != null) {
                WsClient.this.mWsCallback.onResponse(WsClient.this, WsClient.this.mUri, bytes.toByteArray());
            }
        }

        public void onClosing(WebSocket webSocket, int code, String reason) {
            super.onClosing(webSocket, code, reason);
            MLog.info(WsClient.TAG, "[socket:%d] onClosing url: %s, code: %d, reason: %s", webSocket.hashCode(), WsClient.this.mUri, code, reason);
            if (webSocket != WsClient.this.mWebSocket) {
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug(WsClient.TAG, "not current websocket onClosed", new Object[0]);
                }
                return;
            }
            if (WsClient.this.mWebSocket != null) {
                WsClient.this.close(false, "\u670d\u52a1\u5668\u4e3b\u52a8\u5173\u95ed");
            }
            WsClient.this.setStatus(WsStatus.CONNECT_FAIL);
            MLog.error((Object)WsClient.TAG, "\u670d\u52a1\u5668\u81ea\u5df1\u5173\u95ed, code:" + code + ", reason:" + reason, new Object[0]);
            WsClient.this.disconnectReason = code;
            if (WsClient.this.mWsCallback != null) {
                WsClient.this.mWsCallback.onDisconnect(WsClient.this, WsClient.this.mUri, code);
            }
        }

        public void onClosed(WebSocket webSocket, int code, String reason) {
            super.onClosed(webSocket, code, reason);
            MLog.info(WsClient.TAG, "[socket:%d] onClosed url: %s, code: %d, reason: %s", webSocket.hashCode(), WsClient.this.mUri, code, reason);
        }

        public void onFailure(WebSocket webSocket, Throwable t, Response response) {
            super.onFailure(webSocket, t, response);
            MLog.info(WsClient.TAG, "[socket:%d] onFailure url: %s, throwable: %s, response: %s", webSocket.hashCode(), WsClient.this.mUri, t, response);
            if (webSocket != WsClient.this.mWebSocket) {
                return;
            }
            if (WsClient.this.mWebSocket != null) {
                WsClient.this.close(false, "\u8fde\u63a5\u670d\u52a1\u5668\u5931\u8d25\uff0c\u5173\u95ed\u540e\u91cd\u8bd5");
            }
            WsClient.this.setStatus(WsStatus.CONNECT_FAIL);
            WsClient.this.tryReconnect(WsClient.this.reconnectInterval(), "\u53d1\u8d77\u91cd\u8fde\uff1a\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25");
            if (WsClient.this.mWsCallback != null) {
                WsClient.this.mWsCallback.onError(WsClient.this, WsClient.this.mUri, -1, t != null ? t.toString() : "");
            }
        }
    };
    private final long[] intervals = new long[]{500L, 1000L, 3000L, 5000L, 8000L, 12000L};

    public static int newSocketSeq() {
        return sSeq++;
    }

    public static void setHeadersCreator(HeadersCreator creator, boolean useGzip) {
        mHeadersCreator = creator;
        mUseGzip = useGzip;
    }

    public static boolean isUseSupportGzip() {
        return mUseGzip;
    }

    public WsClient(@NonNull String uri) {
        this.mUri = uri;
        this.mHagoWsClient = new OkHttpWsClientWrap.Builder().connectTimeout(30L, TimeUnit.SECONDS).pingInterval(20L, TimeUnit.SECONDS).dns(mDns).build();
    }

    public static void setDns(Dns dns) {
        mDns = dns;
    }

    public int identifySeq() {
        return this.mConnectSeq;
    }

    public void open() {
        this.mOpen = true;
        this.disconnectReason = 0;
        if (this.mNetValid) {
            MLog.info(TAG_CONNECT, "\u6253\u5f00", new Object[0]);
            this.connect("\u6253\u5f00");
        } else {
            MLog.info(TAG_CONNECT, "\u6253\u5f00\uff1a\u5931\u8d25\uff0c\u7f51\u7edc\u672a\u8fde\u63a5", new Object[0]);
        }
    }

    public void watchNetChange() {
        this.mNetValid = NetworkUtils.isNetworkAvailable(RuntimeContext.sApplicationContext);
        NetworkUtils.addNetworkChangeListener(this);
    }

    public void removeWatchNet() {
        NetworkUtils.removeNetworkChangeListener(this);
    }

    @Override
    public void onChange(int networkTyp, NetworkInfo info) {
        boolean change = NetworkUtils.isNetworkAvailable(RuntimeContext.sApplicationContext);
        if (change == this.mNetValid) {
            return;
        }
        this.mNetValid = change;
        if (!this.mOpen) {
            return;
        }
        if (this.mNetValid) {
            MLog.info(TAG, "the network is connected, tryReconnect right now", new Object[0]);
            this.mCurReconnectCount = 0;
            this.tryReconnect(0L, "\u53d1\u8d77\u91cd\u8fde\uff1a\u7f51\u7edc\u8fde\u63a5\u72b6\u6001\u53d8\u6210\u5df2\u8fde\u63a5");
        } else {
            MLog.info(TAG, "the network  disconnected", new Object[0]);
            this.close(true, "\u7f51\u7edc\u8fde\u63a5\u72b6\u6001\u53d8\u6210\u672a\u8fde\u63a5\uff0c\u5173\u95ed\u957f\u8fde\u63a5; \u7b49\u5f85\u7f51\u7edc\u8fde\u63a5\u518d\u91cd\u8bd5");
        }
    }

    public boolean send(String msg) {
        WebSocket socket = this.mWebSocket;
        WsStatus status = this.mCurStatus;
        if (!this.checkWs(socket, status)) {
            return false;
        }
        return socket.send(msg);
    }

    public boolean send(byte[] bs) {
        if (bs == null || bs.length == 0) {
            return false;
        }
        WebSocket socket = this.mWebSocket;
        WsStatus status = this.mCurStatus;
        if (!this.checkWs(socket, status)) {
            return false;
        }
        return socket.send(ByteString.of((byte[])bs));
    }

    public boolean send(ByteString bs) {
        WebSocket socket = this.mWebSocket;
        WsStatus status = this.mCurStatus;
        if (!this.checkWs(socket, status)) {
            return false;
        }
        return socket.send(bs);
    }

    public void close(boolean resetState, String reasonLog) {
        MLog.info(TAG, "close resetState: %b, reasonLog: %s, mWebSocket: %s, mCurStatus: %s, mUri: %s", new Object[]{resetState, reasonLog, this.mWebSocket, this.mCurStatus, this.mUri});
        WebSocket socket = this.mWebSocket;
        this.mWebSocket = null;
        if (socket != null) {
            MLog.info(TAG_CONNECT, "\u5173\u95ed\u8fde\u63a5,\u539f\u56e0-%s \u8fde\u63a5\u5730\u5740-%s \u5173\u95ed\u524d\u72b6\u6001-%s", new Object[]{reasonLog, this.mUri, this.mCurStatus});
            if (resetState) {
                this.setStatus(WsStatus.CONNECT_NONE);
            }
            socket.close(1000, MYSELF_CLOSE_REASON);
        }
    }

    public long queueSize() {
        WebSocket socket = this.mWebSocket;
        if (socket != null) {
            return socket.queueSize();
        }
        return -1L;
    }

    public int queueLength() {
        WebSocket socket = this.mWebSocket;
        if (socket instanceof RealWebSocket) {
            return ((RealWebSocket)socket).queueLength();
        }
        return -1;
    }

    public void destroy() {
        YYTaskExecutor.removeTask(this.mReConnectTask);
        this.removeWatchNet();
        this.close(true, "\u9500\u6bc1\u8be5\u6761\u957f\u8fde\u63a5");
        this.mWsCallback = null;
    }

    public void setWsCallback(WsCallback callback) {
        this.mWsCallback = callback;
    }

    public void setMaxReconnectTime(int max) {
        this.mMaxReconnect = max;
    }

    public boolean checkWs() {
        if (this.mWebSocket == null) {
            MLog.error((Object)TAG, "web socket had not create", new Object[0]);
            return false;
        }
        if (this.mCurStatus != WsStatus.CONNECT_SUCCESS) {
            MLog.error((Object)TAG, "web socket had not connected", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean checkWs(WebSocket webSocket, WsStatus status) {
        if (webSocket == null) {
            MLog.error((Object)TAG, "web socket had not create", new Object[0]);
            return false;
        }
        if (status != WsStatus.CONNECT_SUCCESS) {
            MLog.error((Object)TAG, "web socket had not connected", new Object[0]);
            return false;
        }
        return true;
    }

    public void connect(String connectLogType) {
        WebSocket webSocket;
        this.mConnectSeq = WsClient.newSocketSeq();
        MLog.info(TAG_CONNECT, "\u5f00\u59cb\u8fde\u63a5\uff1a%s \u521b\u5efa\u8fde\u63a5url: %s", connectLogType, this.mUri);
        Headers headers = mHeadersCreator != null ? mHeadersCreator.headers() : new Headers.Builder().build();
        Request request = new Request.Builder().get().headers(headers).url(this.mUri).build();
        this.mWebSocket = this.mHagoWsClient.newWebSocket(request, this.mWebSocketListener);
        this.setStatus(WsStatus.CONNECTING);
        if (this.mWsCallback != null) {
            this.mWsCallback.onConnecting(this, this.mUri, 103);
        }
        if ((webSocket = this.mWebSocket) == null) {
            this.setStatus(WsStatus.CONNECT_FAIL);
            this.tryReconnect(this.reconnectInterval(), "\u53d1\u8d77\u91cd\u8fde\uff1a\u521b\u5efa\u8fde\u63a5\u5f02\u5e38");
            MLog.info(TAG, "url: %s", this.mUri);
        } else {
            MLog.info(TAG, "[Socket:%s] connect url: %s", webSocket.hashCode(), this.mUri);
        }
    }

    private void tryReconnect(long delay, String tryLog) {
        if (this.mMaxReconnect == -1 || this.mCurReconnectCount < this.mMaxReconnect) {
            MLog.info(TAG, "tryReconnect url: %s, dealy:%d", this.mUri, delay);
            YYTaskExecutor.removeTask(this.mReConnectTask);
            if (delay <= 0L) {
                this.tryReconnect(tryLog);
            } else {
                this.mReConnectTask.tryLog = tryLog;
                YYTaskExecutor.execute((Runnable)this.mReConnectTask, delay);
            }
        } else if (this.mCurReconnectCount >= this.mMaxReconnect && this.mMaxReconnect > 0) {
            if (this.mWsCallback != null) {
                this.mWsCallback.onConnectFailed(this, this.mUri, 0);
            }
            MLog.info(TAG, "connect failed after try max times:", this.mCurReconnectCount);
        } else {
            MLog.info(TAG, "tryReconnect failed, the status wrong %s", new Object[]{this.mCurStatus});
        }
    }

    public void tryReconnect(String tryLog) {
        long interval;
        if (this.disconnectReason != 0) {
            MLog.info(TAG, "disconnectReason is %d ,stop reconnecting", this.disconnectReason);
            return;
        }
        if (!this.mNetValid) {
            MLog.info(TAG, "as the network is invalid, stop reconnecting", new Object[0]);
            return;
        }
        long cur = SystemClock.elapsedRealtime();
        if (!(this.mBackgroundTime <= 0L || this.mWsCallback != null && this.mWsCallback.isEnableBackgroundReconnect(this, this.mUri) || (interval = Math.abs(cur - this.mBackgroundTime)) <= 180000L)) {
            MLog.info(TAG, "tryReconnect mBackgroundTime: %d, stay background: %d, exceed BACKGROUND_MAX_TIME_RECONNECT\uff1a %d", this.mBackgroundTime, interval, 180000L);
            return;
        }
        this.close(true, "\u91cd\u8fde\uff1a\u5148\u5173\u95ed\u8fde\u63a5\uff0c\u518d\u91cd\u8fde");
        this.connect(tryLog);
        ++this.mCurReconnectCount;
    }

    private void setStatus(WsStatus status) {
        this.mCurStatus = status;
        switch (status) {
            case CONNECTING: {
                MLog.info(TAG_CONNECT, "\u957f\u8fde\u63a5\u8fde\u63a5\u4e2d...", new Object[0]);
                break;
            }
            case CONNECT_FAIL: {
                MLog.info(TAG_CONNECT, "\u957f\u8fde\u63a5\u8fde\u63a5\u5931\u8d25", new Object[0]);
                break;
            }
            case CONNECT_SUCCESS: {
                MLog.info(TAG_CONNECT, "\u957f\u8fde\u63a5\u8fde\u63a5\u6210\u529f", new Object[0]);
                break;
            }
            case CONNECT_NONE: {
                MLog.info(TAG, "\u957f\u8fde\u63a5\u72b6\u6001\u91cd\u7f6e", new Object[0]);
                break;
            }
        }
    }

    public WsStatus getStatuse() {
        return this.mCurStatus;
    }

    private long reconnectInterval() {
        int rc;
        long spends = 500L;
        long randomSpends = 0L;
        int maxConnect = 8;
        if (this.mMaxReconnect > 0) {
            maxConnect = this.mMaxReconnect;
        }
        if (this.intervals.length > (rc = this.mCurReconnectCount % maxConnect)) {
            spends = this.intervals[rc];
            randomSpends = (long)(Math.random() * 500.0 * (double)this.mCurReconnectCount);
        }
        return spends + randomSpends;
    }

    public void changeToForeground() {
        MLog.info(TAG, "\u524d\u540e\u53f0\u53d1\u751f\u53d8\u5316", new Object[0]);
        this.mBackgroundTime = -1L;
        this.mNetValid = NetworkUtils.isNetworkAvailable(RuntimeContext.sApplicationContext);
        if (!this.mNetValid) {
            this.close(true, "\u524d\u540e\u53f0\u5207\u6362\uff1a\u5207\u5230\u524d\u53f0\uff0c\u5f53\u7f51\u7edc\u672a\u8fde\u63a5\u65f6\uff0c\u5173\u95ed\u957f\u8fde\u63a5");
        } else if (!this.checkWs()) {
            this.tryReconnect("\u53d1\u8d77\u91cd\u8fde\uff1a\u524d\u540e\u53f0\u5207\u6362\uff1a\u5207\u5230\u524d\u53f0");
        }
    }

    public void changeToBackground() {
        this.mBackgroundTime = SystemClock.elapsedRealtime();
    }

    static {
        mUseGzip = false;
        sSeq = 0;
    }

    public abstract class MyRunnable
    implements Runnable {
        public String tryLog;
    }
}

