/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.okhttp.request;

import com.yy.base.okhttp.callback.Callback;
import com.yy.base.okhttp.request.CountingRequestBody;
import com.yy.base.okhttp.request.Delivery;
import com.yy.base.okhttp.request.OkHttpRequest;
import java.io.File;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public class PostFileRequest
extends OkHttpRequest {
    private static MediaType MEDIA_TYPE_STREAM = MediaType.parse((String)"application/octet-stream");
    private File file;
    private MediaType mediaType;

    public PostFileRequest(OkHttpClient executor, String url, Object tag, Map<String, String> params, Map<String, String> headers, File file, MediaType mediaType, int id2) {
        super(executor, url, tag, params, headers, id2);
        this.file = file;
        this.mediaType = mediaType;
        if (this.file == null) {
            throw new IllegalArgumentException("the file can not be null !");
        }
        if (this.mediaType == null) {
            this.mediaType = MEDIA_TYPE_STREAM;
        }
    }

    @Override
    protected RequestBody buildRequestBody() {
        return RequestBody.create((MediaType)this.mediaType, (File)this.file);
    }

    @Override
    protected RequestBody wrapRequestBody(RequestBody requestBody, final Callback callback) {
        if (callback == null) {
            return requestBody;
        }
        CountingRequestBody countingRequestBody = new CountingRequestBody(requestBody, new CountingRequestBody.Listener(){

            @Override
            public void onRequestProgress(long bytesWritten, long contentLength) {
                Delivery.instance.sendProgressCallback(callback, bytesWritten, contentLength, PostFileRequest.this.id);
            }
        });
        return countingRequestBody;
    }

    @Override
    protected Request.Builder buildRequest(RequestBody requestBody) {
        return this.builder.post(requestBody);
    }
}

