/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.okhttp;

import com.yy.base.logger.MLog;
import java.io.IOException;
import okhttp3.CipherSuite;
import okhttp3.Handshake;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.TlsVersion;

public class SSLHandshakeInterceptor
implements Interceptor {
    private static final String TAG = "OkHttp3-SSLHandshake";

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response = chain.proceed(chain.request());
        this.printTlsAndCipherSuiteInfo(response);
        return response;
    }

    private void printTlsAndCipherSuiteInfo(Response response) {
        Handshake handshake;
        if (response != null && (handshake = response.handshake()) != null) {
            CipherSuite cipherSuite = handshake.cipherSuite();
            TlsVersion tlsVersion = handshake.tlsVersion();
            MLog.debug(TAG, "TLS: " + tlsVersion + ", CipherSuite: " + cipherSuite + " url = " + response.request().url().toString(), new Object[0]);
        }
    }
}

