/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.okhttp;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.okhttp.OkHttpUtils;
import com.yy.base.okhttp.SSLHandshakeInterceptor;
import com.yy.base.okhttp.TrustManagerUtils;
import com.yy.base.okhttp.listener.OkHttpStat;
import com.yy.base.taskexecutor.DefaultThreadFactory;
import com.yy.base.taskexecutor.YYNormalThreadPoolExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.MD5Utils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.grace.Call;
import com.yy.grace.Callback;
import com.yy.grace.Converter;
import com.yy.grace.Grace;
import com.yy.grace.NetworkConverter;
import com.yy.grace.NetworkInterceptor;
import com.yy.grace.Request;
import com.yy.grace.Response;
import com.yy.grace.ResponseBody;
import com.yy.grace.converter.file.FileCallback;
import com.yy.grace.converter.file.FileConverterFactory;
import com.yy.grace.converter.gson.GsonBodyConverterFactory;
import com.yy.grace.network.cronet.NetworkCronet;
import com.yy.grace.network.okhttp.ClientProvider;
import com.yy.grace.network.okhttp.NetworkOkHttp;
import com.yy.grace.networkinterceptor.BizScenc;
import com.yy.grace.networkinterceptor.GraceNetworkInterceptor;
import com.yy.grace.strategy.DefaultRetryStrategy;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionSpec;
import okhttp3.Dispatcher;
import okhttp3.Dns;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;

public class GraceUtil {
    private static final String TEXT_PLAIN_CHARSET_UTF_8 = "text/plain;charset=utf-8";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String APPLICATION_JSON_CHARSET_UTF_8 = "application/json; charset=utf-8";
    private static final String APPLICATION_PROTO = "application/proto";
    private static volatile Grace sGrace;
    private static OnClientProvider sOnClientProvider;
    private static volatile OkHttpUtils.IOkHttpClientInitCallBack sInitCallBack;

    public static void setInitCallBack(OkHttpUtils.IOkHttpClientInitCallBack initCallBack) {
        sInitCallBack = initCallBack;
    }

    public static NetworkConverter.Network cronetNetwork() {
        return NetworkCronet.network();
    }

    public static NetworkConverter.Network okhttpNetwork() {
        return NetworkOkHttp.network();
    }

    public static void setOkHttpClient(@NotNull OnClientProvider clientProvider) {
        sOnClientProvider = clientProvider;
        ClientProvider.setOnClientProvider(() -> {
            Dns dns;
            boolean enableTls1v3 = SettingFlags.getBoolean("grace_enable_tls_1_3", true);
            if (!enableTls1v3) {
                return sOnClientProvider.okhttpClient();
            }
            long timeoutValue = OkHttpUtils.getDefault().getTimeoutValue();
            OkHttpClient.Builder builder = new OkHttpClient().newBuilder().connectionSpecs(Arrays.asList(ConnectionSpec.MODERN_TLS, ConnectionSpec.CLEARTEXT)).connectTimeout(timeoutValue, TimeUnit.MILLISECONDS).writeTimeout(timeoutValue, TimeUnit.MILLISECONDS).readTimeout(timeoutValue, TimeUnit.MILLISECONDS);
            if (RuntimeContext.sIsDebuggable) {
                builder.addInterceptor((Interceptor)new SSLHandshakeInterceptor());
            }
            builder.dispatcher(new Dispatcher((ExecutorService)new YYNormalThreadPoolExecutor(10, YYTaskExecutor.MAX_THREADPOOL_SIZE, RuntimeContext.sIsDebuggable ? YYNormalThreadPoolExecutor.UncaughtThrowableStrategy.THROW : YYNormalThreadPoolExecutor.UncaughtThrowableStrategy.LOG, new DefaultThreadFactory("GraceNet_Dispatcher", 5))));
            if (SettingFlags.getBoolean("httpconnectionretry", true)) {
                builder.retryOnConnectionFailure(true);
            }
            TrustManagerUtils.trustManager(builder);
            if (sInitCallBack != null && (dns = sInitCallBack.getDns()) != null) {
                builder.dns(dns);
            }
            builder.eventListenerFactory(call -> new OkHttpStat(call, OkHttpUtils.enableCloseConnection()));
            if (GraceUtil.enableH2PingInterval()) {
                builder.pingInterval(15000L, TimeUnit.MILLISECONDS);
            }
            return builder.build();
        });
    }

    private static boolean enableH2PingInterval() {
        return sInitCallBack != null && sInitCallBack.closeConnectionTestType() == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Grace getGrace() {
        if (sGrace != null) return sGrace;
        Class<GraceUtil> clazz = GraceUtil.class;
        synchronized (GraceUtil.class) {
            sGrace = new Grace.Builder().addConverterFactory((Converter.Factory)new FileConverterFactory()).addConverterFactory((Converter.Factory)new GsonBodyConverterFactory(JsonParser.getGson())).addNetworkFactory((NetworkConverter.Factory)NetworkCronet.network()).addNetworkFactory((NetworkConverter.Factory)NetworkOkHttp.network()).setDefaultNetwork((NetworkConverter.Network)NetworkOkHttp.network()).addRequestInterceptor(sInitCallBack.getRequestInterceptor()).setNetworkInterceptor((NetworkInterceptor)new GraceNetworkInterceptor()).executor(YYTaskExecutor::execute).addRetryStrategy((com.yy.grace.RetryStrategy)new RetryStrategy()).build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sGrace;
        }
    }

    private static void handleFileMd5Verify(Call<File> call, Response<File> response, Callback<File> callback, String md5) {
        YYTaskExecutor.execute(() -> {
            File file = (File)response.body();
            String fileMd5 = MD5Utils.fileMd5(file);
            if (StringUtils.equalsIgnoreCase(md5, fileMd5)) {
                YYTaskExecutor.postToMainThread(() -> callback.onResponse(call, response));
            } else {
                YYFileUtils.delete(file);
                YYTaskExecutor.postToMainThread(() -> callback.onFailure(call, (Throwable)new Exception("File Md5 error! origin md5 " + md5 + " file md5 " + fileMd5)));
            }
        });
    }

    public static void downloadFile(String url, String path, final @NonNull String md5, final Callback<File> callback) {
        Object callbackTemp;
        if (TextUtils.isEmpty((CharSequence)md5)) {
            GraceUtil.downloadFile(url, path, callback);
            return;
        }
        if (callback instanceof FileCallback) {
            final FileCallback fileFileCallback = (FileCallback)callback;
            callbackTemp = new FileCallback<File>(){

                public void onProgress(long l, long l1) {
                    fileFileCallback.onProgress(l, l1);
                }

                public boolean isCancel() {
                    return fileFileCallback.isCancel();
                }

                public void onResponse(Call<File> call, Response<File> response) {
                    GraceUtil.handleFileMd5Verify((Call<File>)call, (Response<File>)response, (Callback<File>)callback, md5);
                }

                public void onFailure(Call<File> call, Throwable throwable) {
                    fileFileCallback.onFailure(call, throwable);
                }
            };
        } else {
            callbackTemp = new Callback<File>(){

                public void onResponse(Call<File> call, Response<File> response) {
                    GraceUtil.handleFileMd5Verify((Call<File>)call, (Response<File>)response, (Callback<File>)callback, md5);
                }

                public void onFailure(Call<File> call, Throwable throwable) {
                    if (callback != null) {
                        callback.onFailure(call, throwable);
                    }
                }
            };
        }
        GraceUtil.getGrace().newCall(new Request.Builder<File>(){}.get().url(url).filePath(path).group((Request.Group)BizScenc.GENERAL_DOWNLOAD).build()).enqueue((Callback)callbackTemp);
    }

    public static void downloadFile(String url, String path, Callback<File> callback) {
        GraceUtil.getGrace().newCall(new Request.Builder<File>(){}.get().url(url).filePath(path).group((Request.Group)BizScenc.GENERAL_DOWNLOAD).build()).enqueue(callback);
    }

    public static void post(String url, Map<String, String> params, Map<String, String> headerMap, Callback<String> callback) {
        params = params != null ? params : new HashMap();
        GraceUtil.getGrace().newCall(new Request.Builder<String>(){}.url(url).method("POST", params).addHeader(headerMap).group((Request.Group)BizScenc.HTTP_SERVICE).build()).enqueue(callback);
    }

    public static void get(String url, Map<String, String> params, Map<String, String> headerMap, Callback<String> callback) {
        params = params != null ? params : new HashMap();
        GraceUtil.getGrace().newCall(new Request.Builder<String>(){}.url(url).get().addQueryParam(params).addHeader(headerMap).build()).enqueue(callback);
    }

    public static Response<ResponseBody> downloadFileSync(String url) throws IOException {
        return GraceUtil.getGrace().newCall(new Request.Builder<ResponseBody>(){}.get().url(url).group((Request.Group)BizScenc.GENERAL_DOWNLOAD).build()).execute();
    }

    private static class RetryStrategy
    extends DefaultRetryStrategy {
        private RetryStrategy() {
        }

        public boolean enableRetry(int code, Throwable throwable, Request.Group group) {
            if (throwable instanceof NullPointerException) {
                MLog.error((Object)"vanda", "enableRetry", throwable, new Object[0]);
            }
            return SettingFlags.getBoolean("grace_enable_retry", true) && super.enableRetry(code, throwable, group);
        }

        public int retryTimes() {
            return SettingFlags.getIntValue("grace_error_retry_times", 1);
        }
    }

    public static interface OnClientProvider {
        public OkHttpClient okhttpClient();
    }
}

