/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.monitor;

import android.content.pm.PackageManager;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;

public enum MonitorCenter {
    INSTANCE;

    private static final String SNAPSHOT = "-SNAPSHOT";
    private static final String TAG = "MonitorCenter";
    private HashMap<String, Long> timeMap = new HashMap();

    public void report(final String label, final HashMap<String, String> extend, final String desc) {
        if (MLog.isIsInitialized()) {
            this.doReport(label, extend, desc);
        } else {
            YYTaskExecutor.postToMainThread(new Runnable(){

                @Override
                public void run() {
                    MonitorCenter.this.doReport(label, extend, desc);
                }
            }, 5000L);
        }
    }

    private void doReport(String label, HashMap<String, String> extend, String desc) {
        if (label == null) {
            throw new RuntimeException("label should not be null");
        }
        boolean isDeveloper = this.isDeveloperPackage();
        String msg = this.formatMsg(label, extend, desc);
        MLog.error((Object)TAG, msg, new Object[0]);
        if (RuntimeContext.sIsDebuggable && !isDeveloper) {
            throw new RuntimeException(msg);
        }
    }

    public void startRecord(String label) {
        if (label == null) {
            throw new RuntimeException("label should not be null");
        }
        this.timeMap.put(label, System.currentTimeMillis());
    }

    public long stopRecord(String label) {
        if (label == null) {
            throw new RuntimeException("label should not be null");
        }
        Long value = this.timeMap.get(label);
        if (value == null) {
            return 0L;
        }
        this.timeMap.remove(label);
        return System.currentTimeMillis() - value;
    }

    private boolean isDeveloperPackage() {
        try {
            String localName = RuntimeContext.sApplicationContext.getPackageManager().getPackageInfo((String)RuntimeContext.sApplicationContext.getPackageName(), (int)0).versionName;
            if (localName.contains(SNAPSHOT)) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return false;
    }

    private String formatMsg(String label, HashMap<String, String> extend, String desc) {
        if (label == null) {
            label = "";
        }
        if (desc == null) {
            desc = "";
        }
        StringBuilder extendStr = new StringBuilder();
        extendStr.append("{");
        if (extend != null) {
            for (Map.Entry<String, String> entry : extend.entrySet()) {
                if (entry == null) continue;
                extendStr.append(StringUtils.formatWitUSLocal("[key:%s,value:%s]", entry.getKey(), entry.getValue()));
            }
        }
        extendStr.append("}");
        return StringUtils.formatWitUSLocal("TAG-%s-%s-%s", label, extendStr, desc);
    }
}

