/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.memoryrecycle.drawablerecycle;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.TextView;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.IImageRecycleView;
import com.yy.base.memoryrecycle.views.IRecycleView;
import com.yy.base.utils.SettingFlags;

public class DrawableRecycler {
    public static final int INVALID_DRAWABLE_ID = -1;
    public static final int TAG_KEY_AUTO_RECYCLE_OFF = -1313130;
    public static final int TAG_KEY_VIEW_BG_DRAWABLE_ID = -1313131;
    public static final int TAG_KEY_IMAGEVIEW_SRC_DRAWABLE_ID = -1313132;
    public static final int TAG_KEY_ATTACH_COUNT_ID = -1313133;
    public static final int TAG_KEY_RECYCLE_FLAG_ID = -1313134;
    private static final String TAG = "DrawableRecycler";
    private static final int DEFAULT_SUPPOSE_SIZE = 10240;
    private static volatile boolean sSwitch = SettingFlags.hasInited() ? SettingFlags.getBoolean("localresrecycle", true) : true;
    private static boolean sDebug = false;

    public static void updateSwitch(boolean switchOn) {
        if (sSwitch == switchOn) {
            return;
        }
        sSwitch = switchOn;
        MLog.info(TAG, "updateSwitch :" + switchOn, new Object[0]);
    }

    public static void closeAutoRecycle(View view) {
        if (!(view instanceof IRecycleView)) {
            return;
        }
        DrawableRecycler.recoveryViewDrawable((IRecycleView)view);
        view.setTag(-1313130, (Object)true);
    }

    public static void openAutoRecycle(View view) {
        int size;
        if (!(view instanceof IRecycleView)) {
            return;
        }
        view.setTag(-1313130, (Object)false);
        if (view.getVisibility() == 8 && (size = DrawableRecycler.recycleViewDrawable((IRecycleView)view)) > 0 && RuntimeContext.sIsDebuggable) {
            MLog.info(TAG, "recycle size by VIEW.GONE :" + size, new Object[0]);
        }
    }

    public static void onAttributesUpdated(Context context, IRecycleView view, AttributeSet attrs) {
        if (!sSwitch) {
            return;
        }
        if (!(view instanceof View) || view.closeAutoRecycleDrawables()) {
            return;
        }
        int[] attribute = null;
        boolean isImageView = false;
        if (view instanceof ImageView) {
            isImageView = true;
            attribute = new int[]{16842964, 0x1010119};
        } else {
            attribute = new int[]{16842964};
        }
        TypedArray array = context.obtainStyledAttributes(attrs, attribute);
        int bgDrawableId = -1;
        int srcDrawableId = -1;
        try {
            bgDrawableId = array.getResourceId(0, -1);
            if (isImageView) {
                srcDrawableId = array.getResourceId(1, -1);
            }
            if (!(!sDebug || bgDrawableId == -1 && srcDrawableId == -1 || MLog.isLogLevelAboveDebug() || MLog.isLogLevelAboveDebug())) {
                MLog.debug(TAG, "onAttributesUpdated view src " + srcDrawableId + " bg " + bgDrawableId + " " + view, new Object[0]);
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, "onAttributesUpdated" + e.toString(), new Object[0]);
        }
        array.recycle();
        ((View)view).setTag(-1313131, (Object)bgDrawableId);
        if (isImageView) {
            ((View)view).setTag(-1313132, (Object)srcDrawableId);
        }
        if (((View)view).getVisibility() == 8) {
            int size = 0;
            if (bgDrawableId != -1 || srcDrawableId != -1) {
                size += DrawableRecycler.recycleViewDrawable(view);
            }
            if (view instanceof ViewGroup) {
                size += DrawableRecycler.recycleDrawablesByGone((ViewGroup)view);
            }
            if (size > 0 && sDebug) {
                MLog.info(TAG, "recycle size by VIEW.GONE :" + size, new Object[0]);
            }
        }
    }

    private static int recycleDrawablesByGone(ViewGroup viewGroup) {
        if (!sSwitch) {
            return 0;
        }
        int recycleSize = 0;
        if (viewGroup == null || viewGroup.getVisibility() != 8 || !(viewGroup instanceof IRecycleView)) {
            return recycleSize;
        }
        int childSize = viewGroup.getChildCount();
        View child = null;
        for (int i = 0; i < childSize; ++i) {
            child = viewGroup.getChildAt(i);
            if (child == null || child.getVisibility() != 8 || !(child instanceof IRecycleView)) continue;
            if (child instanceof ViewGroup) {
                recycleSize += DrawableRecycler.recycleViewDrawable((IRecycleView)child);
                recycleSize += DrawableRecycler.recycleDrawablesByGone((ViewGroup)child);
                continue;
            }
            if (!(child instanceof IRecycleView)) continue;
            recycleSize += DrawableRecycler.recycleViewDrawable((IRecycleView)child);
        }
        return recycleSize;
    }

    private static void recoveryDrawablesNotGone(ViewGroup viewGroup) {
        if (viewGroup == null || viewGroup.getVisibility() == 8 || !(viewGroup instanceof IRecycleView)) {
            return;
        }
        int childSize = viewGroup.getChildCount();
        View child = null;
        for (int i = 0; i < childSize; ++i) {
            child = viewGroup.getChildAt(i);
            if (child == null || child.getVisibility() == 8 || !(child instanceof IRecycleView)) continue;
            if (child instanceof ViewGroup) {
                DrawableRecycler.recoveryViewDrawable((IRecycleView)child);
                DrawableRecycler.recoveryDrawablesNotGone((ViewGroup)child);
                continue;
            }
            if (!(child instanceof IRecycleView)) continue;
            DrawableRecycler.recoveryViewDrawable((IRecycleView)child);
        }
    }

    public static void recoveryViewDrawable(IRecycleView view) {
        if (!(view instanceof View)) {
            return;
        }
        View v = (View)view;
        Object recycled = v.getTag(-1313134);
        if (recycled instanceof Boolean && ((Boolean)recycled).booleanValue()) {
            Object bgId;
            Object srcId;
            v.setTag(-1313134, (Object)false);
            if (v instanceof ImageView && view instanceof IImageRecycleView && ((IImageRecycleView)view).getImageDrawableInner() == null && (srcId = v.getTag(-1313132)) != null && srcId instanceof Integer && (Integer)srcId != -1) {
                ((ImageView)v).setImageResource(((Integer)srcId).intValue());
                if (sDebug) {
                    MLog.info(TAG, "recovery image:" + Integer.toHexString((Integer)srcId) + " from view:" + view.hashCode(), new Object[0]);
                }
            }
            if (v instanceof TextView) {
                // empty if block
            }
            if (v instanceof CompoundButton) {
                // empty if block
            }
            if (view.getBackgroundInner() == null && (bgId = v.getTag(-1313131)) != null && bgId instanceof Integer && (Integer)bgId != -1) {
                v.setBackgroundResource(((Integer)bgId).intValue());
                if (sDebug) {
                    MLog.info(TAG, "recovery bg:" + Integer.toHexString((Integer)bgId) + " from view:" + view.hashCode(), new Object[0]);
                }
            }
        }
    }

    private static boolean autoRecycleClosed(IRecycleView view) {
        if (!(view instanceof View) || view.closeAutoRecycleDrawables()) {
            return true;
        }
        View v = (View)view;
        Object autoRecycleOff = v.getTag(-1313130);
        if (autoRecycleOff != null && autoRecycleOff instanceof Boolean) {
            return (Boolean)autoRecycleOff;
        }
        return false;
    }

    public static int recycleViewDrawable(IRecycleView view) {
        if (!sSwitch) {
            return 0;
        }
        if (RuntimeContext.sIsDebuggable) {
            DrawableRecycler.recycleViewDrawableInner(view);
        } else {
            try {
                DrawableRecycler.recycleViewDrawableInner(view);
            }
            catch (Exception e) {
                SettingFlags.setBoolean("localresrecycle", false);
                MLog.error(TAG, e);
            }
        }
        return 0;
    }

    private static int recycleViewDrawableInner(IRecycleView view) {
        if (!sSwitch) {
            return 0;
        }
        int recycleSize = 0;
        if (!(view instanceof View) || view.closeAutoRecycleDrawables()) {
            return recycleSize;
        }
        View v = (View)view;
        Object autoRecycleOff = v.getTag(-1313130);
        if (autoRecycleOff != null && autoRecycleOff instanceof Boolean && ((Boolean)autoRecycleOff).booleanValue()) {
            return recycleSize;
        }
        boolean recycle = false;
        if (v != null) {
            Object bgId;
            Drawable bgDrawable;
            Object srcId;
            Drawable srcDrawable;
            if (v instanceof ImageView && view instanceof IImageRecycleView && (srcDrawable = ((IImageRecycleView)view).getImageDrawableInner()) != null && (srcId = v.getTag(-1313132)) != null && srcId instanceof Integer && (Integer)srcId != -1) {
                if (srcDrawable instanceof AnimationDrawable && ((AnimationDrawable)srcDrawable).isRunning()) {
                    ((AnimationDrawable)srcDrawable).stop();
                }
                ((IImageRecycleView)view).setImageDrawableToNull();
                if (sDebug) {
                    MLog.info(TAG, "recycle image:" + Integer.toHexString((Integer)srcId) + " from view:" + view.hashCode(), new Object[0]);
                    recycleSize += DrawableRecycler.getBitmapSize(srcDrawable);
                }
                recycle = true;
            }
            if (v instanceof TextView) {
                // empty if block
            }
            if (v instanceof CompoundButton) {
                // empty if block
            }
            if ((bgDrawable = view.getBackgroundInner()) != null && (bgId = v.getTag(-1313131)) != null && bgId instanceof Integer && (Integer)bgId != -1) {
                view.setBackgroundToNull();
                if (sDebug) {
                    MLog.info(TAG, "recycle bg:" + Integer.toHexString((Integer)bgId) + " from view:" + view.hashCode(), new Object[0]);
                    recycleSize += DrawableRecycler.getBitmapSize(bgDrawable);
                }
                recycle = true;
            }
            if (recycle) {
                v.setTag(-1313134, (Object)recycle);
            }
        }
        return recycleSize;
    }

    private static boolean isAttachToWindow(IRecycleView view) {
        Object count;
        if (view instanceof View && (count = ((View)view).getTag(-1313133)) != null && count instanceof Integer) {
            return (Integer)count > 0;
        }
        return false;
    }

    public static void onVisibilityChanged(IRecycleView view, int visibility) {
        if (view == null) {
            return;
        }
        if (visibility == 8) {
            if (DrawableRecycler.isAttachToWindow(view)) {
                int size = DrawableRecycler.recycleViewDrawable(view);
                if (view instanceof ViewGroup) {
                    size += DrawableRecycler.recycleDrawablesByGone((ViewGroup)view);
                }
                if (size > 0 && sDebug) {
                    MLog.info(TAG, "recycle size by VIEW.GONE Changed:" + size, new Object[0]);
                }
            }
        } else {
            if (view instanceof ViewGroup) {
                DrawableRecycler.recoveryDrawablesNotGone((ViewGroup)view);
            }
            DrawableRecycler.recoveryViewDrawable(view);
            if (sDebug) {
                MLog.info(TAG, "reccvery by visible", new Object[0]);
            }
        }
    }

    public static void onDetachedFromWindow(IRecycleView view) {
        if (view instanceof View) {
            View theView = (View)view;
            int countInt = 0;
            Object count = theView.getTag(-1313133);
            if (count != null && count instanceof Integer) {
                countInt = (Integer)count;
                countInt = countInt > 0 ? --countInt : 0;
            }
            if (countInt == 0) {
                int size = DrawableRecycler.recycleViewDrawable(view);
                if (size > 0 && sDebug) {
                    MLog.info(TAG, "recycle size by Detached :" + size, new Object[0]);
                }
                theView.setTag(-1313133, (Object)countInt);
            } else {
                theView.setTag(-1313133, (Object)countInt);
                if (sDebug && !MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
                    MLog.debug(TAG, "onDetachedFromWindow but attach count is not 0", new Object[0]);
                }
            }
        } else {
            int size = DrawableRecycler.recycleViewDrawable(view);
            if (size > 0 && sDebug) {
                MLog.info(TAG, "recycle size by Detached :" + size, new Object[0]);
            }
        }
    }

    public static void onAttachedToWindow(IRecycleView view) {
        if (view instanceof View) {
            View theView = (View)view;
            int countInt = 0;
            Object count = theView.getTag(-1313133);
            if (count != null && count instanceof Integer && (countInt = ((Integer)count).intValue()) < 0) {
                countInt = 0;
            }
            theView.setTag(-1313133, (Object)(++countInt));
            if (theView.getVisibility() != 8) {
                DrawableRecycler.recoveryViewDrawable(view);
            }
        } else {
            DrawableRecycler.recoveryViewDrawable(view);
        }
    }

    public static void onBackgroundUpdated(IRecycleView view, Drawable drawable2) {
        if (!(view instanceof View)) {
            return;
        }
        ((View)view).setTag(-1313131, (Object)-1);
    }

    public static void onBackgroundUpdated(IRecycleView view, int resID) {
        if (!(view instanceof View)) {
            return;
        }
        ((View)view).setTag(-1313131, (Object)resID);
    }

    public static void onImageUpdated(IRecycleView view, Drawable drawable2) {
        if (!(view instanceof ImageView)) {
            return;
        }
        ((View)view).setTag(-1313132, (Object)-1);
    }

    public static void onImageUpdated(IRecycleView view, int resID) {
        if (!(view instanceof ImageView)) {
            return;
        }
        ((View)view).setTag(-1313132, (Object)resID);
    }

    public static void onGetDrawable(IRecycleView view) {
        if (!(view instanceof ImageView)) {
            return;
        }
        DrawableRecycler.recoveryViewDrawable(view);
    }

    public static void onGetDrawableEnd(IRecycleView view) {
        if (!(view instanceof ImageView)) {
            return;
        }
        if (DrawableRecycler.autoRecycleClosed(view)) {
            return;
        }
        if (((ImageView)view).getVisibility() == 8) {
            DrawableRecycler.recycleViewDrawable(view);
        }
    }

    public static void onGetBackground(IRecycleView view) {
        if (Build.VERSION.SDK_INT < 24) {
            if (!(view instanceof View)) {
                return;
            }
            DrawableRecycler.recoveryViewDrawable(view);
        }
    }

    public static void onGetBackgroundEnd(IRecycleView view) {
        if (Build.VERSION.SDK_INT < 24) {
            if (!(view instanceof View)) {
                return;
            }
            if (DrawableRecycler.autoRecycleClosed(view)) {
                return;
            }
            if (((View)view).getVisibility() == 8) {
                DrawableRecycler.recycleViewDrawable(view);
            }
        }
    }

    private static int getBitmapSize(Drawable value) {
        Bitmap bitmap = value instanceof BitmapDrawable ? ((BitmapDrawable)value).getBitmap() : ImageLoader.getBitmapFromCustomDrawable(value);
        if (bitmap != null) {
            if (bitmap == null) {
                return 10240;
            }
            if (Build.VERSION.SDK_INT > 12) {
                return bitmap.getByteCount();
            }
            return bitmap.getRowBytes() * bitmap.getHeight();
        }
        return 10240;
    }
}

