/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.logger.memorycachelog;

import android.annotation.SuppressLint;
import android.util.Log;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.ILog;
import com.yy.base.logger.LogRunnable;
import com.yy.base.logger.Utils;
import com.yy.base.logger.memorycachelog.MemoryCacheLogManager;
import com.yy.hago.xlog.LogOptions;

@SuppressLint(value={"LogUsage"})
public class MemoryCacheLogImpl
implements ILog {
    @Override
    public void verbose(Object obj, String format, Object ... args) {
        LogRunnable logRunnable = MemoryCacheLogManager.produceLogRunnable().setNeedStatSize(true).setTag(this.tag(obj)).setFormat(format).setArgs(args).setLogLevel(LogOptions.LEVEL_VERBOSE);
        MemoryCacheLogManager.enqueueLogRunnable(logRunnable);
        if (RuntimeContext.sIsDebuggable) {
            Log.v((String)this.tag(obj), (String)this.getLog(format, null, args));
        }
    }

    @Override
    public void debug(Object obj, String format, Object ... args) {
        LogRunnable logRunnable = MemoryCacheLogManager.produceLogRunnable().setNeedStatSize(true).setTag(this.tag(obj)).setFormat(format).setArgs(args).setLogLevel(LogOptions.LEVEL_DEBUG);
        MemoryCacheLogManager.enqueueLogRunnable(logRunnable);
        if (RuntimeContext.sIsDebuggable) {
            Log.d((String)this.tag(obj), (String)this.getLog(format, null, args));
        }
    }

    @Override
    public void info(Object obj, String format, Object ... args) {
        if (RuntimeContext.sIsDebuggable) {
            Log.i((String)this.tag(obj), (String)this.getLog(format, null, args));
        }
        LogRunnable logRunnable = MemoryCacheLogManager.produceLogRunnable().setNeedStatSize(true).setTag(this.tag(obj)).setFormat(format).setArgs(args).setLogLevel(LogOptions.LEVEL_INFO);
        MemoryCacheLogManager.enqueueLogRunnable(logRunnable);
    }

    @Override
    public void warn(Object obj, String format, Object ... args) {
        if (RuntimeContext.sIsDebuggable) {
            Log.w((String)this.tag(obj), (String)this.getLog(format, null, args));
        }
        LogRunnable logRunnable = MemoryCacheLogManager.produceLogRunnable().setNeedStatSize(true).setTag(this.tag(obj)).setFormat(format).setArgs(args).setLogLevel(LogOptions.LEVEL_WARN);
        MemoryCacheLogManager.enqueueLogRunnable(logRunnable);
    }

    @Override
    public void error(Object obj, String format, Object ... args) {
        if (RuntimeContext.sIsDebuggable) {
            Log.e((String)this.tag(obj), (String)this.getLog(format, null, args));
        }
        LogRunnable logRunnable = MemoryCacheLogManager.produceLogRunnable().setNeedStatSize(true).setTag(this.tag(obj)).setFormat(format).setArgs(args).setLogLevel(LogOptions.LEVEL_ERROR);
        MemoryCacheLogManager.enqueueLogRunnable(logRunnable);
    }

    @Override
    public void error(Object obj, String format, Throwable t, Object ... args) {
        if (RuntimeContext.sIsDebuggable) {
            Log.e((String)this.tag(obj), (String)this.getLog(format, null, args), (Throwable)t);
        }
        LogRunnable logRunnable = MemoryCacheLogManager.produceLogRunnable().setNeedStatSize(true).setTag(this.tag(obj)).setFormat(format).setArgs(args).setLogLevel(LogOptions.LEVEL_ERROR).setThrowable(t);
        MemoryCacheLogManager.enqueueLogRunnable(logRunnable);
    }

    @Override
    public void error(Object obj, Throwable t) {
        if (RuntimeContext.sIsDebuggable) {
            Log.e((String)this.tag(obj), (String)"", (Throwable)t);
        }
        LogRunnable logRunnable = MemoryCacheLogManager.produceLogRunnable().setNeedStatSize(true).setTag(this.tag(obj)).setLogLevel(LogOptions.LEVEL_ERROR).setThrowable(t);
        MemoryCacheLogManager.enqueueLogRunnable(logRunnable);
    }

    @Override
    public void trace(Object obj, String message) {
        if (RuntimeContext.sIsDebuggable) {
            Log.e((String)this.tag(obj), (String)message);
        }
        LogRunnable logRunnable = MemoryCacheLogManager.produceLogRunnable().setNeedStatSize(true).setTag(this.tag(obj)).setMessage(message).setLogLevel(LogOptions.LEVEL_ERROR);
        MemoryCacheLogManager.enqueueLogRunnable(logRunnable);
    }

    @Override
    public void flushCacheLogs() {
        MemoryCacheLogManager.flush(false);
    }

    private String getLog(String format, Throwable t, Object ... args) {
        String log;
        String string2 = log = args == null || args.length == 0 ? format : Utils.format(format, args);
        if (log == null) {
            log = "";
        }
        if (t != null) {
            log = log + " Exception occurs at " + Log.getStackTraceString((Throwable)t);
        }
        return log;
    }
}

