/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.logger;

import com.yy.base.logger.MLog;
import com.yy.base.logger.data.TraceEventBean;
import com.yy.base.logger.data.TraceHttpBean;
import com.yy.base.logger.data.TraceSocketBean;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.json.JsonParser;
import okhttp3.Request;
import okhttp3.Response;

public class TraceLogHelper {
    private static final String TAG = "TraceLogHelper";
    private static final String TRACE_TYPE_HTTP = "http";
    private static final String TRACE_TYPE_CPROXY = "cproxy";
    private static final String TRACE_TYPE_EVENT = "event";
    public static final String EVENT_TYPE_APP_START = "app_start";
    public static final String EVENT_TYPE_APP_BACKGROUND = "background";
    public static final String EVENT_TYPE_APP_FOREGROUND = "app_active";
    public static final String EVENT_TYPE_NET_UNAVAILABLE = "network_unavailable";
    public static final String EVENT_TYPE_NET_SWITCH = "network_switch";
    private static TraceLogHelper sInstance;

    private TraceLogHelper() {
    }

    public static TraceLogHelper getInstance() {
        if (sInstance == null) {
            sInstance = new TraceLogHelper();
        }
        return sInstance;
    }

    public void traceHttp(final Response response, final Request request, final long duration) {
        YYTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (response != null && request != null) {
                    String message;
                    TraceHttpBean bean = new TraceHttpBean();
                    bean.timestamp = System.currentTimeMillis();
                    bean.duration = duration;
                    bean.method = request.method();
                    bean.statusCode = response.code();
                    bean.type = TraceLogHelper.TRACE_TYPE_HTTP;
                    bean.uri = request.url().url().toString();
                    bean.traceId = response.header("X-Kxd-Traceid", "");
                    bean.error = response.message();
                    if (response.body() != null && response.body().contentLength() > 0L) {
                        bean.size = (int)response.body().contentLength();
                    }
                    if ((message = JsonParser.toJson(bean)) == null) {
                        message = "";
                    }
                    MLog.trace(TraceLogHelper.TAG, message);
                }
            }
        });
    }

    public void traceSocket(final int uri, final String sname, final long statusCode, final String traceId, final long duration, final int size) {
        YYTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                TraceSocketBean bean = new TraceSocketBean();
                bean.timestamp = System.currentTimeMillis();
                bean.duration = duration;
                bean.statusCode = statusCode;
                bean.type = TraceLogHelper.TRACE_TYPE_CPROXY;
                bean.uri = uri;
                bean.traceId = traceId;
                bean.sname = sname;
                bean.size = size;
                String message = JsonParser.toJson(bean);
                if (message == null) {
                    message = "";
                }
                MLog.trace(TraceLogHelper.TAG, message);
            }
        });
    }

    public void traceEvent(final long duration, final String evenType, final int networkType) {
        YYTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                String message;
                TraceEventBean bean = new TraceEventBean();
                bean.timestamp = System.currentTimeMillis();
                bean.duration = duration;
                bean.type = TraceLogHelper.TRACE_TYPE_EVENT;
                bean.event = evenType;
                if (evenType == TraceLogHelper.EVENT_TYPE_NET_SWITCH) {
                    switch (networkType) {
                        case 0: {
                            bean.event = TraceLogHelper.EVENT_TYPE_NET_UNAVAILABLE;
                            break;
                        }
                        case 2: {
                            bean.eventInfo.network = "2g";
                            break;
                        }
                        case 3: {
                            bean.eventInfo.network = "3g";
                            break;
                        }
                        case 4: {
                            bean.eventInfo.network = "4g";
                            break;
                        }
                        case 1: {
                            bean.eventInfo.network = "wifi";
                            break;
                        }
                    }
                }
                if ((message = JsonParser.toJson(bean)) == null) {
                    message = "";
                }
                MLog.trace(TraceLogHelper.TAG, message);
            }
        });
    }
}

