/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.logger;

import android.os.SystemClock;
import com.yy.base.logger.MLog;
import com.yy.base.logger.Utils;
import com.yy.base.logger.printer.transformation.DateFormater;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.hago.xlog.LogOptions;
import java.io.File;

public class PathLog {
    private static final IQueueTaskExecutor sQueueExecutor = YYTaskExecutor.createAQueueExcuter(false, false);
    private static volatile DateFormater sDataFormat;

    public static IPathLogItem startWithDebugLevel(String tag, String startMsgFromat, Object ... args) {
        return new PathLogItem(LogOptions.LEVEL_DEBUG, tag, startMsgFromat, args);
    }

    public static IPathLogItem startWithInfoLevel(String tag, String startMsgFromat, Object ... args) {
        return new PathLogItem(LogOptions.LEVEL_INFO, tag, startMsgFromat, args);
    }

    public static IPathLogItem startWithErrorLevel(String tag, String startMsgFromat, Object ... args) {
        return new PathLogItem(LogOptions.LEVEL_INFO, tag, startMsgFromat, args);
    }

    private static class RecyclePathLogItem
    implements IPathLogItem {
        private static final int MAX_POOL_SIZE = 10;
        private static final Object sPoolSync = new Object();
        private static int sPoolSize = 0;
        private static RecyclePathLogItem sPool;
        private StringBuilder mMsg = new StringBuilder();
        private RecyclePathLogItem mNext;
        private int mLogLevel;
        private String mTag;
        private long mStarTime;

        private RecyclePathLogItem() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static RecyclePathLogItem obtain() {
            Object object = sPoolSync;
            synchronized (object) {
                if (sPool != null) {
                    RecyclePathLogItem m = sPool;
                    sPool = m.mNext;
                    m.mNext = null;
                    --sPoolSize;
                    return m;
                }
            }
            return null;
        }

        public void start(int logLevel, String tag, long starTime, String startMsgFromat, Object ... args) {
            if (sDataFormat == null) {
                sDataFormat = new DateFormater();
            }
            this.mLogLevel = logLevel;
            this.mTag = tag != null ? tag : "";
            this.mStarTime = starTime > 0L ? starTime : SystemClock.elapsedRealtime();
            this.mMsg.append(Utils.createMessage(startMsgFromat, args));
            this.mMsg.append(" ");
            this.mMsg.append(sDataFormat.getDateAndTime(System.currentTimeMillis()));
            this.mMsg.append("\n");
        }

        private void reset() {
            this.mTag = "";
            if (this.mMsg != null && this.mMsg.length() > 0) {
                this.mMsg.delete(0, this.mMsg.length());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void recycle() {
            this.reset();
            Object object = sPoolSync;
            synchronized (object) {
                if (sPoolSize < 10) {
                    this.mNext = sPool;
                    sPool = this;
                    ++sPoolSize;
                }
            }
        }

        void add(String msgFormat, long curTime, Object ... args) {
            if (StringUtils.isNotEmpty(msgFormat)) {
                long time = -1L;
                time = curTime > 0L ? curTime - this.mStarTime : SystemClock.elapsedRealtime() - this.mStarTime;
                this.mMsg.append("time:");
                this.mMsg.append(String.valueOf(time));
                if (time < 10L) {
                    this.mMsg.append("       ");
                } else if (time < 100L) {
                    this.mMsg.append("      ");
                } else if (time < 1000L) {
                    this.mMsg.append("     ");
                } else {
                    this.mMsg.append("    ");
                }
                this.mMsg.append(Utils.createMessage(msgFormat, args));
                this.mMsg.append("\n");
            }
        }

        void end(String msgFormat, long curTime, Object ... args) {
            long time = -1L;
            time = curTime > 0L ? curTime - this.mStarTime : SystemClock.elapsedRealtime() - this.mStarTime;
            if (StringUtils.isNotEmpty(msgFormat)) {
                this.mMsg.append(Utils.createMessage(msgFormat, args));
                this.mMsg.append("   time ");
                this.mMsg.append(String.valueOf(time));
                this.mMsg.append("\n");
            }
            if (this.mLogLevel == LogOptions.LEVEL_DEBUG) {
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug(this.mTag, this.mMsg.toString(), new Object[0]);
                }
            } else if (this.mLogLevel == LogOptions.LEVEL_ERROR) {
                MLog.error((Object)this.mTag, this.mMsg.toString(), new Object[0]);
            } else {
                MLog.info(this.mTag, this.mMsg.toString(), new Object[0]);
            }
        }

        void endToFile(final File file, long curTime, String msgFormat, Object ... args) {
            long time = -1L;
            time = curTime > 0L ? curTime - this.mStarTime : SystemClock.elapsedRealtime() - this.mStarTime;
            if (StringUtils.isNotEmpty(msgFormat)) {
                this.mMsg.append(Utils.createMessage(msgFormat, args));
                this.mMsg.append("   time ");
                this.mMsg.append(String.valueOf(time));
                this.mMsg.append("\n");
            }
            if (file != null) {
                YYTaskExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            YYFileUtils.writeBytesToFile(file, mMsg.toString().getBytes(), true);
                            MLog.info("PathLog", "end filesize:%s", file.length());
                        }
                        catch (Throwable e) {
                            MLog.error("PathLog", e);
                        }
                    }
                });
            }
        }

        @Override
        public void add(String msgFormat, Object ... args) {
            this.add(msgFormat, -1L, args);
        }

        @Override
        public void end(String msgFormat, Object ... args) {
            this.end(msgFormat, -1L, args);
        }

        @Override
        public void endToFile(File file, String msgFormat, Object ... args) {
            this.endToFile(file, -1L, msgFormat, args);
        }
    }

    private static class PathLogItem
    implements IPathLogItem {
        RecyclePathLogItem mRecyclePathLogItem;
        private int mLogLevel;

        public PathLogItem(final int logLevel, final String tag, final String startMsgFromat, final Object ... args) {
            this.mLogLevel = logLevel;
            if (logLevel < MLog.getLogLevel()) {
                return;
            }
            final long time = SystemUtils.isShowEnvSetting() ? SystemClock.elapsedRealtime() : 1L;
            sQueueExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    MLog.info("PathLog", "PathLogItem start:%s", tag);
                    mRecyclePathLogItem = RecyclePathLogItem.obtain();
                    if (mRecyclePathLogItem == null) {
                        mRecyclePathLogItem = new RecyclePathLogItem();
                    }
                    mRecyclePathLogItem.start(logLevel, tag, time, startMsgFromat, args);
                }
            }, SystemUtils.isShowEnvSetting() ? 0L : 5000L);
        }

        @Override
        public void add(final String msgFormat, final Object ... args) {
            if (this.mLogLevel < MLog.getLogLevel()) {
                return;
            }
            if (this.mRecyclePathLogItem == null) {
                return;
            }
            final long time = SystemUtils.isShowEnvSetting() ? SystemClock.elapsedRealtime() : 1L;
            sQueueExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    if (mRecyclePathLogItem != null) {
                        mRecyclePathLogItem.add(msgFormat, time, args);
                    }
                }
            }, SystemUtils.isShowEnvSetting() ? 0L : 5000L);
        }

        @Override
        public void end(final String msgFormat, final Object ... args) {
            if (this.mLogLevel < MLog.getLogLevel()) {
                return;
            }
            if (this.mRecyclePathLogItem == null) {
                return;
            }
            final long time = SystemUtils.isShowEnvSetting() ? SystemClock.elapsedRealtime() : 1L;
            sQueueExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    MLog.info("PathLog", "PathLogItem end real:%s", msgFormat);
                    if (mRecyclePathLogItem != null) {
                        mRecyclePathLogItem.end(msgFormat, time, args);
                        mRecyclePathLogItem.recycle();
                        mRecyclePathLogItem = null;
                    }
                }
            }, SystemUtils.isShowEnvSetting() ? 0L : 5000L);
        }

        @Override
        public void endToFile(final File file, final String msgFormat, final Object ... args) {
            if (this.mLogLevel < MLog.getLogLevel()) {
                return;
            }
            if (this.mRecyclePathLogItem == null) {
                return;
            }
            final long time = SystemUtils.isShowEnvSetting() ? SystemClock.elapsedRealtime() : 1L;
            sQueueExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    if (mRecyclePathLogItem != null) {
                        mRecyclePathLogItem.endToFile(file, time, msgFormat, args);
                        mRecyclePathLogItem.recycle();
                        mRecyclePathLogItem = null;
                    }
                }
            }, SystemUtils.isShowEnvSetting() ? 0L : 5000L);
        }
    }

    public static interface IPathLogItem {
        public void add(String var1, Object ... var2);

        public void end(String var1, Object ... var2);

        public void endToFile(File var1, String var2, Object ... var3);
    }
}

