/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.logger;

import android.util.Log;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.ILog;
import com.yy.base.logger.LogHandlerThread;
import com.yy.base.logger.LogRunnable;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.VersionUtil;
import com.yy.hago.xlog.LogOptions;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

public class NormalLogImpl
implements ILog {
    private static ArrayList<LogRunnable> mCacheLogs;
    private static volatile int sNeedCacheSwitch;
    private SimpleDateFormat mDateFormat;
    private Date mDate;

    public static boolean isNeedCacheLog() {
        if (sNeedCacheSwitch == -1 && SettingFlags.hasInited()) {
            int n = sNeedCacheSwitch = SettingFlags.getBoolean("KLCWSSO", true) ? 1 : 0;
        }
        if (sNeedCacheSwitch == 0) {
            return false;
        }
        if (SystemUtils.isShowEnvSetting() && SettingFlags.hasInited()) {
            boolean disable = SettingFlags.getBoolean("debug_DISABLE_CACHE_LOG", false);
            if (disable) {
                sNeedCacheSwitch = 0;
                return false;
            }
            if (VersionUtil.isLocalDevBuild() || RuntimeContext.sIsDebuggable) {
                return false;
            }
        }
        return !RuntimeContext.sIsAppStartFinishAfterThreeSecond && RuntimeContext.sIsMainProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addLogToCache(LogRunnable logRunnable) {
        if (logRunnable == null) {
            return;
        }
        Class<NormalLogImpl> clazz = NormalLogImpl.class;
        synchronized (NormalLogImpl.class) {
            if (mCacheLogs == null) {
                mCacheLogs = new ArrayList(100);
            } else if (!RuntimeContext.sIsDebuggable && mCacheLogs.size() > 1000) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            mCacheLogs.add(logRunnable);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void verbose(Object obj, String format, Object ... args) {
        this.addLogRunnable(this.createLogRunnable(LogOptions.LEVEL_VERBOSE, obj, format, args));
    }

    private void addLogRunnable(LogRunnable logRunnable) {
        if (NormalLogImpl.isNeedCacheLog()) {
            NormalLogImpl.addLogToCache(logRunnable);
        } else {
            LogHandlerThread.getInstance().postLogRunnable(logRunnable);
        }
    }

    @Override
    public void debug(Object obj, String format, Object ... args) {
        this.addLogRunnable(this.createLogRunnable(LogOptions.LEVEL_DEBUG, obj, format, args));
    }

    @Override
    public void info(Object obj, String format, Object ... args) {
        this.addLogRunnable(this.createLogRunnable(LogOptions.LEVEL_INFO, obj, format, args));
    }

    @Override
    public void warn(Object obj, String format, Object ... args) {
        this.addLogRunnable(this.createLogRunnable(LogOptions.LEVEL_WARN, obj, format, args));
    }

    @Override
    public void error(Object obj, String format, Object ... args) {
        this.addLogRunnable(this.createLogRunnable(LogOptions.LEVEL_ERROR, obj, format, args));
    }

    @Override
    public void error(Object obj, String format, Throwable t, Object ... args) {
        this.addLogRunnable(this.createLogRunnable(LogOptions.LEVEL_ERROR, obj, format, args).setThrowable(t));
    }

    @Override
    public void error(Object obj, Throwable t) {
        this.addLogRunnable(this.createLogRunnable(LogOptions.LEVEL_ERROR, obj, "", "").setThrowable(t));
    }

    @Override
    public void trace(Object obj, String message) {
        this.addLogRunnable(this.createLogRunnable(LogOptions.LEVEL_ERROR, obj, "", ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushCacheLogs() {
        Class<NormalLogImpl> clazz = NormalLogImpl.class;
        synchronized (NormalLogImpl.class) {
            if (mCacheLogs == null || mCacheLogs.size() <= 0) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            sNeedCacheSwitch = 0;
            if (this.mDateFormat == null) {
                this.mDate = new Date();
                this.mDateFormat = new SimpleDateFormat("HH:mm:ss.SSS", Locale.SIMPLIFIED_CHINESE);
            }
            StringBuilder cacheLogs = new StringBuilder("LOGS IN STARTING!");
            for (LogRunnable logRunnable : mCacheLogs) {
                try {
                    this.mDate.setTime(logRunnable.time);
                    logRunnable.setTag("[LISE]" + this.mDateFormat.format(this.mDate) + logRunnable.tag);
                    LogHandlerThread.getInstance().postLogRunnable(logRunnable);
                }
                catch (Throwable e) {
                    Log.e((String)"MLog", (String)"flush cached logs error", (Throwable)e);
                }
            }
            mCacheLogs.clear();
            cacheLogs.append("LOGS IN STARTING END!");
            MLog.info("LISE", cacheLogs.toString(), new Object[0]);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static {
        sNeedCacheSwitch = -1;
    }
}

