/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.logger;

import androidx.core.util.Pair;
import com.yy.base.logger.LogCompress;
import com.yy.base.logger.MLog;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.xml.CommonUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class LogZipCompress
implements LogCompress {
    private static LogZipCompress mInstance;
    public static final String EXT = ".zip";
    private static final String BASE_DIR = "";
    private static final String PATH = "/";
    private static final int BUFFER = 1024;
    public static final String FEED_BACK_FILE_PREFIX = "Android_Feedback_";

    private LogZipCompress() {
    }

    public static synchronized LogZipCompress getInstance() {
        if (mInstance == null) {
            mInstance = new LogZipCompress();
        }
        return mInstance;
    }

    @Override
    public void compress(File srcFile) throws Exception {
        String name = srcFile.getName();
        String basePath = srcFile.getParent();
        String destPath = basePath + File.separator + name.substring(0, name.indexOf(".")) + EXT;
        this.compress(srcFile, destPath);
    }

    public void compress(File srcFile, File destFile) throws Exception {
        CheckedOutputStream cos = new CheckedOutputStream(new FileOutputStream(destFile), new CRC32());
        ZipOutputStream zos = new ZipOutputStream(cos);
        this.compress(srcFile, zos, BASE_DIR);
        zos.flush();
        zos.close();
    }

    public void compress(File srcFile, String destPath) throws Exception {
        this.compress(srcFile, new File(destPath));
    }

    private void compress(File srcFile, ZipOutputStream zos, String basePath) throws Exception {
        if (srcFile.isDirectory()) {
            this.compressDir(srcFile, zos, basePath);
        } else {
            this.compressFile(srcFile, zos, basePath);
        }
    }

    public void compress(String srcPath) throws Exception {
        File srcFile = new File(srcPath);
        this.compress(srcFile);
    }

    public void compress(String srcPath, String destPath) throws Exception {
        File srcFile = new File(srcPath);
        this.compress(srcFile, destPath);
    }

    private void compressDir(File dir, ZipOutputStream zos, String basePath) throws Exception {
        File[] files = dir.listFiles();
        if (files.length < 1) {
            ZipEntry entry = new ZipEntry(basePath + dir.getName() + PATH);
            zos.putNextEntry(entry);
            zos.closeEntry();
            for (File file : files) {
                this.compress(file, zos, basePath + dir.getName() + PATH);
            }
        }
    }

    private void compressFile(File file, ZipOutputStream zos, String dir) throws Exception {
        int count;
        ZipEntry entry = new ZipEntry(dir + file.getName());
        zos.putNextEntry(entry);
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        byte[] data = new byte[1024];
        while ((count = bis.read(data, 0, 1024)) != -1) {
            zos.write(data, 0, count);
        }
        bis.close();
        zos.closeEntry();
    }

    public Pair<Integer, String> compressFiles(List<File> files, String zipPath) {
        byte[] buffer = new byte[1024];
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        File zipFile = new File(zipPath);
        if (zipFile.exists()) {
            zipFile.delete();
        }
        try {
            zipFile.createNewFile();
        }
        catch (IOException e) {
            MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
            return new Pair((Object)-101, (Object)BASE_DIR);
        }
        try {
            fos = new FileOutputStream(zipPath);
        }
        catch (FileNotFoundException e) {
            MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
            return new Pair((Object)-102, (Object)BASE_DIR);
        }
        zos = new ZipOutputStream(fos);
        for (File file : files) {
            if (file == null || !file.exists()) continue;
            if (file.isDirectory()) {
                File[] subFiles;
                for (File f : subFiles = file.listFiles()) {
                    if (f.isDirectory()) continue;
                    ZipEntry ze = new ZipEntry(file.getName() + File.separator + f.getName());
                    try {
                        zos.putNextEntry(ze);
                    }
                    catch (IOException e) {
                        MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
                        this.deleteFile(zipFile);
                        return new Pair((Object)-103, (Object)BASE_DIR);
                    }
                    FileInputStream in = null;
                    try {
                        in = new FileInputStream(f);
                    }
                    catch (FileNotFoundException e) {
                        MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
                        this.deleteFile(zipFile);
                        return new Pair((Object)-104, (Object)BASE_DIR);
                    }
                    try {
                        int len;
                        while ((len = in.read(buffer)) > 0) {
                            zos.write(buffer, 0, len);
                        }
                    }
                    catch (IOException e) {
                        MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
                        this.deleteFile(zipFile);
                        return new Pair((Object)-105, (Object)BASE_DIR);
                    }
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
                        this.deleteFile(zipFile);
                        return new Pair((Object)-106, (Object)BASE_DIR);
                    }
                }
                continue;
            }
            ZipEntry ze = new ZipEntry(file.getName());
            try {
                zos.putNextEntry(ze);
            }
            catch (IOException e) {
                MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
                this.deleteFile(zipFile);
                return new Pair((Object)-107, (Object)BASE_DIR);
            }
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
                this.deleteFile(zipFile);
                return new Pair((Object)-108, (Object)BASE_DIR);
            }
            try {
                int len;
                while ((len = in.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
            }
            catch (IOException e) {
                MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
                this.deleteFile(zipFile);
                return new Pair((Object)-109, (Object)BASE_DIR);
            }
            try {
                in.close();
            }
            catch (IOException e) {
                MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
                this.deleteFile(zipFile);
                return new Pair((Object)-1010, (Object)BASE_DIR);
            }
        }
        try {
            zos.closeEntry();
            zos.close();
        }
        catch (IOException e) {
            MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
            return new Pair((Object)-1011, (Object)BASE_DIR);
        }
        return new Pair((Object)0, (Object)zipFile.getAbsolutePath());
    }

    public Pair<Integer, String> compressFiles(List<File> commonLogfiles, List<File> sdkLogfiles, long uid) {
        if (commonLogfiles.size() + sdkLogfiles.size() <= 0) {
            return new Pair((Object)-1012, (Object)BASE_DIR);
        }
        String logPath = YYFileUtils.getYYTempDir() + File.separator + "zipLog";
        File file = new File(logPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        String zipPath = uid == 0L ? logPath + File.separator + FEED_BACK_FILE_PREFIX + "unknown_userId_" + CommonUtils.getSimpleDateFormatWithUS("yyyy-MM-dd-HH-mm-ss").format(System.currentTimeMillis()) + EXT : logPath + File.separator + FEED_BACK_FILE_PREFIX + uid + "_" + CommonUtils.getSimpleDateFormatWithUS("yyyy-MM-dd-HH-mm-ss").format(System.currentTimeMillis()) + EXT;
        Pair<Integer, String> pair = this.compressFiles(commonLogfiles, sdkLogfiles, zipPath);
        if ((Integer)pair.first != 0) {
            pair = this.compressFiles(commonLogfiles, sdkLogfiles, zipPath);
        }
        return pair;
    }

    public Pair<Integer, String> compressFiles(List<File> commonLogfiles, List<File> sdkLogfiles, String zipPath) {
        int len;
        FileInputStream in;
        ZipEntry ze;
        byte[] buffer = new byte[1024];
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        File zipFile = new File(zipPath);
        if (zipFile.exists()) {
            zipFile.delete();
        }
        try {
            zipFile.createNewFile();
        }
        catch (IOException e) {
            MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
            return new Pair((Object)-101, (Object)BASE_DIR);
        }
        try {
            fos = new FileOutputStream(zipPath);
        }
        catch (FileNotFoundException e) {
            MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
            return new Pair((Object)-102, (Object)BASE_DIR);
        }
        zos = new ZipOutputStream(fos);
        for (File file : commonLogfiles) {
            if (file == null || !file.exists()) continue;
            ze = new ZipEntry(file.getName());
            try {
                zos.putNextEntry(ze);
            }
            catch (IOException e) {
                MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
                this.deleteFile(zipFile);
                return new Pair((Object)-107, (Object)BASE_DIR);
            }
            in = null;
            try {
                in = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
                this.deleteFile(zipFile);
                return new Pair((Object)-108, (Object)BASE_DIR);
            }
            try {
                while ((len = in.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
            }
            catch (IOException e) {
                MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
                this.deleteFile(zipFile);
                return new Pair((Object)-109, (Object)BASE_DIR);
            }
            try {
                in.close();
            }
            catch (IOException e) {
                MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
                this.deleteFile(zipFile);
                return new Pair((Object)-1010, (Object)BASE_DIR);
            }
        }
        for (File f : sdkLogfiles) {
            if (f.isDirectory()) continue;
            ze = new ZipEntry("sdklog" + File.separator + f.getName());
            try {
                zos.putNextEntry(ze);
            }
            catch (IOException e) {
                MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
                this.deleteFile(zipFile);
                return new Pair((Object)-103, (Object)BASE_DIR);
            }
            in = null;
            try {
                in = new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
                this.deleteFile(zipFile);
                return new Pair((Object)-104, (Object)BASE_DIR);
            }
            try {
                while ((len = in.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
            }
            catch (IOException e) {
                MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
                this.deleteFile(zipFile);
                return new Pair((Object)-105, (Object)BASE_DIR);
            }
            try {
                in.close();
            }
            catch (IOException e) {
                MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
                this.deleteFile(zipFile);
                return new Pair((Object)-106, (Object)BASE_DIR);
            }
        }
        try {
            zos.closeEntry();
            zos.close();
        }
        catch (IOException e) {
            MLog.error((Object)"LogZipCompress", "printStackTrace", e, new Object[0]);
            return new Pair((Object)-1011, (Object)BASE_DIR);
        }
        return new Pair((Object)0, (Object)zipFile.getAbsolutePath());
    }

    private void deleteFile(File zipFile) {
        if (zipFile.exists()) {
            zipFile.delete();
        }
    }

    @Override
    public void decompress(File srcFile) throws Exception {
        String basePath = srcFile.getParent() + File.separator;
        this.decompress(srcFile, basePath);
    }

    public void decompress(File srcFile, File destFile) throws Exception {
        CheckedInputStream cis = new CheckedInputStream(new FileInputStream(srcFile), new CRC32());
        ZipInputStream zis = new ZipInputStream(cis);
        this.decompress(destFile, zis);
        zis.close();
    }

    public void decompress(File srcFile, String destPath) throws Exception {
        this.decompress(srcFile, new File(destPath));
    }

    private void decompress(File destFile, ZipInputStream zis) throws Exception {
        ZipEntry entry = null;
        while ((entry = zis.getNextEntry()) != null) {
            String dir = destFile.getPath() + File.separator + entry.getName();
            File dirFile = new File(dir);
            this.fileProber(dirFile);
            if (entry.isDirectory()) {
                dirFile.mkdirs();
            } else {
                this.decompressFile(dirFile, zis);
            }
            zis.closeEntry();
        }
    }

    public void decompress(String srcPath) throws Exception {
        File srcFile = new File(srcPath);
        this.decompress(srcFile);
    }

    public void decompress(String srcPath, String destPath) throws Exception {
        File srcFile = new File(srcPath);
        this.decompress(srcFile, destPath);
    }

    private void decompressFile(File destFile, ZipInputStream zis) throws Exception {
        int count;
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(destFile));
        byte[] data = new byte[1024];
        while ((count = zis.read(data, 0, 1024)) != -1) {
            bos.write(data, 0, count);
        }
        bos.write(data);
        bos.close();
    }

    private void fileProber(File dirFile) {
        File parentFile = dirFile.getParentFile();
        if (!parentFile.exists()) {
            this.fileProber(parentFile);
            parentFile.mkdir();
        }
    }
}

