/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.logger;

import android.text.TextUtils;
import android.util.Log;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.hago.xlog.KLogUtils;
import com.yy.hago.xlog.LogOptions;

public class LogRunnable
implements Runnable {
    private static final int MAX_POOL_SIZE = 100;
    private static final Object sPoolSync = new Object();
    private static int sPoolSize = 0;
    private static LogRunnable sPool;
    public LogRunnable mNext;
    private int logLevel;
    String tag;
    String format;
    Object[] args;
    Throwable t;
    String message;
    long time;
    public long size;
    public boolean needStatSize = false;

    public LogRunnable setNeedStatSize(boolean flag) {
        this.needStatSize = flag;
        return this;
    }

    public LogRunnable setLogLevel(int logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    public LogRunnable setTag(String tag) {
        this.tag = "HP" + tag;
        return this;
    }

    public LogRunnable setTime() {
        this.time = System.currentTimeMillis();
        return this;
    }

    private static long size(String str) {
        return StringUtils.isNotEmpty(str) ? (long)str.length() : 0L;
    }

    public LogRunnable setFormat(String format) {
        this.format = format;
        if (this.needStatSize) {
            this.size += LogRunnable.size(format);
        }
        return this;
    }

    public LogRunnable setArgs(Object[] args) {
        if (this.needStatSize) {
            Object[] strList = null;
            if (!FP.empty(args)) {
                strList = new Object[args.length];
                for (int i = 0; i < args.length; ++i) {
                    String temp;
                    Object o = args[i];
                    strList[i] = o == null ? "" : (this.isBaseType(o) ? o : (StringUtils.isNotEmpty(temp = o.toString()) ? temp : ""));
                }
            }
        }
        this.args = args;
        return this;
    }

    private boolean isBaseType(Object object) {
        if (object instanceof String) {
            return true;
        }
        if (object instanceof Integer) {
            return true;
        }
        if (object instanceof Float) {
            return true;
        }
        if (object instanceof Double) {
            return true;
        }
        if (object instanceof Boolean) {
            return true;
        }
        if (object instanceof Long) {
            return true;
        }
        if (object instanceof Byte) {
            return true;
        }
        return object instanceof Short;
    }

    public LogRunnable setThrowable(Throwable t) {
        this.t = t;
        if (this.needStatSize && t != null) {
            for (StackTraceElement stackTraceElement : t.getStackTrace()) {
                if (stackTraceElement == null) continue;
                this.size += LogRunnable.size(stackTraceElement.toString());
            }
            this.size += LogRunnable.size(t.getMessage());
        }
        return this;
    }

    public LogRunnable setMessage(String message) {
        this.message = message;
        if (this.needStatSize) {
            this.size += LogRunnable.size(message);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogRunnable obtain() {
        Object object = sPoolSync;
        synchronized (object) {
            if (sPool != null) {
                LogRunnable m = sPool;
                sPool = m.mNext;
                m.mNext = null;
                --sPoolSize;
                m.reset();
                return m;
            }
        }
        return new LogRunnable();
    }

    @Override
    public void run() {
        if (this.logLevel == LogOptions.LEVEL_VERBOSE) {
            this.verbose();
        } else if (this.logLevel == LogOptions.LEVEL_DEBUG) {
            this.debug();
        } else if (this.logLevel == LogOptions.LEVEL_INFO) {
            this.info();
        } else if (this.logLevel == LogOptions.LEVEL_WARN) {
            this.warn();
        } else if (this.logLevel == LogOptions.LEVEL_ERROR) {
            this.error();
        }
        this.recycle();
    }

    private void reset() {
        this.logLevel = LogOptions.LEVEL_VERBOSE;
        this.tag = "";
        this.format = "";
        this.args = null;
        this.t = null;
        this.message = "";
        this.time = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        this.reset();
        Object object = sPoolSync;
        synchronized (object) {
            if (sPoolSize < 100) {
                this.mNext = sPool;
                sPool = this;
                ++sPoolSize;
            }
        }
    }

    private void verbose() {
        KLogUtils.verbose(this.tag, this.format, this.args);
    }

    private void debug() {
        KLogUtils.debug(this.tag, this.format, this.args);
    }

    private void info() {
        KLogUtils.info(this.tag, this.format, this.args);
    }

    private void warn() {
        KLogUtils.warn(this.tag, this.format, this.args);
    }

    private void error() {
        if (this.t != null) {
            if (TextUtils.isEmpty((CharSequence)this.format)) {
                this.format = "";
            }
            KLogUtils.error(this.tag, this.format, this.t, this.args);
        } else if (!TextUtils.isEmpty((CharSequence)this.message)) {
            KLogUtils.error(this.tag, this.message, new Object[0]);
        } else {
            KLogUtils.error(this.tag, this.format, this.args);
        }
    }

    public void androidLog() {
        try {
            String showTag = this.tag;
            if (StringUtils.isEmpty(showTag)) {
                showTag = "and_default";
            }
            String showContent = this.format;
            if (this.args != null && this.args.length > 0) {
                showContent = String.format(this.format, this.args);
            }
            if (this.logLevel == LogOptions.LEVEL_VERBOSE) {
                Log.v((String)showTag, (String)showContent);
            } else if (this.logLevel == LogOptions.LEVEL_DEBUG) {
                Log.d((String)showTag, (String)showContent);
            } else if (this.logLevel == LogOptions.LEVEL_INFO) {
                Log.i((String)showTag, (String)showContent);
            } else if (this.logLevel == LogOptions.LEVEL_WARN) {
                Log.w((String)showTag, (String)showContent);
            } else if (this.logLevel == LogOptions.LEVEL_ERROR) {
                Log.e((String)showTag, (String)showContent, (Throwable)this.t);
            }
        }
        catch (Exception ex) {
            Log.e((String)"and_default", (String)"androidLog error");
        }
    }
}

