/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.imageloader.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.GifHandler;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.ThrowUtils;

public class RecycleImageView
extends YYImageView {
    private static boolean sOpenWindowInvisibleRecycle = false;
    private static IWindowInvisibleRecycler sWindowInvisibleRecycler;
    private boolean mRecycleWhenDetach = true;
    private boolean mCanRecycleWhenWindowInvisible = true;
    private boolean mAutoUseWebp = true;
    private boolean mIsWindowInForeground = true;
    private boolean mForceNotRecoveryWhenWindowVisible = false;

    public RecycleImageView(Context context) {
        super(context);
    }

    public RecycleImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public RecycleImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void onDetachedFromWindow() {
        if (this.mRecycleWhenDetach) {
            ImageLoader.recycleByNotVisible(this);
        }
        super.onDetachedFromWindow();
        this.mIsWindowInForeground = true;
        this.mForceNotRecoveryWhenWindowVisible = false;
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!(!this.mIsWindowInForeground && sOpenWindowInvisibleRecycle && sWindowInvisibleRecycler != null || this.closeRecovery())) {
            ImageLoader.recoveryByBeVisible(this);
        }
    }

    @Override
    public void setImageDrawable(Drawable drawable2) {
        super.setImageDrawable(drawable2);
        ImageLoader.onImageDrawableUpdated(this, drawable2);
    }

    @Override
    public void setBackgroundDrawable(Drawable background) {
        super.setBackgroundDrawable(background);
    }

    public void setRecycleWhenDetach(boolean flag) {
        this.mRecycleWhenDetach = flag;
    }

    public void setCanRecycleWhenWindowInvisible(boolean flag) {
        this.mCanRecycleWhenWindowInvisible = flag;
    }

    protected void onDraw(Canvas canvas) {
        if (RuntimeContext.sIsDebuggable || Build.VERSION.SDK_INT < 21) {
            super.onDraw(canvas);
        } else {
            try {
                super.onDraw(canvas);
            }
            catch (Exception e) {
                MLog.error(this, e);
            }
        }
        Drawable drawable2 = this.getImageDrawableInner();
        GifHandler.onDraw(this, drawable2);
    }

    public void invalidateDrawable(Drawable dr) {
        block2: {
            try {
                super.invalidateDrawable(dr);
            }
            catch (Exception e) {
                if (!RuntimeContext.sIsDebuggable) break block2;
                ThrowUtils.throwException(e);
            }
        }
        GifHandler.invalidateDrawable(this, dr);
    }

    @Override
    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        GifHandler.onVisibilityChanged(this, visibility);
    }

    @Override
    public void onWindowRealVisible() {
        if (this.mIsWindowInForeground) {
            return;
        }
        this.mIsWindowInForeground = true;
        if (this.mIsAttachToWindow) {
            if (!this.mForceNotRecoveryWhenWindowVisible && !this.closeRecovery()) {
                ImageLoader.recoveryByBeVisible(this);
            } else if (RuntimeContext.sIsDebuggable) {
                MLog.debug("RecycleImageView", "not recover by ForceNotRecovery:%s", this);
            }
        }
    }

    @Override
    public void onWindowInvisible() {
        if (!this.mIsWindowInForeground) {
            return;
        }
        this.mIsWindowInForeground = false;
        if (this.mCanRecycleWhenWindowInvisible && sOpenWindowInvisibleRecycle && sWindowInvisibleRecycler != null && sWindowInvisibleRecycler.canRecycle(this)) {
            ImageLoader.recycleByNotVisible(this);
        }
    }

    @Override
    public void recycleRes() {
        if (this.mIsWindowInForeground) {
            return;
        }
        if (this.mCanRecycleWhenWindowInvisible) {
            ImageLoader.recycleByNotVisible(this);
        }
    }

    @Override
    public boolean closeAutoRecycleDrawables() {
        return false;
    }

    public boolean autoTransformToWebp() {
        return this.mAutoUseWebp;
    }

    public boolean setAutoTransformToWebpFlag(boolean transform) {
        this.mAutoUseWebp = transform;
        return this.mAutoUseWebp;
    }

    public void forceNotRecoverWhenWindowVisible(boolean force) {
        this.mForceNotRecoveryWhenWindowVisible = force;
        if (!force && this.mIsWindowInForeground && this.mIsAttachToWindow && !this.closeRecovery()) {
            ImageLoader.recoveryByBeVisible(this);
        }
    }

    private boolean closeRecovery() {
        if (this.isInEditMode()) {
            return false;
        }
        return SystemUtils.isShowEnvSetting() && SettingFlags.getIntValue("image_auto_recycle", 0) == 2;
    }

    public static void setOpenWindowInvisibleRecycle(boolean open, IWindowInvisibleRecycler recycler) {
        sOpenWindowInvisibleRecycle = open;
        sWindowInvisibleRecycler = recycler;
    }

    public static boolean isWindowInvisibleRecycleOpened() {
        return sOpenWindowInvisibleRecycle;
    }

    public static interface IWindowInvisibleRecycler {
        public boolean canRecycle(RecycleImageView var1);
    }
}

