/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.imageloader.transform;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import androidx.annotation.NonNull;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.yy.base.imageloader.transform.YYBitmapTransformation;
import java.security.MessageDigest;

public class GlideRoundTransform
extends YYBitmapTransformation {
    private float radius = 0.0f;
    private static final String ID = "com.yy.base.imageloader.transform.GlideRoundTransform";
    private static final byte[] ID_BYTES = "com.yy.base.imageloader.transform.GlideRoundTransform".getBytes(CHARSET);

    public GlideRoundTransform() {
        this(4);
    }

    public GlideRoundTransform(int dp) {
        this.radius = Resources.getSystem().getDisplayMetrics().density * (float)dp;
    }

    private Bitmap roundCrop(BitmapPool pool, Bitmap source) {
        if (source == null) {
            return null;
        }
        Bitmap result = pool.get(source.getWidth(), source.getHeight(), Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(result);
        Paint paint = new Paint();
        paint.setShader((Shader)new BitmapShader(source, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
        paint.setAntiAlias(true);
        RectF rectF = new RectF(0.0f, 0.0f, (float)source.getWidth(), (float)source.getHeight());
        canvas.drawRoundRect(rectF, this.radius, this.radius, paint);
        return result;
    }

    @Override
    protected Bitmap transform(BitmapPool pool, Bitmap toTransform, int outWidth, int outHeight) {
        return this.roundCrop(pool, toTransform);
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof GlideRoundTransform;
    }

    @Override
    public int hashCode() {
        return ID.hashCode();
    }

    @Override
    public void updateDiskCacheKey(@NonNull MessageDigest messageDigest) {
        messageDigest.update(ID_BYTES);
    }
}

