/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.imageloader.transform;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import androidx.annotation.NonNull;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.util.Util;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageUtil;
import com.yy.base.imageloader.transform.YYBitmapTransformation;
import com.yy.base.logger.MLog;
import com.yy.base.utils.blur.BlurProcess;
import java.security.MessageDigest;

public class BlurTransformation
extends YYBitmapTransformation {
    private static final String TAG = "BlurTransformation";
    private static final int VERSION = 1;
    private static final String ID = "jp.wasabeef.glide.transformations.BlurTransformation.1";
    private static int MAX_RADIUS = 25;
    private static int DEFAULT_DOWN_SAMPLING = 1;
    private int radius;
    private int sampling;

    public BlurTransformation() {
        this(MAX_RADIUS, DEFAULT_DOWN_SAMPLING);
    }

    public BlurTransformation(int radius) {
        this(radius, DEFAULT_DOWN_SAMPLING);
    }

    public BlurTransformation(int radius, int sampling) {
        this.radius = radius;
        this.sampling = sampling;
    }

    @Override
    protected Bitmap transform(@NonNull BitmapPool pool, @NonNull Bitmap toTransform, int outWidth, int outHeight) {
        int width = toTransform.getWidth();
        int height = toTransform.getHeight();
        int scaledWidth = width / this.sampling;
        int scaledHeight = height / this.sampling;
        Bitmap bitmap = pool.get(scaledWidth, scaledHeight, Bitmap.Config.ARGB_8888);
        this.setCanvasBitmapDensity(toTransform, bitmap);
        Canvas canvas = new Canvas(bitmap);
        canvas.scale(1.0f / (float)this.sampling, 1.0f / (float)this.sampling);
        Paint paint = new Paint();
        paint.setFlags(2);
        canvas.drawBitmap(toTransform, 0.0f, 0.0f, paint);
        long start = System.currentTimeMillis();
        int actualRadius = this.radius;
        if (actualRadius <= 0 || actualRadius > MAX_RADIUS) {
            actualRadius = MAX_RADIUS;
        }
        bitmap = BlurProcess.blurByRenderscript(RuntimeContext.sApplicationContext, bitmap, actualRadius, this.getBlurScale(bitmap));
        long during = System.currentTimeMillis() - start;
        MLog.debug(TAG, "blur end during: %d, bitmap size: %d", during, ImageUtil.checkBitmapSize(bitmap, ""));
        return bitmap;
    }

    public String toString() {
        return "BlurTransformation(radius=" + this.radius + ", sampling=" + this.sampling + ")";
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof BlurTransformation && ((BlurTransformation)o).radius == this.radius && ((BlurTransformation)o).sampling == this.sampling;
    }

    @Override
    public int hashCode() {
        return ID.hashCode() + this.radius * 1000 + this.sampling * 10;
    }

    @Override
    public void updateDiskCacheKey(@NonNull MessageDigest messageDigest) {
        messageDigest.update((ID + this.radius + this.sampling).getBytes(CHARSET));
    }

    private void setCanvasBitmapDensity(@NonNull Bitmap toTransform, @NonNull Bitmap canvasBitmap) {
        canvasBitmap.setDensity(toTransform.getDensity());
    }

    private float getBlurScale(@NonNull Bitmap bitmap) {
        int bitmapSize = 0;
        if (!bitmap.isRecycled()) {
            bitmapSize = Util.getBitmapByteSize(bitmap);
        }
        MLog.debug(TAG, "getBlurScale source size: " + bitmapSize, new Object[0]);
        int mbSize = 0x100000;
        if (bitmapSize > 5 * mbSize) {
            return 0.5f;
        }
        if (bitmapSize > mbSize) {
            return 0.75f;
        }
        if (bitmapSize < 102400) {
            return 5.0f;
        }
        if (bitmapSize < 512000) {
            return 3.0f;
        }
        return 0.0f;
    }
}

