/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.imageloader;

import android.os.Build;
import com.bumptech.glide.load.model.GlideUrl;
import com.bumptech.glide.load.model.ModelLoaderFactory;
import java.io.InputStream;

public class ImageLoaderSetup {
    private boolean isDebug = false;
    private boolean recycleSwitch = true;
    private int bitmapPoolSize = Build.VERSION.SDK_INT > 20 ? 0x1400000 : 0xA00000;
    private int resourceCacheSize = Build.VERSION.SDK_INT > 20 ? 0x1400000 : 0xA00000;
    private ModelLoaderFactory<GlideUrl, InputStream> loaderFactory;
    private boolean bigImageAutoRecycle = true;
    private int bigRecycleSizeMultiplier = 5;

    ImageLoaderSetup() {
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public boolean isRecycleSwitch() {
        return this.recycleSwitch;
    }

    public int getBitmapPoolSize() {
        return this.bitmapPoolSize;
    }

    public int getResourceCacheSize() {
        return this.resourceCacheSize;
    }

    public ModelLoaderFactory<GlideUrl, InputStream> getLoaderFactory() {
        return this.loaderFactory;
    }

    public boolean isBigImageAutoRecycle() {
        return this.bigImageAutoRecycle;
    }

    public int getBigRecycleSizeMultiplier() {
        return this.bigRecycleSizeMultiplier;
    }

    public static class Builder {
        private ImageLoaderSetup mSetup = new ImageLoaderSetup();

        Builder() {
        }

        public Builder isDebug(boolean isDebug) {
            this.mSetup.isDebug = isDebug;
            return this;
        }

        public Builder recycleSwitch(boolean recycleSwitch) {
            this.mSetup.recycleSwitch = recycleSwitch;
            return this;
        }

        public Builder bitmapPoolSize(int bitmapPoolSize) {
            if (bitmapPoolSize > 0) {
                this.mSetup.bitmapPoolSize = bitmapPoolSize;
            }
            return this;
        }

        public Builder resourceCacheSize(int resourceCacheSize) {
            if (resourceCacheSize > 0) {
                this.mSetup.resourceCacheSize = resourceCacheSize;
            }
            return this;
        }

        public Builder bigImgAutoRecycle(boolean bigImgAutoRecycle) {
            this.mSetup.bigImageAutoRecycle = bigImgAutoRecycle;
            return this;
        }

        public Builder bigRecycleSizeMultiplier(int bigRecycleSizeMultiplier) {
            if (bigRecycleSizeMultiplier > 0) {
                this.mSetup.bigRecycleSizeMultiplier = bigRecycleSizeMultiplier;
            }
            return this;
        }

        public Builder loaderFactory(ModelLoaderFactory<GlideUrl, InputStream> loaderFactory) {
            this.mSetup.loaderFactory = loaderFactory;
            return this;
        }

        public ImageLoaderSetup build() {
            return this.mSetup;
        }
    }
}

