/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.imageloader;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.engine.PerformanceData;
import com.bumptech.glide.load.model.GlideUrl;
import com.bumptech.glide.load.resource.bitmap.BitmapTransitionOptions;
import com.bumptech.glide.load.resource.bitmap.DownsampleStrategy;
import com.bumptech.glide.load.resource.gif.GifDrawable;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.FutureTarget;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.CustomTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.bumptech.glide.signature.EmptySignature;
import com.yy.base.imageloader.BaseImageData;
import com.yy.base.imageloader.DataCacheKey;
import com.yy.base.imageloader.ImageBitmapData;
import com.yy.base.imageloader.ImageData;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.ImageLoaderSetup;
import com.yy.base.imageloader.ImageUtil;
import com.yy.base.imageloader.httptohttpsstrategyimpl.HttpsSchemeTransformStrategy;
import com.yy.base.imageloader.strategy.StrategySelector;
import com.yy.base.imageloader.strategy.StrategyStatus;
import com.yy.base.imageloader.transform.GlideCircleTransform;
import com.yy.base.imageloader.transform.GlideRoundTransform;
import com.yy.base.imageloader.transform.YYBitmapTransformation;
import com.yy.base.logger.MLog;
import com.yy.base.logger.perf.PerfActionLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.network.NetworkUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

class ImageInnerHandler {
    public static final int TYPE_BITMAP = 0;
    public static final int TYPE_GIFT = 1;
    public static final int TYPE_WEBPANIM = 2;
    private static final String TAG = "ImageInnerHandler";
    private final BitmapTransitionOptions mCrossFade = BitmapTransitionOptions.withCrossFade(600);
    private final ImageLoaderSetup mSetupData;
    private final ImageLoader.ImageLoaderDelegate mDelegate;

    ImageInnerHandler(ImageLoaderSetup setupData, ImageLoader.ImageLoaderDelegate delegate) {
        this.mSetupData = setupData;
        this.mDelegate = delegate;
    }

    void clearRequest(Context context, Object target) {
        if (target instanceof View) {
            Glide.with(context).clear((View)target);
        } else if (target instanceof Target) {
            Glide.with(context).clear((Target)target);
        }
    }

    void pauseRequest(Context context, boolean isRecursive) {
        if (isRecursive) {
            Glide.with(context).pauseRequestsRecursive();
        } else {
            Glide.with(context).pauseRequests();
        }
    }

    void resumeRequest(Context context, boolean isRecursive) {
        if (isRecursive) {
            Glide.with(context).resumeRequestsRecursive();
        } else {
            Glide.with(context).resumeRequests();
        }
    }

    void clearDiskCache(Context context, @Nullable Key key) {
        YYTaskExecutor.execute(() -> {
            if (key == null) {
                Glide.get(context).clearDiskCache();
            } else {
                Glide.get(context).clearDiskCache(key);
            }
        });
    }

    void trimMemory(Context context, int level) {
        YYTaskExecutor.execute(() -> {
            Glide glide = Glide.get(context);
            YYTaskExecutor.postToMainThread(() -> glide.trimMemory(level));
        });
    }

    void clearMemory(Context context) {
        YYTaskExecutor.execute(() -> {
            Glide glide = Glide.get(context);
            YYTaskExecutor.postToMainThread(glide::clearMemory);
        });
    }

    private boolean toGif(String url, boolean enableGif, boolean asGif) {
        return enableGif && (this.mDelegate != null && this.mDelegate.canAnim() && asGif || ImageUtil.isGifUrl(url));
    }

    private boolean toWebPAnim(String url, boolean enableGif, boolean asGif) {
        boolean result = ImageUtil.isWebPAnim(url);
        if (!result) {
            result = this.toGif(url, enableGif, asGif) && url != null && url.contains("/format,webp");
        }
        return result;
    }

    void preload(@Nullable Context context, @Nullable String url, int width, int height) {
        if (context == null || TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        int w = width;
        int h = height;
        if (w <= 0) {
            w = Integer.MIN_VALUE;
        }
        if (h <= 0) {
            h = Integer.MIN_VALUE;
        }
        MLog.debug(TAG, "preload url: %s , width: %d, height: %d", url, w, h);
        if (this.toWebPAnim(url, true, false)) {
            ((RequestBuilder)((BaseRequestOptions)Glide.with(context).load(url)).diskCacheStrategy(DiskCacheStrategy.AUTOMATIC)).preload(w, h);
        } else if (this.toGif(url, true, false)) {
            ((RequestBuilder)((BaseRequestOptions)Glide.with(context).asGif().load(url)).diskCacheStrategy(DiskCacheStrategy.AUTOMATIC)).preload(w, h);
        } else {
            ((RequestBuilder)((BaseRequestOptions)Glide.with(context).asBitmap().load(url)).diskCacheStrategy(DiskCacheStrategy.AUTOMATIC)).preload(w, h);
        }
    }

    FutureTarget<File> loadFile(@NonNull Context context, @NonNull Object loadObj) {
        return ((RequestBuilder)Glide.with(context).load(loadObj)).downloadOnly(Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    void loadBitmap(final @Nullable Context context, final @Nullable ImageBitmapData bitmapData) {
        BitmapDrawable drawableFromCache;
        if (bitmapData == null) {
            return;
        }
        if (bitmapData.useCacheForOrigin && (drawableFromCache = ImageLoader.getBitmapFromCache(bitmapData.originUrl)) != null) {
            if (bitmapData.listener != null) {
                bitmapData.listener.onResourceReady(drawableFromCache.getBitmap());
            }
            return;
        }
        if (context instanceof Activity && ((Activity)context).isDestroyed()) {
            MLog.warn(TAG, "loadBitmap fail context is destroyed", new Object[0]);
            return;
        }
        if (context == null) {
            MLog.warn(TAG, "loadBitmap fail context is null", new Object[0]);
            return;
        }
        if (this.mSetupData != null && this.mSetupData.isDebug()) {
            MLog.info(TAG, "loadBitmap url: " + bitmapData.url, new Object[0]);
        }
        if (SystemUtils.isShowEnvSetting()) {
            PerfActionLog.add("ImageLoader_loadBitmap\uff1a%s", bitmapData.url);
        }
        int rWidth = ImageUtil.isValidDimension(bitmapData.width) ? bitmapData.width : Integer.MIN_VALUE;
        int rHeight = ImageUtil.isValidDimension(bitmapData.height) ? bitmapData.height : Integer.MIN_VALUE;
        CustomTarget<Bitmap> target = new CustomTarget<Bitmap>(rWidth, rHeight){

            @Override
            public void onResourceReady(@NonNull Bitmap resource, @Nullable Transition<? super Bitmap> transition) {
                MLog.debug(ImageInnerHandler.TAG, "loadBitmap onReady: %s, isMainThread: %b", bitmapData.url, YYTaskExecutor.isMainThread());
                if (bitmapData.useCacheForOrigin) {
                    ImageLoader.addBitmapToCache(bitmapData.originUrl, new BitmapDrawable(context.getResources(), resource));
                }
                if (bitmapData.listener != null) {
                    bitmapData.listener.onResourceReady(resource);
                }
                ImageInnerHandler.this.reportMonitorForSuccess(bitmapData, resource, true, null, null);
            }

            @Override
            public void onLoadCleared(Drawable placeholder) {
                MLog.debug(ImageInnerHandler.TAG, "loadBitmap onLoadCleared", new Object[0]);
                ImageInnerHandler.this.reportMonitorForClear(bitmapData);
            }

            @Override
            public void onLoadFailed(Drawable errorDrawable) {
                Exception e = new Exception("");
                if (bitmapData.listener != null) {
                    bitmapData.listener.onLoadFailed(e);
                }
                ImageInnerHandler.this.reportMonitorForFail(bitmapData, e);
                MLog.error((Object)ImageInnerHandler.TAG, "loadBitmap error: " + bitmapData.url, new Object[0]);
            }
        };
        RequestBuilder request = Glide.with(context).asBitmap().load(bitmapData.getLoadObj());
        request = this.buildRequest(context, request, bitmapData, 0);
        ((RequestBuilder)request.apply((BaseRequestOptions)new RequestOptions().downsample(DownsampleStrategy.AT_MOST)).diskCacheStrategy(bitmapData.skipDiskCache ? DiskCacheStrategy.NONE : DiskCacheStrategy.AUTOMATIC)).into(target);
    }

    void loadImage(@Nullable ImageView imageView, @Nullable ImageData imageData) {
        if (imageView == null || imageData == null) {
            return;
        }
        ImageData currentData = ImageLoader.checkData(imageView);
        if (Objects.equals(currentData, imageData)) {
            String url;
            ImageLoader.clearRequest(imageView);
            String string2 = url = imageData.useBackup ? imageData.backUrl : imageData.url;
            if (TextUtils.isEmpty((CharSequence)url) && this.mDelegate != null && this.mDelegate.fixEmptyUrl()) {
                if (imageData.placeholderDrawable != null) {
                    imageView.setImageDrawable(imageData.placeholderDrawable);
                } else if (imageData.placeholderId > 0) {
                    imageView.setImageResource(imageData.placeholderId);
                } else if (imageData.errorDrawable != null) {
                    imageView.setImageDrawable(imageData.errorDrawable);
                } else if (imageData.errorId > 0) {
                    imageView.setImageResource(imageData.errorId);
                } else {
                    imageView.setImageDrawable(null);
                }
                MLog.debug(TAG, "empty url fix", new Object[0]);
                return;
            }
            Context context = imageView.getContext();
            if (context instanceof Activity && ((Activity)context).isDestroyed()) {
                MLog.warn(TAG, "loadImage fail, context is destroyed", new Object[0]);
                return;
            }
            if (context == null) {
                MLog.warn(TAG, "loadImage fail context is null", new Object[0]);
                return;
            }
            if (this.mSetupData != null && this.mSetupData.isDebug()) {
                MLog.debug(TAG, "inner load useBackup: %b, useCacheForOrigin: %b, url: %s, origin url: %s", imageData.useBackup, imageData.useCacheForOrigin, url, imageData.originUrl);
            }
            if (SystemUtils.isShowEnvSetting()) {
                PerfActionLog.add("ImageLoader_loadImage\uff1a%s", url);
            }
            int loadType = 0;
            if (this.toWebPAnim(url, imageData.enableGif, imageData.asGif)) {
                loadType = 2;
            } else if (this.toGif(url, imageData.enableGif, imageData.asGif)) {
                loadType = 1;
                url = url != null && url.contains("/format,webp") ? url.replace("/format,webp", "") : url;
            }
            imageData.url = url;
            switch (loadType) {
                case 0: {
                    this.loadNormalImage(context, imageView, imageData);
                    break;
                }
                case 2: {
                    this.loadWebPAnim(context, imageView, imageData);
                    break;
                }
                case 1: {
                    this.loadGifAnim(context, imageView, imageData);
                    break;
                }
            }
        } else {
            MLog.debug(TAG, "loadImage fail, imageData has changed", new Object[0]);
        }
    }

    private <T> RequestBuilder<T> buildRequest(@NonNull Context context, @NonNull RequestBuilder<T> requestBuilder, @NonNull BaseImageData imageData, int loadType) {
        switch (loadType) {
            case 0: {
                if (imageData.thumbnail != null && !Objects.equals(imageData.thumbnail, imageData.url)) {
                    MLog.debug(TAG, "buildRequest thumbnail: " + imageData.thumbnail, new Object[0]);
                    requestBuilder = requestBuilder.thumbnail((RequestBuilder)((BaseRequestOptions)Glide.with(context).asBitmap().load(imageData.thumbnail)).override(Integer.MIN_VALUE));
                }
                ArrayList<YYBitmapTransformation> transformationList = new ArrayList<YYBitmapTransformation>();
                if (imageData.circle) {
                    transformationList.add(new GlideCircleTransform());
                }
                if (imageData.round > 0) {
                    transformationList.add(new GlideRoundTransform(imageData.round));
                }
                if (imageData.transformations != null && imageData.transformations.length > 0) {
                    transformationList.addAll(Arrays.asList(imageData.transformations));
                }
                if (transformationList.isEmpty()) break;
                requestBuilder = (RequestBuilder)requestBuilder.transform(transformationList.toArray(new Transformation[transformationList.size()]));
                break;
            }
            case 2: {
                if (imageData.thumbnail == null || Objects.equals(imageData.thumbnail, imageData.url)) break;
                MLog.debug(TAG, "buildRequest thumbnail: " + imageData.thumbnail, new Object[0]);
                requestBuilder = requestBuilder.thumbnail((RequestBuilder)((BaseRequestOptions)Glide.with(context).load(imageData.thumbnail)).override(Integer.MIN_VALUE));
                break;
            }
        }
        requestBuilder = (RequestBuilder)requestBuilder.diskCacheStrategy(imageData.skipDiskCache ? DiskCacheStrategy.NONE : DiskCacheStrategy.AUTOMATIC);
        if (imageData.skipMemCache) {
            requestBuilder = (RequestBuilder)requestBuilder.skipMemoryCache(true);
        }
        if (imageData.placeholderDrawable != null) {
            requestBuilder = (RequestBuilder)requestBuilder.placeholder(imageData.placeholderDrawable);
        } else if (imageData.placeholderId != -1) {
            requestBuilder = (RequestBuilder)requestBuilder.placeholder(imageData.placeholderId);
        }
        if (imageData.errorDrawable != null) {
            requestBuilder = (RequestBuilder)requestBuilder.error(imageData.errorDrawable);
        } else if (imageData.errorId != -1) {
            requestBuilder = (RequestBuilder)requestBuilder.error(imageData.errorId);
        }
        if (imageData.useOriginalSize) {
            requestBuilder = (RequestBuilder)requestBuilder.override(Integer.MIN_VALUE, Integer.MIN_VALUE);
        } else if (imageData.isOverrideSize && ImageUtil.isValidDimensions(imageData.width, imageData.height)) {
            requestBuilder = (RequestBuilder)requestBuilder.override(imageData.width, imageData.height);
        }
        if (imageData.sizeMultiplier > 0.0f && imageData.sizeMultiplier < 1.0f) {
            requestBuilder = (RequestBuilder)requestBuilder.sizeMultiplier(imageData.sizeMultiplier);
        }
        if (loadType != 1 && imageData.decodeFormat != null) {
            requestBuilder = (RequestBuilder)requestBuilder.format(imageData.decodeFormat);
        }
        this.reportMonitorForStart(imageData);
        return requestBuilder;
    }

    private void handleLoadFail(final ImageView imageView, final ImageData imageData, boolean isFirstResource, final GlideException exception, final int loadType) {
        imageData.loadSuccess = false;
        YYTaskExecutor.postToMainThread(new Runnable(){

            @Override
            public void run() {
                if (imageData.listener != null) {
                    imageData.listener.onLoadFailed(exception);
                }
                ImageInnerHandler.this.reportMonitorForFail(imageData, exception);
                if (loadType == 0) {
                    StrategySelector.getStrategySelector(HttpsSchemeTransformStrategy.class).strategySelectorStatus(StrategyStatus.FAIL, imageData.loadId);
                    if (ImageInnerHandler.this.checkCanRetry(imageView, imageData, exception)) {
                        Runnable command = () -> ImageInnerHandler.this.retryLoad(imageView, imageData, exception);
                        ImageInnerHandler.this.executeRetryStrategy(command, imageData);
                        ImageInnerHandler.this.printErrorCauses(imageData, exception);
                    } else {
                        MLog.debug(ImageInnerHandler.TAG, "handleLoadFail, check can not retry, url: %s, exception: %s", imageData.url, exception);
                    }
                }
            }
        });
    }

    private void handleLoadSuccess(@NonNull ImageView imageView, final @NonNull ImageData imageData, final Object resource, final DataSource dataSource, final boolean isFirstResource, final PerformanceData performanceData, final int loadType) {
        imageData.loadSuccess = true;
        YYTaskExecutor.postToMainThread(new Runnable(){

            @Override
            public void run() {
                if (imageData.listener != null) {
                    imageData.listener.onResourceReady(resource, isFirstResource, dataSource);
                }
                ImageInnerHandler.this.reportMonitorForSuccess(imageData, resource, isFirstResource, dataSource, performanceData);
                if (loadType == 0) {
                    StrategySelector.getStrategySelector(HttpsSchemeTransformStrategy.class).strategySelectorStatus(StrategyStatus.SUCESS, imageData.loadId);
                }
            }
        });
    }

    private void loadWebPAnim(@NonNull Context context, final @NonNull ImageView imageView, final @NonNull ImageData imageData) {
        RequestBuilder<Object> requestBuilder = Glide.with(context).load(imageData.url);
        requestBuilder = this.buildRequest(context, requestBuilder, imageData, 2);
        requestBuilder = requestBuilder.listener(new RequestListener<Drawable>(){

            @Override
            public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                MLog.error((Object)ImageInnerHandler.TAG, "loadWebPAnim error:" + imageData.url, e, new Object[0]);
                ImageInnerHandler.this.handleLoadFail(imageView, imageData, isFirstResource, e, 2);
                return false;
            }

            @Override
            public boolean onResourceReady(Drawable resource, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource, PerformanceData performanceData) {
                MLog.debug(ImageInnerHandler.TAG, "loadWebPAnim success url: %s, isFirstResource: %b, dataSource: %s, isMainThread: %b", new Object[]{model, isFirstResource, dataSource, YYTaskExecutor.isMainThread()});
                ImageInnerHandler.this.handleLoadSuccess(imageView, imageData, resource, dataSource, isFirstResource, performanceData, 2);
                return false;
            }
        });
        requestBuilder.into(imageView);
    }

    public void loadGifAnim(@NonNull Context context, final @NonNull ImageView imageView, final @NonNull ImageData imageData) {
        RequestBuilder<Object> requestBuilder = Glide.with(context).asGif().load(imageData.url);
        requestBuilder = this.buildRequest(context, requestBuilder, imageData, 1);
        requestBuilder = requestBuilder.listener(new RequestListener<GifDrawable>(){

            @Override
            public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<GifDrawable> target, boolean isFirstResource) {
                MLog.error((Object)ImageInnerHandler.TAG, "loadGif error:" + imageData.url, e, new Object[0]);
                ImageInnerHandler.this.handleLoadFail(imageView, imageData, isFirstResource, e, 1);
                return false;
            }

            @Override
            public boolean onResourceReady(GifDrawable resource, Object model, Target<GifDrawable> target, DataSource dataSource, boolean isFirstResource, PerformanceData performanceData) {
                MLog.debug(ImageInnerHandler.TAG, "loadGif success url: %s, isFirstResource: %b, dataSource: %s, isMainThread: %b", new Object[]{model, isFirstResource, dataSource, YYTaskExecutor.isMainThread()});
                ImageInnerHandler.this.handleLoadSuccess(imageView, imageData, resource, dataSource, isFirstResource, performanceData, 1);
                return false;
            }
        });
        requestBuilder.into(imageView);
    }

    private void loadNormalImage(final @NonNull Context context, final @NonNull ImageView imageView, final @NonNull ImageData imageData) {
        RequestBuilder<Bitmap> requestBuilder = Glide.with(context).asBitmap().load(imageData.url);
        requestBuilder = this.buildRequest(context, requestBuilder, imageData, 0);
        if (this.mDelegate != null && !this.mDelegate.canAnim()) {
            requestBuilder = (RequestBuilder<Bitmap>)requestBuilder.dontAnimate();
        } else if (imageData.crossFade) {
            requestBuilder = requestBuilder.transition(this.mCrossFade);
        }
        requestBuilder = requestBuilder.listener(new RequestListener<Bitmap>(){

            @Override
            public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Bitmap> target, boolean isFirstResource) {
                MLog.error((Object)ImageInnerHandler.TAG, "loadNormal error: " + imageData.url, e, new Object[0]);
                ImageInnerHandler.this.handleLoadFail(imageView, imageData, isFirstResource, e, 0);
                return false;
            }

            @Override
            public boolean onResourceReady(Bitmap resource, Object model, Target<Bitmap> target, DataSource dataSource, boolean isFirstResource, PerformanceData performanceData) {
                MLog.debug(ImageInnerHandler.TAG, "loadNormal success url: %s, isFirstResource: %b, dataSource: %s, isMainThread: %b", new Object[]{model, isFirstResource, dataSource, YYTaskExecutor.isMainThread()});
                if (imageData.useCacheForOrigin) {
                    ImageLoader.addBitmapToCache(imageData.originUrl, new BitmapDrawable(context.getResources(), resource));
                }
                ImageInnerHandler.this.handleLoadSuccess(imageView, imageData, resource, dataSource, isFirstResource, performanceData, 0);
                return false;
            }
        });
        requestBuilder.into(imageView);
    }

    private String getBackupUrl(@Nullable String backupUrl, @Nullable String originUrl) {
        if (TextUtils.isEmpty((CharSequence)backupUrl) && this.mDelegate != null) {
            backupUrl = this.mDelegate.getBackup(originUrl);
        }
        backupUrl = StrategySelector.getStrategySelector(HttpsSchemeTransformStrategy.class).strategySelectorResult(StrategyStatus.START, backupUrl);
        return backupUrl;
    }

    private void printErrorCauses(ImageData imageData, GlideException e) {
        if (!TextUtils.isEmpty((CharSequence)imageData.url)) {
            MLog.error((Object)TAG, "loadImage error retry:" + imageData.retryTime + " " + imageData.url + " error:" + (e != null ? e.toString() : ""), new Object[0]);
            if (e != null) {
                for (Throwable t : e.getRootCauses()) {
                    MLog.error((Object)TAG, "Caused by", t, new Object[0]);
                }
            }
        }
    }

    private void executeRetryStrategy(Runnable runnable, ImageData imageData) {
        if (YYTaskExecutor.isMainThread() && imageData.retryTime < 1) {
            runnable.run();
            return;
        }
        int delay = 0;
        if (imageData.retryTime == 1) {
            delay = 500;
        } else if (imageData.retryTime > 1) {
            delay = 1000;
        }
        YYTaskExecutor.postToMainThread(runnable, delay);
    }

    private void retryLoad(ImageView imageView, ImageData imageData, GlideException exception) {
        if (imageView == null) {
            return;
        }
        boolean isUseBackupUrl = false;
        boolean isUseMemCache = false;
        ImageData newImageData = imageData;
        if (newImageData.retryTime == 0) {
            StrategySelector.getStrategySelector(HttpsSchemeTransformStrategy.class).strategySelectorStatus(StrategyStatus.START, imageData.loadId);
            newImageData.url = StrategySelector.getStrategySelector(HttpsSchemeTransformStrategy.class).strategySelectorResult(StrategyStatus.START, newImageData.url);
            newImageData.backUrl = this.getBackupUrl(newImageData.backUrl, newImageData.url);
            isUseBackupUrl = !TextUtils.isEmpty((CharSequence)newImageData.backUrl);
            isUseMemCache = true;
            this.reportMonitorForHappenError(newImageData);
            MLog.info(TAG, "use https retry!", new Object[0]);
        } else if (!this.isBitmapError(exception)) {
            isUseMemCache = true;
        }
        MLog.error((Object)TAG, "retryLoad url:" + newImageData.url + " back url " + newImageData.backUrl + " isUseBackupUrl " + isUseBackupUrl, new Object[0]);
        newImageData.skipMemCache = !isUseMemCache;
        newImageData.useBackup = isUseBackupUrl;
        ++newImageData.retryTime;
        this.loadImage(imageView, imageData);
    }

    private boolean isBitmapError(Exception e) {
        String errorInfo = e != null ? e.toString() : "";
        return !TextUtils.isEmpty((CharSequence)errorInfo) && errorInfo.contains("Problem decoding into existing bitmap");
    }

    private boolean checkCanRetry(@Nullable ImageView imageView, @Nullable ImageData imageData, @Nullable GlideException exception) {
        String errInfo;
        Activity activity;
        if (imageView == null || imageData == null) {
            MLog.warn(TAG, "checkCanRetry fail, imageview is null", new Object[0]);
            return false;
        }
        Context context = imageView.getContext();
        if (context == null) {
            MLog.warn(TAG, "checkCanRetry fail, imageview context is null", new Object[0]);
            return false;
        }
        if (context instanceof Activity && (activity = (Activity)context).isDestroyed()) {
            MLog.warn(TAG, "checkCanRetry fail, context is destroy", new Object[0]);
            return false;
        }
        String string2 = errInfo = exception != null ? exception.toString() : "";
        if (errInfo.contains("setDataSource failed: status = 0x80000000") && imageData.url.startsWith("http")) {
            MLog.error((Object)TAG, "deleteExceptionCacheFile loadImage error:" + imageData.url, exception, new Object[0]);
            this.clearDiskCache(context, new DataCacheKey(new GlideUrl(imageData.url), EmptySignature.obtain()));
        }
        if (!NetworkUtils.isNetworkAvailable(context)) {
            MLog.error((Object)TAG, "loadImage Network not Available!", new Object[0]);
            return false;
        }
        boolean is404Err = errInfo.contains("404");
        if (!is404Err) {
            return (this.isBitmapError(exception) && imageData.retryTime <= 3 || imageData.retryTime < 2) && !TextUtils.isEmpty((CharSequence)imageData.url) && imageData.url.startsWith("http");
        }
        return false;
    }

    private void reportMonitorForStart(BaseImageData imageData) {
        List<ImageLoader.IMonitor> monitorList = imageData.monitors;
        if (monitorList != null) {
            for (ImageLoader.IMonitor monitor : monitorList) {
                monitor.onStart(imageData.loadId, imageData instanceof ImageData, imageData.url, imageData.width, imageData.height);
            }
        }
    }

    private void reportMonitorForSuccess(BaseImageData imageData, Object resource, boolean isFirstResource, DataSource dataSource, PerformanceData performanceData) {
        List<ImageLoader.IMonitor> monitorList = imageData.monitors;
        if (monitorList != null) {
            int size = 0;
            if (resource instanceof Bitmap) {
                size = ImageUtil.checkBitmapSize((Bitmap)resource, imageData.url);
            } else if (resource instanceof Drawable) {
                size = ImageUtil.checkBitmapSize(ImageLoader.getBitmapFromCustomDrawable((Drawable)resource), imageData.url);
            }
            for (ImageLoader.IMonitor monitor : monitorList) {
                monitor.onSuccess(imageData.loadId, imageData.url, size, isFirstResource, dataSource, performanceData);
            }
        }
    }

    private void reportMonitorForFail(BaseImageData imageData, Exception exception) {
        List<ImageLoader.IMonitor> monitorList = imageData.monitors;
        if (monitorList != null) {
            if (exception == null) {
                exception = new Exception("");
            }
            for (ImageLoader.IMonitor monitor : monitorList) {
                monitor.onError(imageData.loadId, imageData.url, exception);
            }
        }
    }

    private void reportMonitorForClear(BaseImageData imageData) {
        List<ImageLoader.IMonitor> monitorList = imageData.monitors;
        if (monitorList != null) {
            for (ImageLoader.IMonitor monitor : monitorList) {
                monitor.onClear(imageData.loadId);
            }
        }
    }

    private void reportMonitorForHappenError(BaseImageData imageData) {
        List<ImageLoader.IMonitor> monitorList = imageData.monitors;
        if (monitorList != null) {
            for (ImageLoader.IMonitor monitor : monitorList) {
                monitor.onHappenHttpError(imageData.url);
            }
        }
    }
}

