/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.imageloader;

import android.net.Uri;
import android.text.TextUtils;
import com.yy.base.imageloader.ImageFormatTransformer$WhenMappings;
import com.yy.base.imageloader.ImgFormatInfo;
import com.yy.base.logger.MLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0017H\u0002J\u0010\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0017H\u0002J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0017H\u0002J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0017H\u0002J(\u0010\u001d\u001a\u00020\u001e2\n\u0010\u001f\u001a\u00060 j\u0002`!2\b\u0010\"\u001a\u0004\u0018\u00010\u00062\b\u0010#\u001a\u0004\u0018\u00010\u0006H\u0002J\u000e\u0010$\u001a\u00020%2\u0006\u0010\u0019\u001a\u00020\u0017J\u0010\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u0006H\u0002J\u0010\u0010(\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/yy/base/imageloader/ImageFormatTransformer;", "", "()V", "HEIF_LEVEL", "", "HEIF_MATCH_RULE", "", "HEIF_SEGMENT", "HEIF_SIZE_DIVIDER", "HEIF_VERSION", "OSS_PARAM_MATCH_RULE", "OSS_PARAM_PART", "OSS_RESIZE_MATCH_RULE", "OSS_RESIZE_PART", "OSS_WEBP_MATCH_RULE", "OSS_WEBP_PART", "TAG", "getHEIFSupportSizeList", "", "uri", "Landroid/net/Uri;", "getRealRequestUrl", "formatInfo", "Lcom/yy/base/imageloader/ImgFormatInfo;", "handleForHEIF", "imgFormatInfo", "handleForOrigin", "handleForResize", "handleForWebp", "handleUrlForOss", "", "urlBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "resizePart", "webpPart", "isHeifSupport", "", "removeDuplicatedOssParam", "url", "removeOssParam", "framework-base_release"})
public final class ImageFormatTransformer {
    private static final String OSS_PARAM_MATCH_RULE = "?x-oss-process=image";
    private static final String OSS_PARAM_PART = "?x-oss-process=image";
    private static final String OSS_RESIZE_PART = "/resize,";
    private static final String OSS_RESIZE_MATCH_RULE = "/resize,w_([0-9]+),h_([0-9]+)";
    private static final String OSS_WEBP_MATCH_RULE = "/format,webp";
    private static final String OSS_WEBP_PART = "/format,webp";
    private static final String HEIF_MATCH_RULE = "_heif_([0-9]+)";
    private static final String HEIF_SEGMENT = "heif";
    private static final String HEIF_SIZE_DIVIDER = "x";
    private static final int HEIF_LEVEL = 10;
    private static final String HEIF_VERSION = "v1";
    private static final String TAG = "ImageFormatTransformer";
    public static final ImageFormatTransformer INSTANCE;

    @JvmStatic
    @Nullable
    public static final String getRealRequestUrl(@NotNull ImgFormatInfo formatInfo) {
        Intrinsics.checkParameterIsNotNull((Object)formatInfo, (String)"formatInfo");
        String newUrl = formatInfo.getOriginUrl();
        CharSequence charSequence = newUrl;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            return newUrl;
        }
        if (!StringsKt.startsWith$default((String)newUrl, (String)"http", (boolean)false, (int)2, null)) {
            return INSTANCE.removeOssParam(newUrl);
        }
        try {
            formatInfo.setOriginUrl(INSTANCE.removeDuplicatedOssParam(newUrl));
            switch (ImageFormatTransformer$WhenMappings.$EnumSwitchMapping$0[formatInfo.getFormat().ordinal()]) {
                case 1: {
                    return INSTANCE.handleForHEIF(formatInfo);
                }
                case 2: {
                    return INSTANCE.handleForWebp(formatInfo);
                }
                case 3: {
                    return INSTANCE.handleForResize(formatInfo);
                }
                case 4: {
                    return INSTANCE.handleForOrigin(formatInfo);
                }
            }
            MLog.warn(TAG, "getRealRequestUrl pass, format: " + (Object)((Object)formatInfo.getFormat()), new Object[0]);
        }
        catch (Exception ex) {
            MLog.error((Object)TAG, "getRealRequestUrl error", ex, new Object[0]);
        }
        return newUrl;
    }

    private final String handleForHEIF(ImgFormatInfo imgFormatInfo) {
        Uri originUri;
        String string2 = imgFormatInfo.getOriginUrl();
        if (string2 == null) {
            string2 = "";
        }
        Uri uri = originUri = Uri.parse((String)string2);
        Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"originUri");
        List pathSegments = uri.getPathSegments();
        int heifPathIndex = pathSegments.indexOf(HEIF_SEGMENT);
        if (heifPathIndex == -1) {
            throw (Throwable)new Exception("transform heif fail, has not heif segment");
        }
        List list = pathSegments;
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"pathSegments");
        List newPathSegments = CollectionsKt.toMutableList((Collection)list);
        newPathSegments.subList(heifPathIndex, heifPathIndex + 3).clear();
        Uri.Builder uriBuilder = originUri.buildUpon();
        uriBuilder.path("");
        for (String path : newPathSegments) {
            uriBuilder.appendPath(path);
        }
        uriBuilder.clearQuery();
        String string3 = uriBuilder.build().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"uriBuilder.build().toString()");
        String newUrl = string3;
        int requestSize = 0;
        List<Integer> sizeList = this.getHEIFSupportSizeList(originUri);
        int wantSize = imgFormatInfo.getMaxSize();
        Iterable $this$forEach$iv = sizeList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl = false;
            int n = it - wantSize;
            boolean bl2 = false;
            if (Math.abs(n) > 10 || it <= requestSize) continue;
            requestSize = it;
        }
        return newUrl + "_heif_" + requestSize;
    }

    private final void handleUrlForOss(StringBuilder urlBuilder, String resizePart, String webpPart) {
        if (!StringsKt.contains$default((CharSequence)urlBuilder, (CharSequence)"?x-oss-process=image", (boolean)false, (int)2, null)) {
            urlBuilder.append("?x-oss-process=image");
        }
        CharSequence charSequence = urlBuilder;
        String string2 = OSS_RESIZE_MATCH_RULE;
        boolean bl = false;
        string2 = new Regex(string2);
        bl = false;
        if (!string2.containsMatchIn(charSequence)) {
            int index;
            charSequence = resizePart;
            boolean bl2 = false;
            bl = false;
            if (!(charSequence == null || charSequence.length() == 0) && (index = urlBuilder.indexOf("?x-oss-process=image")) >= 0) {
                urlBuilder.insert(index + "?x-oss-process=image".length(), resizePart);
            }
        }
        CharSequence charSequence2 = urlBuilder;
        String string3 = "/format,webp";
        bl = false;
        string3 = new Regex(string3);
        bl = false;
        if (!string3.containsMatchIn(charSequence2)) {
            charSequence2 = webpPart;
            boolean bl3 = false;
            bl = false;
            if (!(charSequence2 == null || charSequence2.length() == 0)) {
                urlBuilder.append(webpPart);
            }
        }
    }

    private final String handleForWebp(ImgFormatInfo imgFormatInfo) {
        String string2 = imgFormatInfo.getOriginUrl();
        if (string2 == null) {
            string2 = "";
        }
        String url = string2;
        StringBuilder urlBuilder = new StringBuilder(url);
        String resizePart = null;
        if (imgFormatInfo.getWidth() > 0 && imgFormatInfo.getHeight() > 0) {
            resizePart = "/resize,w_" + imgFormatInfo.getWidth() + ",h_" + imgFormatInfo.getHeight();
        }
        this.handleUrlForOss(urlBuilder, resizePart, "/format,webp");
        String string3 = urlBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"urlBuilder.toString()");
        return string3;
    }

    private final String handleForOrigin(ImgFormatInfo imgFormatInfo) {
        String string2 = imgFormatInfo.getOriginUrl();
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder urlBuilder = new StringBuilder(string2);
        CharSequence charSequence = urlBuilder;
        String string3 = HEIF_MATCH_RULE;
        boolean bl = false;
        string3 = new Regex(string3);
        String string4 = "";
        boolean bl2 = false;
        string3.replace(charSequence, string4);
        try {
            int index = urlBuilder.indexOf("?x-oss-process=image");
            if (index >= 0) {
                urlBuilder.delete(index, urlBuilder.length());
            }
        }
        catch (Exception ex) {
            MLog.error((Object)TAG, "handleForOrigin error", ex, new Object[0]);
        }
        String string5 = urlBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"urlBuilder.toString()");
        return string5;
    }

    private final String handleForResize(ImgFormatInfo imgFormatInfo) {
        String string2 = imgFormatInfo.getOriginUrl();
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder urlBuilder = new StringBuilder(string2);
        String resizePart = null;
        if (imgFormatInfo.getWidth() > 0 && imgFormatInfo.getHeight() > 0) {
            resizePart = "/resize,w_" + imgFormatInfo.getWidth() + ",h_" + imgFormatInfo.getHeight();
        }
        this.handleUrlForOss(urlBuilder, resizePart, null);
        CharSequence charSequence = urlBuilder;
        String string3 = "/format,webp";
        boolean bl = false;
        string3 = new Regex(string3);
        String string4 = "";
        boolean bl2 = false;
        string3.replace(charSequence, string4);
        String string5 = urlBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"urlBuilder.toString()");
        return string5;
    }

    public final boolean isHeifSupport(@NotNull ImgFormatInfo imgFormatInfo) {
        Intrinsics.checkParameterIsNotNull((Object)imgFormatInfo, (String)"imgFormatInfo");
        if (TextUtils.isEmpty((CharSequence)imgFormatInfo.getOriginUrl())) {
            return false;
        }
        try {
            Uri originUri;
            Uri uri = originUri = Uri.parse((String)imgFormatInfo.getOriginUrl());
            Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"originUri");
            List pathList = uri.getPathSegments();
            if (pathList == null || pathList.isEmpty()) {
                return false;
            }
            if (!pathList.contains(HEIF_SEGMENT)) {
                return false;
            }
            String heifVersion = (String)pathList.get(pathList.indexOf(HEIF_SEGMENT) + 1);
            if (Intrinsics.areEqual((Object)heifVersion, (Object)HEIF_VERSION) ^ true) {
                return false;
            }
            List<Integer> sizeList = this.getHEIFSupportSizeList(originUri);
            if (sizeList.isEmpty()) {
                return false;
            }
            int wantSize = imgFormatInfo.getMaxSize();
            Iterable $this$forEach$iv = sizeList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                int n = it - wantSize;
                boolean bl2 = false;
                if (Math.abs(n) > 10) continue;
                return true;
            }
        }
        catch (Exception ex) {
            MLog.error((Object)TAG, "isHeifSupport error", ex, new Object[0]);
        }
        return false;
    }

    private final String removeOssParam(String url) {
        if (StringsKt.startsWith$default((String)url, (String)"null", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)url, (String)"?x-oss-process=image", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)url, (String)"/?x-oss-process=image", (boolean)false, (int)2, null)) {
            return "";
        }
        int index = StringsKt.indexOf$default((CharSequence)url, (String)"?x-oss-process=image", (int)0, (boolean)false, (int)6, null);
        if (index > 0) {
            String string2 = url;
            int n = 0;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, index);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            return string4;
        }
        return url;
    }

    private final String removeDuplicatedOssParam(String url) {
        int startIndex;
        String newUrl = url;
        int lastIndex = StringsKt.lastIndexOf$default((CharSequence)url, (String)"?x-oss-process=image", (int)0, (boolean)false, (int)6, null);
        if (lastIndex > 0 && (startIndex = StringsKt.indexOf$default((CharSequence)url, (String)"?x-oss-process=image", (int)0, (boolean)false, (int)6, null)) != lastIndex && startIndex > 0) {
            String string2 = url;
            int n = 0;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(lastIndex);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            String endOssString = string4;
            string2 = url;
            n = 0;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            String string5 = string2;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(n, startIndex);
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string7 = string6;
            newUrl = stringBuilder.append(string7).append(endOssString).toString();
        }
        return newUrl;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> getHEIFSupportSizeList(Uri uri) {
        void $this$mapTo$iv$iv;
        String sizesString;
        if (uri == null) {
            return CollectionsKt.emptyList();
        }
        if (uri.getPathSegments() == null || uri.getPathSegments().isEmpty()) {
            return CollectionsKt.emptyList();
        }
        int heifIndex = uri.getPathSegments().indexOf(HEIF_SEGMENT);
        if (heifIndex == -1) {
            return CollectionsKt.emptyList();
        }
        String string2 = sizesString = (String)uri.getPathSegments().get(heifIndex + 2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"sizesString");
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)string2, (String[])new String[]{HEIF_SIZE_DIVIDER}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string3 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var13_13 = it;
            boolean bl2 = false;
            Integer n = Integer.parseInt((String)var13_13);
            collection.add(n);
        }
        return (List)destination$iv$iv;
    }

    private ImageFormatTransformer() {
    }

    static {
        ImageFormatTransformer imageFormatTransformer;
        INSTANCE = imageFormatTransformer = new ImageFormatTransformer();
    }
}

