/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.imageloader;

import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import com.bumptech.glide.load.DecodeFormat;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.ImageUtil;
import com.yy.base.imageloader.transform.YYBitmapTransformation;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import java.util.List;

public abstract class BaseImageData {
    public static final int INVALID_SIZE = -1;
    public String originUrl;
    public String url;
    public Drawable placeholderDrawable;
    public Drawable errorDrawable;
    public int placeholderId = -1;
    public int errorId = -1;
    public boolean isOverrideSize = false;
    public boolean useOriginalSize = false;
    public int width = -1;
    public int height = -1;
    public boolean skipMemCache = false;
    public boolean skipDiskCache = false;
    public YYBitmapTransformation[] transformations;
    public DecodeFormat decodeFormat = DecodeFormat.PREFER_RGB_565;
    public Object originThumbnail;
    public Object thumbnail;
    public int thumbnailW = -1;
    public int thumbnailH = -1;
    public String backUrl;
    public float sizeMultiplier = -1.0f;
    public boolean asGif = false;
    public boolean crossFade = false;
    public boolean enableGif = true;
    public int round = 0;
    public boolean circle = false;
    public int retryTime = 0;
    public boolean useBackup = false;
    public boolean useHeif = false;
    public boolean canRecycle = true;
    public boolean needCheckUrl = true;
    public boolean useCacheForOrigin = false;
    public int loadId;
    public List<ImageLoader.IMonitor> monitors;
    public boolean loadSuccess = false;

    public void reset() {
        this.url = null;
        this.originUrl = null;
        this.decodeFormat = DecodeFormat.PREFER_RGB_565;
        this.canRecycle = true;
        this.placeholderId = -1;
        this.errorId = -1;
        this.width = -1;
        this.height = -1;
        this.useOriginalSize = false;
        this.placeholderDrawable = null;
        this.errorDrawable = null;
        this.transformations = null;
        this.skipMemCache = false;
        this.skipDiskCache = false;
        this.loadSuccess = false;
        this.backUrl = null;
        this.thumbnail = null;
        this.sizeMultiplier = -1.0f;
        this.asGif = false;
        this.crossFade = false;
        this.monitors = null;
        this.isOverrideSize = false;
        this.loadId = 0;
        this.needCheckUrl = true;
    }

    public Object getLoadObj() {
        return this.url;
    }

    public boolean isValid() {
        return StringUtils.isNotEmpty(this.url);
    }

    public static class Builder<T extends BaseImageData> {
        protected ImageView mView;
        protected T mData;

        Builder(ImageView imageView, String url) {
            this(imageView, url, -1);
        }

        Builder(ImageView imageView, String url, int placeholderId) {
            this.mView = imageView;
        }

        public Builder placeholder(int placeholder) {
            ((BaseImageData)this.mData).placeholderId = placeholder;
            return this;
        }

        public Builder error(int errorId) {
            ((BaseImageData)this.mData).errorId = errorId;
            return this;
        }

        public Builder placeholder(Drawable drawable) {
            ((BaseImageData)this.mData).placeholderDrawable = drawable;
            return this;
        }

        public Builder error(Drawable drawable) {
            ((BaseImageData)this.mData).errorDrawable = drawable;
            return this;
        }

        public Builder setOverride(boolean isOverride) {
            ((BaseImageData)this.mData).isOverrideSize = isOverride;
            return this;
        }

        public Builder setSize(int width, int height) {
            if (ImageUtil.isValidDimensions(width, height)) {
                ((BaseImageData)this.mData).width = width;
                ((BaseImageData)this.mData).height = height;
            } else if (RuntimeContext.sIsDebuggable) {
                MLog.info("ImageData", "setSize w and h must be > 0", new Object[0]);
            }
            return this;
        }

        public Builder useOriginalSize(boolean use) {
            ((BaseImageData)this.mData).useOriginalSize = use;
            return this;
        }

        public Builder setTransform(YYBitmapTransformation ... bitmapTransformations) {
            ((BaseImageData)this.mData).transformations = bitmapTransformations;
            return this;
        }

        public Builder skipMemCache(boolean skip) {
            ((BaseImageData)this.mData).skipMemCache = skip;
            return this;
        }

        public Builder skipDiskCache(boolean skip) {
            ((BaseImageData)this.mData).skipDiskCache = skip;
            return this;
        }

        public Builder setDecodeFormat(DecodeFormat decodeFormat) {
            ((BaseImageData)this.mData).decodeFormat = decodeFormat;
            return this;
        }

        public Builder thumbnail(Object thumbnail) {
            ((BaseImageData)this.mData).thumbnail = thumbnail;
            ((BaseImageData)this.mData).originThumbnail = thumbnail;
            return this;
        }

        public Builder setThumbnailSize(int width, int height) {
            if (ImageUtil.isValidDimensions(width, height)) {
                ((BaseImageData)this.mData).thumbnailW = width;
                ((BaseImageData)this.mData).thumbnailH = height;
            } else if (RuntimeContext.sIsDebuggable) {
                MLog.info("ImageData", "setThumbnailSize: w and h must be > 0", new Object[0]);
            }
            return this;
        }

        public Builder setSizeMultiplier(float sizeMultiplier) {
            ((BaseImageData)this.mData).sizeMultiplier = sizeMultiplier;
            return this;
        }

        public Builder asGif(boolean enable) {
            ((BaseImageData)this.mData).asGif = enable;
            return this;
        }

        public Builder setCrossFade(boolean crossFade) {
            ((BaseImageData)this.mData).crossFade = crossFade;
            return this;
        }

        public Builder useHeif(boolean useHeif) {
            ((BaseImageData)this.mData).useHeif = useHeif;
            return this;
        }

        public Builder setCircle(boolean circle) {
            ((BaseImageData)this.mData).circle = circle;
            return this;
        }

        public Builder enableGif(boolean enable) {
            ((BaseImageData)this.mData).enableGif = enable;
            return this;
        }

        public Builder setRound(int dp) {
            ((BaseImageData)this.mData).round = dp;
            return this;
        }

        public Builder useCacheForOrigin(boolean useCache) {
            ((BaseImageData)this.mData).useCacheForOrigin = useCache;
            return this;
        }

        public Builder setListener(ImageLoader.BaseLoadListener listener) {
            return this;
        }

        public void load() {
        }
    }
}

