/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.image.compress;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import com.yy.appbase.ablum_select.mulitablumselect.internal.entity.BasicMediaInfo;
import com.yy.base.env.RuntimeContext;
import com.yy.base.image.compress.Checker;
import com.yy.base.image.compress.CompressValueUtils;
import com.yy.base.image.compress.CompressionPredicate;
import com.yy.base.image.compress.Engine;
import com.yy.base.image.compress.InputStreamProvider;
import com.yy.base.image.compress.OnCompressListener;
import com.yy.base.image.compress.OnRenameListener;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SdkVersionUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class Luban
implements Handler.Callback {
    private static final String TAG = "Luban";
    private static final String DEFAULT_DISK_CACHE_DIR = "luban_disk_cache";
    private static final int MSG_COMPRESS_SUCCESS = 0;
    private static final int MSG_COMPRESS_START = 1;
    private static final int MSG_COMPRESS_ERROR = 2;
    private static final int MSG_PATCH_COMPRESS_FINISH = 3;
    private String mTargetDir;
    private boolean focusAlpha;
    private int mLeastCompressSize;
    private OnRenameListener mRenameListener;
    private OnCompressListener mCompressListener;
    private CompressionPredicate mCompressionPredicate;
    private List<InputStreamProvider> mStreamProviders;
    private CopyOnWriteArrayList<BasicMediaInfo> mPhotosInfo;
    private volatile int mCompressSize = 0;
    private Builder.ForceCompressFormat[] mForceCompressFormats;
    private int mCompressQuality = 80;
    private Handler mHandler;

    private Luban(Builder builder) {
        this.mTargetDir = builder.mTargetDir;
        this.mRenameListener = builder.mRenameListener;
        this.mStreamProviders = builder.mStreamProviders;
        this.mCompressListener = builder.mCompressListener;
        this.mLeastCompressSize = builder.mLeastCompressSize;
        this.mCompressionPredicate = builder.mCompressionPredicate;
        this.mForceCompressFormats = builder.mForceCompressFormats;
        this.mCompressQuality = builder.mCompressQuality;
        this.mHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
    }

    public static Builder with(Context context) {
        return new Builder(context);
    }

    private File getImageCacheFile(Context context, String suffix) {
        if (TextUtils.isEmpty((CharSequence)this.mTargetDir)) {
            this.mTargetDir = this.getImageCacheDir(context).getAbsolutePath();
        }
        String cacheBuilder = this.mTargetDir + "/" + System.currentTimeMillis() + (int)(Math.random() * 1000.0) + (TextUtils.isEmpty((CharSequence)suffix) || this.isHeifExtSuffix(suffix) ? ".jpg" : suffix);
        return new File(cacheBuilder);
    }

    private File getCopyImageTempFile(Context context, String suffix) {
        if (TextUtils.isEmpty((CharSequence)this.mTargetDir)) {
            this.mTargetDir = this.getImageCacheDir(context).getAbsolutePath();
        }
        String cacheBuilder = this.mTargetDir + "/" + System.currentTimeMillis() + (int)(Math.random() * 1000.0) + (TextUtils.isEmpty((CharSequence)suffix) || this.isHeifExtSuffix(suffix) ? "_copy.jpg" : "_copy" + suffix);
        return new File(cacheBuilder);
    }

    private boolean isHeifExtSuffix(String suffix) {
        for (String ext : Builder.ForceCompressFormat.HEIF.extendNames) {
            if (!StringUtils.equalsIgnoreCase(suffix, "." + ext)) continue;
            return true;
        }
        return false;
    }

    private File getImageCustomFile(Context context, String filename) {
        if (TextUtils.isEmpty((CharSequence)this.mTargetDir)) {
            this.mTargetDir = this.getImageCacheDir(context).getAbsolutePath();
        }
        String cacheBuilder = this.mTargetDir + "/" + filename;
        return new File(cacheBuilder);
    }

    private File getImageCacheDir(Context context) {
        return Luban.getImageCacheDir(context, DEFAULT_DISK_CACHE_DIR);
    }

    private static File getImageCacheDir(Context context, String cacheName) {
        File cacheDir = new File(FileStorageUtils.getInstance().getExternalCacheRootDir());
        if (cacheDir != null) {
            File result = new File(cacheDir, cacheName);
            if (!(result.mkdirs() || result.exists() && result.isDirectory())) {
                return null;
            }
            return result;
        }
        if (Log.isLoggable((String)TAG, (int)6)) {
            Log.e((String)TAG, (String)"default disk cache dir is null");
        }
        return null;
    }

    private void launch(final Context context) {
        if (this.mStreamProviders == null || this.mStreamProviders.size() == 0 && this.mCompressListener != null) {
            this.mCompressListener.onError(new NullPointerException("image file cannot be null"));
        }
        if (this.mPhotosInfo == null) {
            this.mPhotosInfo = new CopyOnWriteArrayList();
        } else {
            this.mPhotosInfo.clear();
        }
        Iterator<InputStreamProvider> iterator = this.mStreamProviders.iterator();
        int size = this.mStreamProviders.size();
        while (iterator.hasNext()) {
            final InputStreamProvider path = iterator.next();
            BasicMediaInfo basicMediaInfo = new BasicMediaInfo();
            basicMediaInfo.path = path.getPath();
            this.mPhotosInfo.add(basicMediaInfo);
            this.mCompressSize = 0;
            YYTaskExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Luban.this.mHandler.sendMessage(Luban.this.mHandler.obtainMessage(1));
                        File result = Luban.this.compress(context, path);
                        Luban.this.mHandler.sendMessage(Luban.this.mHandler.obtainMessage(0, (Object)result));
                        Luban.this.mCompressSize++;
                        if (Luban.this.checkAllCompressFinish() && Luban.this.mCompressSize == Luban.this.mPhotosInfo.size()) {
                            Luban.this.mHandler.sendMessage(Luban.this.mHandler.obtainMessage(3));
                        }
                    }
                    catch (Exception e) {
                        Luban.this.mHandler.sendMessage(Luban.this.mHandler.obtainMessage(2, (Object)e));
                    }
                }
            });
            iterator.remove();
        }
    }

    private boolean checkAllCompressFinish() {
        for (int i = 0; i < this.mPhotosInfo.size(); ++i) {
            if (!TextUtils.isEmpty((CharSequence)this.mPhotosInfo.get((int)i).compressPath)) continue;
            return false;
        }
        return true;
    }

    private File get(InputStreamProvider input, Context context) throws IOException {
        return new Engine(input, this.getImageCacheFile(context, Checker.SINGLE.extSuffix(input)), this.focusAlpha, this.mCompressQuality).compress();
    }

    private List<File> get(Context context) throws IOException {
        ArrayList<File> results = new ArrayList<File>();
        Iterator<InputStreamProvider> iterator = this.mStreamProviders.iterator();
        while (iterator.hasNext()) {
            results.add(this.compress(context, iterator.next()));
            iterator.remove();
        }
        return results;
    }

    private File compress(Context context, InputStreamProvider path) throws IOException {
        File result;
        int quality;
        File outFile = this.getImageCacheFile(context, Checker.SINGLE.extSuffix(path));
        if (!outFile.exists()) {
            outFile.createNewFile();
        }
        if (SdkVersionUtils.hasScopedStorage() && path.getUri() != null && YYFileUtils.isContentUri(path.getUri().toString())) {
            File outCopyFile = this.getCopyImageTempFile(context, Checker.SINGLE.extSuffix(path));
            YYFileUtils.copyFileFromUri(path.getUri(), outCopyFile.getAbsolutePath());
            path.setPath(outCopyFile.getAbsolutePath());
        }
        BasicMediaInfo compressPhoto = null;
        for (BasicMediaInfo photo : this.mPhotosInfo) {
            if (!TextUtils.equals((CharSequence)path.getPath(), (CharSequence)photo.path)) continue;
            compressPhoto = photo;
            break;
        }
        if (compressPhoto == null) {
            compressPhoto = new BasicMediaInfo();
            this.mPhotosInfo.add(compressPhoto);
            compressPhoto.path = path.getPath();
        }
        if (this.mRenameListener != null) {
            String filename = this.mRenameListener.rename(path.getPath());
            outFile = this.getImageCustomFile(context, filename);
        }
        boolean needCompress = Checker.SINGLE.needCompress(this.mLeastCompressSize, path.getPath());
        boolean isForceCompressFormat = Checker.SINGLE.isForceCompressFormat(path.getPath(), this.mForceCompressFormats);
        int n = quality = needCompress ? this.mCompressQuality : 100;
        if (this.mCompressionPredicate != null) {
            if (this.mCompressionPredicate.apply(path.getPath()) && (needCompress || isForceCompressFormat)) {
                compressPhoto.compressPath = outFile.getAbsolutePath();
                result = new Engine(path, outFile, this.focusAlpha, quality).compress();
            } else {
                compressPhoto.compressPath = path.getPath();
                result = new File(path.getPath());
            }
        } else {
            result = needCompress || isForceCompressFormat ? new Engine(path, outFile, this.focusAlpha, quality).compress() : new File(path.getPath());
        }
        return result;
    }

    public boolean handleMessage(Message msg) {
        if (this.mCompressListener == null) {
            return false;
        }
        switch (msg.what) {
            case 1: {
                this.mCompressListener.onStart();
                break;
            }
            case 0: {
                this.mCompressListener.onSuccess((File)msg.obj);
                break;
            }
            case 2: {
                this.mCompressListener.onError((Throwable)msg.obj);
                break;
            }
            case 3: {
                this.mCompressListener.onPatchCompressFinish(this.mPhotosInfo);
                break;
            }
        }
        return false;
    }

    public static class Builder {
        private Context context;
        private String mTargetDir;
        private boolean focusAlpha;
        private int mLeastCompressSize = CompressValueUtils.compressIgnoreBy();
        private OnRenameListener mRenameListener;
        private OnCompressListener mCompressListener;
        private CompressionPredicate mCompressionPredicate;
        private List<InputStreamProvider> mStreamProviders;
        private ForceCompressFormat[] mForceCompressFormats = CompressValueUtils.forceCompressFormat();
        private int mCompressQuality = CompressValueUtils.commonCompressQuality();

        Builder(Context context) {
            this.context = context;
            this.mStreamProviders = new ArrayList<InputStreamProvider>();
        }

        private Luban build() {
            return new Luban(this);
        }

        public Builder compressQuality(int quality) {
            if (quality >= 0 && quality <= 100) {
                this.mCompressQuality = quality;
            }
            return this;
        }

        public Builder load(InputStreamProvider inputStreamProvider) {
            this.mStreamProviders.add(inputStreamProvider);
            return this;
        }

        public Builder load(final File file) {
            this.mStreamProviders.add(new InputStreamProvider(){

                @Override
                public InputStream open() throws IOException {
                    return new FileInputStream(file);
                }

                @Override
                public String getPath() {
                    return file.getAbsolutePath();
                }
            });
            return this;
        }

        public Builder load(final String string2) {
            this.mStreamProviders.add(new InputStreamProvider(){

                @Override
                public InputStream open() throws IOException {
                    return new FileInputStream(string2);
                }

                @Override
                public String getPath() {
                    return string2;
                }
            });
            return this;
        }

        public <T> Builder load(List<T> list) {
            for (T src : list) {
                if (src instanceof String) {
                    if (SdkVersionUtils.hasScopedStorage()) {
                        Uri uri = null;
                        uri = YYFileUtils.isContentUri((String)src) ? Uri.parse((String)((String)src)) : YYImageUtils.getImageContentUri(RuntimeContext.sApplicationContext, new File((String)src));
                        this.load(uri);
                        continue;
                    }
                    this.load((String)src);
                    continue;
                }
                if (src instanceof File) {
                    this.load((File)src);
                    continue;
                }
                if (src instanceof Uri) {
                    this.load((Uri)src);
                    continue;
                }
                throw new IllegalArgumentException("Incoming data type exception, it must be String, File, Uri or Bitmap");
            }
            return this;
        }

        public Builder load(final Uri uri) {
            this.mStreamProviders.add(new InputStreamProvider(){
                String path;

                @Override
                public InputStream open() throws IOException {
                    return context.getContentResolver().openInputStream(uri);
                }

                @Override
                public String getPath() {
                    if (StringUtils.isEmpty(this.path)) {
                        return uri.getPath();
                    }
                    return this.path;
                }

                @Override
                public Uri getUri() {
                    return uri;
                }

                @Override
                public void setPath(String path) {
                    this.path = path;
                }
            });
            return this;
        }

        public Builder putGear(int gear) {
            return this;
        }

        public Builder setRenameListener(OnRenameListener listener) {
            this.mRenameListener = listener;
            return this;
        }

        public Builder setCompressListener(OnCompressListener listener) {
            this.mCompressListener = listener;
            return this;
        }

        public Builder setTargetDir(String targetDir) {
            this.mTargetDir = targetDir;
            return this;
        }

        public Builder setFocusAlpha(boolean focusAlpha) {
            this.focusAlpha = focusAlpha;
            return this;
        }

        public Builder ignoreBy(int size) {
            this.mLeastCompressSize = size;
            return this;
        }

        public Builder filter(CompressionPredicate compressionPredicate) {
            this.mCompressionPredicate = compressionPredicate;
            return this;
        }

        public void launch() {
            this.build().launch(this.context);
        }

        public File get(final String path) throws IOException {
            return this.build().get(new InputStreamProvider(){

                @Override
                public InputStream open() throws IOException {
                    return new FileInputStream(path);
                }

                @Override
                public String getPath() {
                    return path;
                }
            }, this.context);
        }

        public List<File> get() throws IOException {
            return this.build().get(this.context);
        }

        public static enum ForceCompressFormat {
            HEIF("heif", "heic"),
            JPG("jpg", "jpeg"),
            PNG("png"),
            WEBP("webp");

            String[] extendNames;

            private ForceCompressFormat(String ... ext) {
                this.extendNames = ext;
            }
        }
    }
}

