/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.event.kvo.map;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.map.KvoHashMapHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class KvoHashMap<K, V>
implements Map<K, V> {
    private HashMap<K, V> mHashMap;
    public final KvoSource source;
    public final String name;

    public KvoHashMap(KvoSource source, String name) {
        this.source = source;
        this.name = name;
        this.mHashMap = new HashMap();
    }

    public KvoHashMap(KvoSource source, String name, int initialCapacity) {
        this.source = source;
        this.name = name;
        this.mHashMap = new HashMap(initialCapacity);
    }

    public KvoHashMap(KvoSource source, String name, int initialCapacity, float loadFactor) {
        this.source = source;
        this.name = name;
        this.mHashMap = new HashMap(initialCapacity, loadFactor);
    }

    @Override
    public int size() {
        return this.mHashMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mHashMap.isEmpty();
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        return this.mHashMap.containsKey(key);
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        return this.mHashMap.containsValue(value);
    }

    @Override
    @Nullable
    public V get(@Nullable Object key) {
        return this.mHashMap.get(key);
    }

    @Override
    @RequiresApi(api=24)
    @Nullable
    public V getOrDefault(@Nullable Object key, @Nullable V defaultValue) {
        return this.mHashMap.getOrDefault(key, defaultValue);
    }

    @Override
    @RequiresApi(api=24)
    public void forEach(@NonNull BiConsumer<? super K, ? super V> action) {
        this.mHashMap.forEach(action);
    }

    @Override
    public void clear() {
        int preSize = this.size();
        this.mHashMap.clear();
        KvoHashMapHelper.notifyRangeRemove(this.source, this.name, this, preSize);
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        V oldValue = this.mHashMap.put(key, value);
        if (oldValue == null) {
            KvoHashMapHelper.notifyInsert(this.source, this.name, this, 1);
        } else {
            KvoHashMapHelper.notifyRangeReplace(this.source, this.name, this, 1);
        }
        return oldValue;
    }

    @Override
    @Nullable
    public V remove(@Nullable Object key) {
        V value = this.mHashMap.remove(key);
        if (value != null) {
            KvoHashMapHelper.notifyRangeRemove(this.source, this.name, this, 1);
        }
        return value;
    }

    @Override
    @RequiresApi(api=24)
    public boolean remove(@Nullable Object key, @Nullable Object value) {
        boolean success = this.mHashMap.remove(key, value);
        if (success) {
            KvoHashMapHelper.notifyRangeRemove(this.source, this.name, this, 1);
        }
        return success;
    }

    @Override
    @RequiresApi(api=24)
    @Nullable
    public V replace(K key, V value) {
        V oldValue = this.mHashMap.replace(key, value);
        if (oldValue != null) {
            KvoHashMapHelper.notifyRangeReplace(this.source, this.name, this, 1);
        }
        return oldValue;
    }

    @Override
    @RequiresApi(api=24)
    public boolean replace(K key, @Nullable V oldValue, V newValue) {
        boolean success = this.mHashMap.replace(key, oldValue, newValue);
        if (success) {
            KvoHashMapHelper.notifyRangeReplace(this.source, this.name, this, 1);
        }
        return success;
    }

    @Override
    @RequiresApi(api=24)
    @Nullable
    public V merge(K key, @NonNull V value, @NonNull BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        V oldValue = this.mHashMap.get(key);
        if (oldValue != null) {
            V newValue = remappingFunction.apply(oldValue, value);
            if (newValue == null) {
                this.remove(key);
            } else {
                this.put(key, newValue);
            }
            return newValue;
        }
        if (value != null) {
            this.put(key, value);
        }
        return value;
    }

    @Override
    @NonNull
    public Set<K> keySet() {
        return this.mHashMap.keySet();
    }

    @Override
    @NonNull
    public Collection<V> values() {
        return this.mHashMap.values();
    }

    @Override
    @NonNull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.mHashMap.entrySet();
    }

    @Override
    public void putAll(@NonNull Map<? extends K, ? extends V> m) {
    }

    @Override
    public void replaceAll(@NonNull BiFunction<? super K, ? super V, ? extends V> function) {
    }

    @Override
    @RequiresApi(api=24)
    @Nullable
    public V putIfAbsent(K key, V value) {
        boolean contains = this.containsKey(key);
        V oldValue = this.mHashMap.putIfAbsent(key, value);
        if (oldValue != null) {
            KvoHashMapHelper.notifyRangeReplace(this.source, this.name, this, 1);
        } else {
            KvoHashMapHelper.notifyInsert(this.source, this.name, this, 1);
        }
        return oldValue;
    }

    @Override
    @Nullable
    public V computeIfAbsent(K key, @NonNull Function<? super K, ? extends V> mappingFunction) {
        return null;
    }

    @Override
    @Nullable
    public V computeIfPresent(K key, @NonNull BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return null;
    }

    @Override
    @Nullable
    public V compute(K key, @NonNull BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return null;
    }
}

