/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.event.kvo.helper;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoSource;
import java.util.HashMap;
import java.util.Map;

public class KvoBinder {
    private final Object mTarget;
    private final HashMap<String, KvoSource> mKvoSources = new HashMap();

    public KvoBinder(Object target) {
        this.mTarget = target;
    }

    public boolean singleBindSourceTo(@Nullable KvoSource source) {
        if (source == null) {
            return false;
        }
        return this.singleBindSourceTo(source.getClass().getName(), source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean singleBindSourceTo(@NonNull String key, @Nullable KvoSource source) {
        if (source == null) {
            return false;
        }
        KvoBinder kvoBinder = this;
        synchronized (kvoBinder) {
            KvoSource oldSource = this.mKvoSources.get(key);
            if (oldSource == source) {
                return false;
            }
            if (oldSource != null) {
                Kvo.autoUnbindingFrom(oldSource, this.mTarget);
            }
            Kvo.autoBindingTo(source, this.mTarget);
            this.mKvoSources.put(key, source);
            return true;
        }
    }

    public boolean singleBindSourceWithFlag(@Nullable KvoSource source, int flag) {
        if (source == null) {
            return false;
        }
        return this.singleBindSourceWithFlag(source.getClass().getName() + "_" + flag, source, flag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean singleBindSourceWithFlag(@NonNull String key, @Nullable KvoSource source, int flag) {
        if (source == null) {
            return false;
        }
        KvoBinder kvoBinder = this;
        synchronized (kvoBinder) {
            KvoSource oldSource = this.mKvoSources.get(key);
            if (oldSource == source) {
                return false;
            }
            if (oldSource != null) {
                Kvo.autoUnbindingFrom(oldSource, this.mTarget, flag);
            }
            Kvo.autoBindingTo(source, this.mTarget, flag);
            this.mKvoSources.put(key, source);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearKvoConnectionWithFlag(@Nullable KvoSource source, int flag) {
        if (source == null) {
            return;
        }
        KvoBinder kvoBinder = this;
        synchronized (kvoBinder) {
            Kvo.autoUnbindingFrom(source, this.mTarget, flag);
            this.mKvoSources.remove(source.getClass().getName() + "_" + flag);
        }
    }

    public synchronized void clearKvoConnection(String key) {
        KvoSource source = this.mKvoSources.remove(key);
        if (source != null) {
            Kvo.autoUnbindingFrom(source, this.mTarget);
        }
    }

    public synchronized void clearAllKvoConnections() {
        if (this.mKvoSources.size() <= 0) {
            return;
        }
        for (Map.Entry<String, KvoSource> entry : this.mKvoSources.entrySet()) {
            KvoSource value = entry.getValue();
            if (value == null) continue;
            Kvo.autoUnbindingFrom(value, this.mTarget);
        }
        this.mKvoSources.clear();
    }
}

