/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.event.kvo;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.base.event.core.EventAction;
import com.yy.base.event.core.EventIntent;
import com.yy.base.event.core.EventSender;
import com.yy.base.event.kvo.KvoSource;

public class KvoEventIntent
extends EventIntent {
    private static final String OLD_VALUE_KEY = "kvo_old_value";
    private static final String NEW_VALUE_KEY = "kvo_new_value";
    private static final String FROM_KEY = "kvo_from";

    public static KvoEventIntent build(KvoSource source, String name) {
        return KvoEventIntent.build(source, name, false);
    }

    public static KvoEventIntent build(KvoSource source, String name, boolean isStickyNotify) {
        EventSender eventSender = new EventSender(source);
        EventAction eventAction = source.declaredKvoField((String)name).eventAction;
        KvoEventIntent kvoEventIntent = new KvoEventIntent(eventSender, eventAction, isStickyNotify);
        kvoEventIntent.setKvoSource(source);
        return kvoEventIntent;
    }

    public KvoEventIntent(EventSender sender, EventAction eventAction, boolean isStickyNotify) {
        super(sender, eventAction, isStickyNotify);
    }

    public void setKvoSource(KvoSource kvoSource) {
        this.putArg(FROM_KEY, kvoSource);
    }

    public void setOldValue(Object oldValue) {
        this.putArg(OLD_VALUE_KEY, oldValue);
    }

    public void setNewValue(Object newValue) {
        this.putArg(NEW_VALUE_KEY, newValue);
    }

    @NonNull
    public <T extends KvoSource> T source() {
        return (T)((KvoSource)this.getArgWithKey(FROM_KEY));
    }

    @Nullable
    public <T> T newValue() {
        return this.getArgWithKey(NEW_VALUE_KEY);
    }

    @Nullable
    public <T> T oldValue() {
        return this.getArgWithKey(OLD_VALUE_KEY);
    }

    @NonNull
    public <T> T caseNewValue(@NonNull T def) {
        T value = this.newValue();
        return value == null ? def : value;
    }
}

