/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.event.fw;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.base.event.core.EventAction;
import com.yy.base.event.core.EventDispatcher;
import com.yy.base.event.core.EventIntent;
import com.yy.base.event.core.EventReceiver;
import com.yy.base.event.core.EventSender;
import com.yy.base.event.core.helper.DefaultEventThreadWrapper;
import com.yy.base.event.core.helper.EventHelper;
import com.yy.base.event.fw.FWEventActionKey;
import com.yy.base.event.fw.FWEventAnnotation;
import com.yy.base.logger.MLog;
import com.yy.base.thread.ThreadBus;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class FWEvent {
    public static final String FWEVENT_LOG_TAG = "FWEvent";
    private static final EventDispatcher sFWEventDispatcher = new EventDispatcher();
    private static ConcurrentHashMap<Class<?>, ArrayList<FWMethodNode>> receiverClassMethodsCache = new ConcurrentHashMap();
    private static ConcurrentHashMap<FWEventActionKey, EventAction> fwEventActionCache = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static ArrayList<FWMethodNode> getFWEventMethods(@NonNull Object dst) {
        Class<?> dstClass = dst.getClass();
        ArrayList<FWMethodNode> methodList = receiverClassMethodsCache.get(dstClass);
        if (methodList != null) {
            return methodList;
        }
        Class<?> clazz = dstClass;
        synchronized (clazz) {
            methodList = receiverClassMethodsCache.get(dstClass);
            if (methodList != null) {
                return methodList;
            }
            methodList = FWEvent.getDstClassFWMethodNodes(dstClass);
            receiverClassMethodsCache.put(dstClass, methodList);
        }
        return methodList;
    }

    @NonNull
    private static ArrayList<FWMethodNode> getDstClassFWMethodNodes(@NonNull Class<?> dstClass) {
        ArrayList<FWMethodNode> methodList = new ArrayList<FWMethodNode>();
        List<Method> methods = EventHelper.getExcludeSystemMethods(dstClass);
        HashMap<FWEventActionKey, Method> nameMethodMap = new HashMap<FWEventActionKey, Method>();
        for (Method method : methods) {
            Method preMethod;
            FWEventAnnotation annotation = method.getAnnotation(FWEventAnnotation.class);
            if (annotation == null || (preMethod = (Method)nameMethodMap.get((Object)annotation.name())) != null && preMethod.getName().equals(method.getName())) continue;
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            FWMethodNode node = new FWMethodNode();
            node.method = method;
            node.methodAnnotation = annotation;
            methodList.add(node);
            nameMethodMap.put(annotation.name(), method);
        }
        return methodList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static EventAction fwEventAction(@NonNull FWEventActionKey fwEventActionKey) {
        EventAction fwEventAction = fwEventActionCache.get((Object)fwEventActionKey);
        if (fwEventAction != null) {
            return fwEventAction;
        }
        FWEventActionKey fWEventActionKey = fwEventActionKey;
        synchronized (fWEventActionKey) {
            fwEventAction = fwEventActionCache.get((Object)fwEventActionKey);
            if (fwEventAction != null) {
                return fwEventAction;
            }
            fwEventAction = new EventAction((Object)fwEventActionKey, fwEventActionKey.sticky ? 1 : 0);
            fwEventActionCache.put(fwEventActionKey, fwEventAction);
        }
        return fwEventAction;
    }

    public static void autoBindingEvent(@NonNull Object target) {
        ArrayList<FWMethodNode> nodes = FWEvent.getFWEventMethods(target);
        for (FWMethodNode node : nodes) {
            sFWEventDispatcher.addBinding(FWEvent.fwEventAction(node.methodAnnotation.name()), FWEvent.buildFWEventReceiver(node.methodAnnotation, target, node.method));
        }
    }

    public static void autoRemoveEvent(@NonNull Object target) {
        ArrayList<FWMethodNode> nodes = FWEvent.getFWEventMethods(target);
        for (FWMethodNode node : nodes) {
            sFWEventDispatcher.removeBinding(FWEvent.fwEventAction(node.methodAnnotation.name()), FWEvent.buildFWEventReceiver(node.methodAnnotation, target, node.method));
        }
    }

    public static void bindMethodToEvent(@NonNull Object target, @NonNull String methodName) {
        try {
            Method method = target.getClass().getMethod(methodName, EventIntent.class);
            FWEvent.bindEventTo(target, method);
        }
        catch (NoSuchMethodException | SecurityException e) {
            MLog.error((Object)FWEVENT_LOG_TAG, "bind event failed no method : " + methodName + " in " + target.toString(), new Object[0]);
        }
    }

    public static void bindEventTo(@NonNull Object target, @NonNull Method method) {
        FWEventAnnotation annotation = method.getAnnotation(FWEventAnnotation.class);
        if (annotation != null) {
            sFWEventDispatcher.addBinding(FWEvent.fwEventAction(annotation.name()), FWEvent.buildFWEventReceiver(annotation, target, method));
        }
    }

    public static void removeMethodFromEvent(@NonNull Object target, @NonNull String methodName) {
        try {
            Method method = target.getClass().getMethod(methodName, EventIntent.class);
            FWEvent.removeEventFrom(target, method);
        }
        catch (NoSuchMethodException | SecurityException e) {
            MLog.error((Object)FWEVENT_LOG_TAG, "remove event failed no method : " + methodName + " in " + target.toString(), new Object[0]);
        }
    }

    public static void removeEventFrom(@NonNull Object target, @NonNull Method method) {
        FWEventAnnotation annotation = method.getAnnotation(FWEventAnnotation.class);
        if (annotation != null) {
            sFWEventDispatcher.removeBinding(FWEvent.fwEventAction(annotation.name()), FWEvent.buildFWEventReceiver(annotation, target, method));
        }
    }

    public static void sendEventAsync(int thread, @Nullable Object senderObj, @NonNull FWEventActionKey fwEventActionKey, Object ... args) {
        ThreadBus.post(thread, () -> FWEvent.sendEvent(senderObj, fwEventActionKey, args));
    }

    public static void sendEvent(@Nullable Object senderObj, @NonNull FWEventActionKey fwEventActionKey, Object ... args) {
        EventIntent eventIntent = FWEvent.buildFWEventIntent(senderObj, fwEventActionKey);
        eventIntent.addArgs(args);
        sFWEventDispatcher.notifyEvent(eventIntent);
    }

    private static EventReceiver buildFWEventReceiver(@NonNull FWEventAnnotation annotation, @NonNull Object target, @NonNull Method method) {
        return new EventReceiver(target, method, DefaultEventThreadWrapper.thread(annotation.thread()), annotation.priority(), annotation.flag());
    }

    private static EventIntent buildFWEventIntent(@Nullable Object senderObj, @NonNull FWEventActionKey fwEventActionKey) {
        EventSender eventSender = new EventSender(senderObj);
        EventAction fwEventAction = FWEvent.fwEventAction(fwEventActionKey);
        return new EventIntent(eventSender, fwEventAction, false);
    }

    private static class FWMethodNode {
        public Method method;
        public FWEventAnnotation methodAnnotation;

        private FWMethodNode() {
        }
    }
}

