/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.event.core.helper;

import androidx.annotation.NonNull;
import com.yy.base.logger.MLog;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class EventHelper {
    private static final String ANDROID_SYSTEM_PACKAGE_PREFIX = "android.";
    private static final String ANDROIDX_PACKAGE_PREFIX = "androidx.";
    private static final String JAVA_SYSTEM_PACKAGE_PREFIX = "java.";
    private static final String JAVAX_SYSTEM_PACKAGE_PREFIX = "javax.";
    private static final int NOT_SUPPORT_METHOD_MODIFIERS = 1288;
    private static final int NOT_SUPPORT_FIELD_MODIFIERS = 1288;

    public static List<Method> getExcludeSystemMethods(Class<?> clazz) {
        try {
            return EventHelper.getMethodRecursive(clazz);
        }
        catch (NoClassDefFoundError error) {
            Method[] methods;
            MLog.error((Object)"FrameWork_Event", "getExcludeSystemMethods error clazz : " + clazz.getName() + " exception : " + error.toString(), new Object[0]);
            ArrayList<Method> methodList = new ArrayList<Method>();
            for (Method method : methods = clazz.getDeclaredMethods()) {
                if (EventHelper.canMethodBeFiltered(method)) continue;
                methodList.add(method);
            }
            return methodList;
        }
    }

    private static boolean canMethodBeFiltered(Method method) {
        return (method.getModifiers() & 0x508) != 0 || method.isBridge() || method.isSynthetic();
    }

    private static List<Method> getMethodRecursive(@NonNull Class<?> clazz) {
        ArrayList<Method> methodList = new ArrayList<Method>();
        Class<?> cls = clazz;
        while (!EventHelper.canClassBeFiltered(cls)) {
            Method[] methods;
            for (Method method : methods = cls.getDeclaredMethods()) {
                if (EventHelper.canMethodBeFiltered(method)) continue;
                methodList.add(method);
            }
            cls = cls.getSuperclass();
        }
        return methodList;
    }

    private static boolean canClassBeFiltered(Class<?> clazz) {
        if (clazz == null) {
            return true;
        }
        String name = clazz.getName();
        return name.startsWith(ANDROID_SYSTEM_PACKAGE_PREFIX) || name.startsWith(JAVA_SYSTEM_PACKAGE_PREFIX) || name.startsWith(JAVAX_SYSTEM_PACKAGE_PREFIX) || name.startsWith(ANDROIDX_PACKAGE_PREFIX);
    }

    public static List<Field> getExcludeSystemFields(Class<?> clazz) {
        try {
            return EventHelper.getFieldRecursive(clazz);
        }
        catch (NoClassDefFoundError error) {
            Field[] fields;
            MLog.error((Object)"FrameWork_Event", "getExcludeSystemFields error clazz : " + clazz.getName() + " exception : " + error.toString(), new Object[0]);
            ArrayList<Field> fieldList = new ArrayList<Field>();
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (EventHelper.canFieldBeFiltered(field)) continue;
                fieldList.add(field);
            }
            return fieldList;
        }
    }

    private static boolean canFieldBeFiltered(Field field) {
        return (field.getModifiers() & 0x508) != 0 || field.isSynthetic();
    }

    private static List<Field> getFieldRecursive(Class<?> clazz) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        Class<?> cls = clazz;
        while (!EventHelper.canClassBeFiltered(cls)) {
            Field[] fields;
            for (Field field : fields = cls.getDeclaredFields()) {
                if (EventHelper.canFieldBeFiltered(field)) continue;
                fieldList.add(field);
            }
            cls = cls.getSuperclass();
        }
        return fieldList;
    }
}

