/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.event.core;

import com.yy.base.event.core.EventAction;
import com.yy.base.event.core.EventIntent;
import com.yy.base.event.core.EventReceiver;
import com.yy.base.logger.MLog;
import java.util.HashMap;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class EventReceiverList {
    public static final int DEFAULT_RECEIVER_COUNT_THRESHOLD = 60;
    protected final TreeSet<EventReceiver> mReceivers = new TreeSet<EventReceiver>(EventReceiver.sEventReceiverComparator);
    protected final EventAction mEventAction;
    private volatile EventIntent mLastStickyIntent;

    public EventReceiverList(EventAction eventAction) {
        this.mEventAction = eventAction;
    }

    public synchronized void add(EventReceiver eventReceiver) {
        boolean preExist;
        boolean bl = preExist = !this.mReceivers.add(eventReceiver);
        if (preExist) {
            MLog.warn("FrameWork_Event", "add event destination warning, destination already exist : " + eventReceiver.toString(), new Object[0]);
            return;
        }
        if (this.mEventAction.isSticky() && this.mLastStickyIntent != null) {
            this.invokeEventToReceiver(this.mLastStickyIntent, eventReceiver);
        }
        this.onAddBinding(eventReceiver);
        this.removeUnusedReceivers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeToReceivers(EventIntent eventIntent) {
        TreeSet<EventReceiver> copiedReceivers;
        EventReceiverList eventReceiverList = this;
        synchronized (eventReceiverList) {
            copiedReceivers = new TreeSet<EventReceiver>((SortedSet<EventReceiver>)this.mReceivers);
            if (this.mEventAction.isSticky()) {
                this.refreshStickyEventIntent(eventIntent);
            }
        }
        for (EventReceiver receiver : copiedReceivers) {
            this.invokeEventToReceiver(eventIntent, receiver);
            if (!eventIntent.haveDone()) continue;
            break;
        }
    }

    private void refreshStickyEventIntent(EventIntent eventIntent) {
        EventIntent stickyIntent = new EventIntent(eventIntent.eventSender(), this.mEventAction, true);
        stickyIntent.putBundle(eventIntent.eventBundle());
        this.mLastStickyIntent = stickyIntent;
    }

    public void invokeEventToReceiver(EventIntent eventIntent, EventReceiver receiver) {
        if (!receiver.invoke(eventIntent)) {
            this.remove(receiver);
        }
    }

    private void removeUnusedReceivers() {
        int size = this.size();
        if (size > 60) {
            MLog.warn("FrameWork_Event", "too many connections: " + size + " add to: " + this.mEventAction, new Object[0]);
            Iterator<EventReceiver> iterator = this.mReceivers.iterator();
            while (iterator.hasNext()) {
                EventReceiver receiver = iterator.next();
                if (receiver != null && receiver.isValid()) continue;
                iterator.remove();
            }
        }
    }

    public synchronized boolean remove(EventReceiver object) {
        return this.mReceivers.remove(object);
    }

    synchronized void onTrim(HashMap<EventAction, EventReceiverList> connections) {
        if (this.size() == 0) {
            connections.remove(this.mEventAction);
        }
    }

    public synchronized int size() {
        return this.mReceivers.size();
    }

    public EventIntent getLastStickyIntent() {
        return this.mLastStickyIntent;
    }

    protected void onAddBinding(EventReceiver receiver) {
    }
}

