/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.event.core;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.base.event.core.EventAction;
import com.yy.base.event.core.EventBundle;
import com.yy.base.event.core.EventSender;
import com.yy.base.utils.JFlagUtil;
import java.util.concurrent.atomic.AtomicInteger;

public class EventIntent {
    public static final int EVENT_INTENT_DONE_FLAG = 1;
    private final EventAction mEventAction;
    private final EventSender mSender;
    private final AtomicInteger mFlag;
    private final boolean mIsStickyNotify;
    private EventBundle mBundle = new EventBundle();

    public EventIntent(@Nullable EventSender sender, @NonNull EventAction eventAction, boolean isStickyNotify) {
        this.mSender = sender;
        this.mEventAction = eventAction;
        this.mFlag = new AtomicInteger(0);
        this.mIsStickyNotify = isStickyNotify;
    }

    @NonNull
    public EventAction eventAction() {
        return this.mEventAction;
    }

    @Nullable
    public EventSender eventSender() {
        return this.mSender;
    }

    @NonNull
    public EventBundle eventBundle() {
        return this.mBundle;
    }

    public boolean isStickyNotify() {
        return this.mIsStickyNotify;
    }

    @Nullable
    public <T> T getArgWithIndex(int index) {
        return this.mBundle.getArgWithIndex(index);
    }

    public void putBundle(@NonNull EventBundle eventBundle) {
        this.mBundle.putAll(eventBundle);
    }

    @Nullable
    public <T> T arg0() {
        return this.getArgWithIndex(0);
    }

    @Nullable
    public <T> T arg1() {
        return this.getArgWithIndex(1);
    }

    @Nullable
    public <T> T arg2() {
        return this.getArgWithIndex(2);
    }

    public void putArg(@NonNull String name, @Nullable Object arg) {
        this.mBundle.putArg(name, arg);
    }

    public <T> T getArgWithKey(@NonNull String key) {
        return this.mBundle.getArgWithKey(key);
    }

    public void addArgs(Object ... args) {
        this.mBundle.addArgs(args);
    }

    public void addFlag(int newFlag) {
        int nextFlag;
        int current;
        while (!this.mFlag.compareAndSet(current = this.mFlag.get(), nextFlag = current | newFlag)) {
        }
    }

    public int flag() {
        return this.mFlag.get();
    }

    public void done() {
        this.addFlag(1);
    }

    public boolean haveDone() {
        return JFlagUtil.isFlag(this.mFlag.get(), 1);
    }
}

