/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.env;

import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import com.yy.base.env.ConstDef;
import com.yy.base.env.IApplicationRoute;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.logger.MLog;
import com.yy.base.startup.ActivityStackManager;
import com.yy.base.sword.SwordHelper;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hago.xlog.KLogUtils;
import com.yy.hago.xlog.LogOptions;

public abstract class MyApplication
implements IApplicationRoute {
    protected static volatile boolean sCreateBeforeInited = false;
    protected static volatile boolean sCreateAfterInited = false;
    protected static volatile boolean sPhoneTypeInited = false;
    private static volatile boolean sLogInit = false;

    @Override
    public void onCreate(Application application) {
    }

    protected static void myAppBeforeCreate(Application application) {
        RuntimeContext.sApplicationContext = application;
        MyApplication.setDebuggable(application);
        RuntimeContext.sCrashTestMyAppRun = true;
        if (StringUtils.isEmpty(RuntimeContext.sPackageName)) {
            RuntimeContext.sPackageName = application.getPackageName();
        }
        if (StringUtils.isEmpty(RuntimeContext.sCurProcessName)) {
            RuntimeContext.sCurProcessName = MyApplication.getMyProcessName(application);
        }
        if (StringUtils.equals(RuntimeContext.sPackageName, RuntimeContext.sCurProcessName)) {
            RuntimeContext.sIsMainProcess = true;
        }
        if (RuntimeContext.sIsMainProcess) {
            if (SystemUtils.isShowEnvSetting() && SettingFlags.containKey("isDebugModeFromEnv")) {
                RuntimeContext.sIsDebuggable = SettingFlags.getBoolean("isDebugModeFromEnv", false);
            } else if (SettingFlags.containKey("isDebugMode")) {
                RuntimeContext.sIsDebuggable = SettingFlags.getBoolean("isDebugMode", false);
            }
            ActivityStackManager.getInstance().init(application);
            if (SystemUtils.isShowEnvSetting()) {
                SwordHelper.install((Application)RuntimeContext.sApplicationContext);
            }
        }
    }

    protected static void myAppAfterCreate(Application application) {
        NetworkUtils.init((Context)application);
        FileStorageUtils.getInstance().setAppContext((Context)application);
        if (RuntimeContext.sIsMainProcess) {
            MyApplication.initRuntimeFlags();
        }
        MyApplication.initLogging(SystemUtils.isShowEnvSetting());
        RuntimeContext.sCrashTestMyAppRunEnd = true;
    }

    public static void setDebuggable(Application application) {
        MyApplication.updateDebuggableFlag(application);
    }

    public static void initLogging() {
        MyApplication.initLogging(false);
    }

    public static void initLogging(boolean force) {
        if (sLogInit) {
            return;
        }
        if (RuntimeContext.isHagoPartySdk() && !force) {
            return;
        }
        sLogInit = true;
        Runnable command = new Runnable(){

            @Override
            public void run() {
                String logPath;
                String string2 = logPath = SystemUtils.isShowEnvSetting() ? FileStorageUtils.getInstance().getDirAndCreate(true, ConstDef.LOG_DIR).getAbsolutePath() : FileStorageUtils.getInstance().getDirAndCreate(true, ConstDef.LOG_DIR).getAbsolutePath();
                if (SettingFlags.hasInited() && SettingFlags.getBoolean("hasstorageper", true) && RuntimeContext.sApplicationContext != null) {
                    if (SystemUtils.isShowEnvSetting() && (StringUtils.isEmpty(RuntimeContext.sPackageName) || StringUtils.isEmpty(RuntimeContext.sCurProcessName))) {
                        KLogUtils.init(RuntimeContext.sApplicationContext, ConstDef.DEFAULT_PACKAGE_NAME, ConstDef.DEFAULT_PACKAGE_NAME, RuntimeContext.sIsDebuggable || SystemUtils.isCpPackage(), logPath);
                    } else {
                        KLogUtils.init(RuntimeContext.sApplicationContext, RuntimeContext.sPackageName, RuntimeContext.sCurProcessName, RuntimeContext.sIsDebuggable || SystemUtils.isCpPackage(), logPath);
                    }
                    MyApplication.updateLogLevel();
                } else if (SystemUtils.isShowEnvSetting()) {
                    KLogUtils.init(RuntimeContext.sApplicationContext, RuntimeContext.sPackageName, RuntimeContext.sCurProcessName, RuntimeContext.sIsDebuggable || SystemUtils.isCpPackage(), logPath);
                    MyApplication.updateLogLevel();
                }
            }
        };
        if (RuntimeContext.isLocalBuild() && SystemUtils.isShowEnvSetting()) {
            command.run();
        } else {
            YYTaskExecutor.execute(command);
        }
    }

    private static int getLogLevel() {
        int newLogLevel = SettingFlags.getIntValue("loglevel", !RuntimeContext.sPhoneSuperLow ? LogOptions.LEVEL_INFO : LogOptions.LEVEL_ERROR);
        return RuntimeContext.sIsDebuggable ? LogOptions.LEVEL_VERBOSE : newLogLevel;
    }

    public static void onPerConfigUpdated() {
        MyApplication.updateLogLevel();
    }

    public static void updateLogLevel() {
        MLog.updateLogLevel(MyApplication.getLogLevel());
    }

    private static void updateDebuggableFlag(Application application) {
        ApplicationInfo appInfo = application.getApplicationInfo();
        if (appInfo != null) {
            boolean flag;
            boolean bl = flag = (appInfo.flags & 2) > 0;
            if (flag != RuntimeContext.sIsDebuggable) {
                if (SystemUtils.isShowEnvSetting() && SettingFlags.containKey("isDebugModeFromEnv")) {
                    flag = SettingFlags.getBoolean("isDebugModeFromEnv", false);
                }
                RuntimeContext.sIsDebuggable = flag;
                SettingFlags.setBoolean("isDebugMode", RuntimeContext.sIsDebuggable);
                if (RuntimeContext.sIsDebuggable) {
                    MLog.updateLogLevel(LogOptions.LEVEL_VERBOSE);
                } else {
                    int newLogLevel = MyApplication.getLogLevel();
                    int logLevel = MLog.getLogLevel();
                    if (logLevel < newLogLevel) {
                        MLog.updateLogLevel(newLogLevel);
                    }
                }
            }
        }
    }

    public static String getMyProcessName(Application application) {
        return IApplicationRoute.getProcessNameFromProc(application);
    }

    private static void initRuntimeFlags() {
        RuntimeContext.initCrashedInLastRunFlag();
    }

    @Override
    public void onLowMemory(Application application) {
        if (RuntimeContext.sIsActivityStarted) {
            ImageLoader.clearMemory();
        }
    }

    @Override
    public void onTrimMemory(Application application, int level) {
        if (RuntimeContext.sIsActivityStarted) {
            ImageLoader.trimMemory(level);
        }
    }
}

