/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.env;

import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.os.Process;
import android.text.TextUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.utils.MD5Utils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemServiceUtils;
import dalvik.system.PathClassLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.List;

public interface IApplicationRoute {
    public void onCreate(Application var1);

    public void onLowMemory(Application var1);

    public void onTrimMemory(Application var1, int var2);

    public void attachBaseContext(Application var1);

    public String procName(Application var1);

    public static String getProcessNameFromProc(Application application) {
        if (StringUtils.isNotEmpty(RuntimeContext.sCurProcessName)) {
            return RuntimeContext.sCurProcessName;
        }
        try {
            File file = new File("/proc/" + Process.myPid() + "/cmdline");
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String processName = reader.readLine().trim();
            reader.close();
            RuntimeContext.sCurProcessName = processName;
            return processName;
        }
        catch (Exception e) {
            String processName;
            int myPid = Process.myPid();
            List runningApps = SystemServiceUtils.getActivityManager((Context)application).getRunningAppProcesses();
            if (runningApps != null) {
                for (ActivityManager.RunningAppProcessInfo procInfo : runningApps) {
                    if (procInfo.pid != myPid || !StringUtils.isNotEmpty(procInfo.processName)) continue;
                    RuntimeContext.sCurProcessName = procInfo.processName;
                    return procInfo.processName;
                }
            }
            if (StringUtils.isNotEmpty(processName = application.getProcessName())) {
                RuntimeContext.sCurProcessName = processName;
                return processName;
            }
            return "";
        }
    }

    public static String findNativeLibraryPath(Context context, String libraryName) {
        if (context == null) {
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)libraryName)) {
            return null;
        }
        PathClassLoader classLoader = (PathClassLoader)context.getClassLoader();
        return classLoader.findLibrary(libraryName);
    }

    public static String getLibraryNameMd5(String libraryName) {
        return MD5Utils.fileMd5(IApplicationRoute.findNativeLibraryPath(RuntimeContext.sApplicationContext, libraryName));
    }
}

