/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.cache;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.base.cache.JCache;
import com.yy.base.cache.kvo.JKvoCache;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.KvoSource;
import java.util.concurrent.ConcurrentHashMap;

public class JCacheContainer {
    private static final ConcurrentHashMap<Class<?>, JCache<?>> ALL_CACHES = new ConcurrentHashMap();

    @Nullable
    public static <T> JCache<T> cacheForClazz(@NonNull Class<T> clazz) {
        return ALL_CACHES.get(clazz);
    }

    @NonNull
    public static <T> JCache<T> buildCache(@NonNull Class<T> clazz, @NonNull JCache.CacheController<T> cacheController) {
        return JCacheContainer.buildCache(new JCacheBuilder<T>().cacheController(cacheController).clazz(clazz));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static <T> JCache<T> buildCache(@NonNull JCacheBuilder<T> builder) {
        JCache<Object> constCache = ALL_CACHES.get(builder.cacheClazz);
        if (constCache == null) {
            Class clazz = builder.cacheClazz;
            synchronized (clazz) {
                constCache = ALL_CACHES.get(builder.cacheClazz);
                if (constCache == null) {
                    constCache = KvoSource.class.isAssignableFrom(builder.cacheClazz) ? new JKvoCache(builder) : new JCache<T>(builder);
                    ALL_CACHES.put(builder.cacheClazz, constCache);
                }
            }
        } else if (RuntimeContext.sIsDebuggable) {
            throw new RuntimeException("class " + builder.cacheClazz + " already exist in JCache , don't build it again");
        }
        return constCache;
    }

    public static <T> void removeCache(@NonNull Class<T> cacheClazz) {
        JCache<?> cache = ALL_CACHES.remove(cacheClazz);
        if (cache != null) {
            cache.release();
        }
    }

    public static class JCacheBuilder<T> {
        private static final long DEFAULT_EXPIRE_TIME = 300000L;
        private static final int DEFAULT_HARD_MIN_SIZE = 64;
        @NonNull
        public Class<T> cacheClazz = null;
        @NonNull
        public JCache.CacheController<T> cacheController = null;
        public long expireTime = 300000L;
        public int minHardSize = 64;

        public JCacheBuilder<T> cacheController(@NonNull JCache.CacheController<T> cacheController) {
            this.cacheController = cacheController;
            return this;
        }

        public JCacheBuilder<T> clazz(@NonNull Class<T> cacheClazz) {
            this.cacheClazz = cacheClazz;
            return this;
        }

        public JCacheBuilder<T> expireTime(long expireTime) {
            this.expireTime = expireTime;
            return this;
        }

        public JCacheBuilder<T> minHardSize(int minHardSize) {
            this.minHardSize = minHardSize;
            return this;
        }
    }
}

