/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.bitmap;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.Log;
import androidx.annotation.Nullable;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPoolAdapter;
import com.bumptech.glide.load.resource.bitmap.BitmapResource;
import com.bumptech.glide.load.resource.bitmap.TransformationUtils;
import java.util.concurrent.locks.Lock;

final class DrawableToBitmapConverter {
    private static final String TAG = "DrawableToBitmap";
    private static final BitmapPool NO_RECYCLE_BITMAP_POOL = new BitmapPoolAdapter(){

        @Override
        public void put(Bitmap bitmap) {
        }
    };

    private DrawableToBitmapConverter() {
    }

    @Nullable
    static Resource<Bitmap> convert(BitmapPool bitmapPool, Drawable drawable2, int width, int height) {
        drawable2 = drawable2.getCurrent();
        Bitmap result = null;
        boolean isRecycleable = false;
        if (drawable2 instanceof BitmapDrawable) {
            result = ((BitmapDrawable)drawable2).getBitmap();
        } else if (!(drawable2 instanceof Animatable)) {
            result = DrawableToBitmapConverter.drawToBitmap(bitmapPool, drawable2, width, height);
            isRecycleable = true;
        }
        BitmapPool toUse = isRecycleable ? bitmapPool : NO_RECYCLE_BITMAP_POOL;
        return BitmapResource.obtain(result, toUse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Bitmap drawToBitmap(BitmapPool bitmapPool, Drawable drawable2, int width, int height) {
        if (width == Integer.MIN_VALUE && drawable2.getIntrinsicWidth() <= 0) {
            if (Log.isLoggable((String)TAG, (int)5)) {
                Log.w((String)TAG, (String)("Unable to draw " + drawable2 + " to Bitmap with Target.SIZE_ORIGINAL because the Drawable has no intrinsic width"));
            }
            return null;
        }
        if (height == Integer.MIN_VALUE && drawable2.getIntrinsicHeight() <= 0) {
            if (Log.isLoggable((String)TAG, (int)5)) {
                Log.w((String)TAG, (String)("Unable to draw " + drawable2 + " to Bitmap with Target.SIZE_ORIGINAL because the Drawable has no intrinsic height"));
            }
            return null;
        }
        int targetWidth = drawable2.getIntrinsicWidth() > 0 ? drawable2.getIntrinsicWidth() : width;
        int targetHeight = drawable2.getIntrinsicHeight() > 0 ? drawable2.getIntrinsicHeight() : height;
        Lock lock = TransformationUtils.getBitmapDrawableLock();
        lock.lock();
        Bitmap result = bitmapPool.get(targetWidth, targetHeight, Bitmap.Config.ARGB_8888);
        try {
            Canvas canvas = new Canvas(result);
            drawable2.setBounds(0, 0, targetWidth, targetHeight);
            drawable2.draw(canvas);
            canvas.setBitmap(null);
        }
        finally {
            lock.unlock();
        }
        return result;
    }
}

