/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.bitmap;

import com.bumptech.glide.load.Option;

public abstract class DownsampleStrategy {
    public static final DownsampleStrategy FIT_CENTER = new FitCenter();
    public static final DownsampleStrategy CENTER_OUTSIDE = new CenterOutside();
    public static final DownsampleStrategy AT_LEAST = new AtLeast();
    public static final DownsampleStrategy AT_MOST = new AtMost();
    public static final DownsampleStrategy CENTER_INSIDE = new CenterInside();
    public static final DownsampleStrategy NONE = new None();
    public static final DownsampleStrategy DEFAULT = CENTER_OUTSIDE;
    public static final Option<DownsampleStrategy> OPTION = Option.memory("com.bumptech.glide.load.resource.bitmap.Downsampler.DownsampleStrategy", DEFAULT);

    public abstract float getScaleFactor(int var1, int var2, int var3, int var4);

    public abstract SampleSizeRounding getSampleSizeRounding(int var1, int var2, int var3, int var4);

    public static enum SampleSizeRounding {
        MEMORY,
        QUALITY;

    }

    private static class CenterInside
    extends DownsampleStrategy {
        CenterInside() {
        }

        @Override
        public float getScaleFactor(int sourceWidth, int sourceHeight, int requestedWidth, int requestedHeight) {
            return Math.min(1.0f, FIT_CENTER.getScaleFactor(sourceWidth, sourceHeight, requestedWidth, requestedHeight));
        }

        @Override
        public SampleSizeRounding getSampleSizeRounding(int sourceWidth, int sourceHeight, int requestedWidth, int requestedHeight) {
            return SampleSizeRounding.QUALITY;
        }
    }

    private static class None
    extends DownsampleStrategy {
        None() {
        }

        @Override
        public float getScaleFactor(int sourceWidth, int sourceHeight, int requestedWidth, int requestedHeight) {
            return 1.0f;
        }

        @Override
        public SampleSizeRounding getSampleSizeRounding(int sourceWidth, int sourceHeight, int requestedWidth, int requestedHeight) {
            return SampleSizeRounding.QUALITY;
        }
    }

    private static class AtMost
    extends DownsampleStrategy {
        AtMost() {
        }

        @Override
        public float getScaleFactor(int sourceWidth, int sourceHeight, int requestedWidth, int requestedHeight) {
            int lesserOrEqualSampleSize;
            int maxIntegerFactor = (int)Math.ceil(Math.max((float)sourceHeight / (float)requestedHeight, (float)sourceWidth / (float)requestedWidth));
            int greaterOrEqualSampleSize = lesserOrEqualSampleSize << ((lesserOrEqualSampleSize = Math.max(1, Integer.highestOneBit(maxIntegerFactor))) < maxIntegerFactor ? 1 : 0);
            return 1.0f / (float)greaterOrEqualSampleSize;
        }

        @Override
        public SampleSizeRounding getSampleSizeRounding(int sourceWidth, int sourceHeight, int requestedWidth, int requestedHeight) {
            return SampleSizeRounding.MEMORY;
        }
    }

    private static class AtLeast
    extends DownsampleStrategy {
        AtLeast() {
        }

        @Override
        public float getScaleFactor(int sourceWidth, int sourceHeight, int requestedWidth, int requestedHeight) {
            int minIntegerFactor = Math.min(sourceHeight / requestedHeight, sourceWidth / requestedWidth);
            return minIntegerFactor == 0 ? 1.0f : 1.0f / (float)Integer.highestOneBit(minIntegerFactor);
        }

        @Override
        public SampleSizeRounding getSampleSizeRounding(int sourceWidth, int sourceHeight, int requestedWidth, int requestedHeight) {
            return SampleSizeRounding.QUALITY;
        }
    }

    private static class CenterOutside
    extends DownsampleStrategy {
        CenterOutside() {
        }

        @Override
        public float getScaleFactor(int sourceWidth, int sourceHeight, int requestedWidth, int requestedHeight) {
            float widthPercentage = (float)requestedWidth / (float)sourceWidth;
            float heightPercentage = (float)requestedHeight / (float)sourceHeight;
            return Math.max(widthPercentage, heightPercentage);
        }

        @Override
        public SampleSizeRounding getSampleSizeRounding(int sourceWidth, int sourceHeight, int requestedWidth, int requestedHeight) {
            return SampleSizeRounding.QUALITY;
        }
    }

    private static class FitCenter
    extends DownsampleStrategy {
        FitCenter() {
        }

        @Override
        public float getScaleFactor(int sourceWidth, int sourceHeight, int requestedWidth, int requestedHeight) {
            float widthPercentage = (float)requestedWidth / (float)sourceWidth;
            float heightPercentage = (float)requestedHeight / (float)sourceHeight;
            return Math.min(widthPercentage, heightPercentage);
        }

        @Override
        public SampleSizeRounding getSampleSizeRounding(int sourceWidth, int sourceHeight, int requestedWidth, int requestedHeight) {
            return SampleSizeRounding.QUALITY;
        }
    }
}

