/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.bitmap;

import android.graphics.Bitmap;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.load.EncodeStrategy;
import com.bumptech.glide.load.Option;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.ResourceEncoder;
import com.bumptech.glide.load.data.BufferedOutputStream;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import com.bumptech.glide.util.LogTime;
import com.bumptech.glide.util.Util;
import com.bumptech.glide.util.pool.GlideTrace;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BitmapEncoder
implements ResourceEncoder<Bitmap> {
    public static final Option<Integer> COMPRESSION_QUALITY = Option.memory("com.bumptech.glide.load.resource.bitmap.BitmapEncoder.CompressionQuality", 90);
    public static final Option<Bitmap.CompressFormat> COMPRESSION_FORMAT = Option.memory("com.bumptech.glide.load.resource.bitmap.BitmapEncoder.CompressionFormat");
    private static final String TAG = "BitmapEncoder";
    @Nullable
    private final ArrayPool arrayPool;

    public BitmapEncoder(@NonNull ArrayPool arrayPool) {
        this.arrayPool = arrayPool;
    }

    @Deprecated
    public BitmapEncoder() {
        this.arrayPool = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean encode(@NonNull Resource<Bitmap> resource, @NonNull File file, @NonNull Options options) {
        Bitmap bitmap = resource.get();
        if (bitmap == null) {
            MLog.error((Object)TAG, " BITMAP IS NULL", new Object[0]);
            return false;
        }
        if (!RuntimeContext.sIsDebuggable && bitmap.isRecycled()) {
            MLog.error((Object)TAG, " BITMAP IS RECYCLED", new Object[0]);
            return false;
        }
        Bitmap.CompressFormat format = this.getFormat(bitmap, options);
        GlideTrace.beginSectionFormat("encode: [%dx%d] %s", bitmap.getWidth(), bitmap.getHeight(), format);
        try {
            long start = LogTime.getLogTime();
            int quality = options.get(COMPRESSION_QUALITY);
            boolean success = false;
            OutputStream os = null;
            try {
                os = new FileOutputStream(file);
                if (this.arrayPool != null) {
                    os = new BufferedOutputStream(os, this.arrayPool);
                }
                bitmap.compress(format, quality, os);
                os.close();
                success = true;
            }
            catch (IOException e) {
                if (Log.isLoggable((String)TAG, (int)3)) {
                    Log.d((String)TAG, (String)"Failed to encode Bitmap", (Throwable)e);
                }
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)("Compressed with type: " + format + " of size " + Util.getBitmapByteSize(bitmap) + " in " + LogTime.getElapsedMillis(start) + ", options format: " + options.get(COMPRESSION_FORMAT) + ", hasAlpha: " + bitmap.hasAlpha()));
            }
            boolean bl = success;
            return bl;
        }
        finally {
            GlideTrace.endSection();
        }
    }

    private Bitmap.CompressFormat getFormat(Bitmap bitmap, Options options) {
        Bitmap.CompressFormat format = options.get(COMPRESSION_FORMAT);
        if (format != null) {
            return format;
        }
        if (bitmap.hasAlpha()) {
            return Bitmap.CompressFormat.PNG;
        }
        return Bitmap.CompressFormat.JPEG;
    }

    @Override
    @NonNull
    public EncodeStrategy getEncodeStrategy(@NonNull Options options) {
        return EncodeStrategy.TRANSFORMED;
    }
}

