/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.model;

import android.os.ParcelFileDescriptor;
import android.util.Log;
import androidx.annotation.NonNull;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.model.ModelLoader;
import com.bumptech.glide.load.model.ModelLoaderFactory;
import com.bumptech.glide.load.model.MultiModelLoaderFactory;
import com.bumptech.glide.signature.ObjectKey;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class FileLoader<Data>
implements ModelLoader<File, Data> {
    private static final String TAG = "FileLoader";
    private final FileOpener<Data> fileOpener;

    public FileLoader(FileOpener<Data> fileOpener) {
        this.fileOpener = fileOpener;
    }

    @Override
    public ModelLoader.LoadData<Data> buildLoadData(@NonNull File model, int width, int height, @NonNull Options options) {
        return new ModelLoader.LoadData<Data>(new ObjectKey(model), new FileFetcher<Data>(model, this.fileOpener));
    }

    @Override
    public boolean handles(@NonNull File model) {
        return true;
    }

    public static class FileDescriptorFactory
    extends Factory<ParcelFileDescriptor> {
        public FileDescriptorFactory() {
            super(new FileOpener<ParcelFileDescriptor>(){

                @Override
                public ParcelFileDescriptor open(File file) throws FileNotFoundException {
                    return ParcelFileDescriptor.open((File)file, (int)0x10000000);
                }

                @Override
                public void close(ParcelFileDescriptor parcelFileDescriptor) throws IOException {
                    parcelFileDescriptor.close();
                }

                @Override
                public Class<ParcelFileDescriptor> getDataClass() {
                    return ParcelFileDescriptor.class;
                }
            });
        }
    }

    public static class StreamFactory
    extends Factory<InputStream> {
        public StreamFactory() {
            super(new FileOpener<InputStream>(){

                @Override
                public InputStream open(File file) throws FileNotFoundException {
                    return new FileInputStream(file);
                }

                @Override
                public void close(InputStream inputStream) throws IOException {
                    inputStream.close();
                }

                @Override
                public Class<InputStream> getDataClass() {
                    return InputStream.class;
                }
            });
        }
    }

    public static class Factory<Data>
    implements ModelLoaderFactory<File, Data> {
        private final FileOpener<Data> opener;

        public Factory(FileOpener<Data> opener) {
            this.opener = opener;
        }

        @Override
        @NonNull
        public final ModelLoader<File, Data> build(@NonNull MultiModelLoaderFactory multiFactory) {
            return new FileLoader<Data>(this.opener);
        }

        @Override
        public final void teardown() {
        }
    }

    private static final class FileFetcher<Data>
    implements DataFetcher<Data> {
        private final File file;
        private final FileOpener<Data> opener;
        private Data data;

        FileFetcher(File file, FileOpener<Data> opener) {
            this.file = file;
            this.opener = opener;
        }

        @Override
        public void loadData(@NonNull Priority priority, @NonNull DataFetcher.DataCallback<? super Data> callback) {
            try {
                this.data = this.opener.open(this.file);
            }
            catch (FileNotFoundException e) {
                if (Log.isLoggable((String)FileLoader.TAG, (int)3)) {
                    Log.d((String)FileLoader.TAG, (String)"Failed to open file", (Throwable)e);
                }
                callback.onLoadFailed(e);
                return;
            }
            callback.onDataReady(this.data);
        }

        @Override
        public void cleanup() {
            if (this.data != null) {
                try {
                    this.opener.close(this.data);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void cancel() {
        }

        @Override
        @NonNull
        public Class<Data> getDataClass() {
            return this.opener.getDataClass();
        }

        @Override
        @NonNull
        public DataSource getDataSource() {
            return DataSource.LOCAL;
        }
    }

    public static interface FileOpener<Data> {
        public Data open(File var1) throws FileNotFoundException;

        public void close(Data var1) throws IOException;

        public Class<Data> getDataClass();
    }
}

