/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.core.util.Pools;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.engine.CallbackException;
import com.bumptech.glide.load.engine.DecodeJob;
import com.bumptech.glide.load.engine.EngineJobListener;
import com.bumptech.glide.load.engine.EngineResource;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.engine.PerformanceData;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.executor.GlideExecutor;
import com.bumptech.glide.request.ResourceCallback;
import com.bumptech.glide.util.Executors;
import com.bumptech.glide.util.Preconditions;
import com.bumptech.glide.util.pool.FactoryPools;
import com.bumptech.glide.util.pool.StateVerifier;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;

class EngineJob<R>
implements DecodeJob.Callback<R>,
FactoryPools.Poolable {
    private static final EngineResourceFactory DEFAULT_FACTORY = new EngineResourceFactory();
    final ResourceCallbacksAndExecutors cbs = new ResourceCallbacksAndExecutors();
    private final StateVerifier stateVerifier = StateVerifier.newInstance();
    private final Pools.Pool<EngineJob<?>> pool;
    private final EngineResourceFactory engineResourceFactory;
    private final EngineJobListener listener;
    private final GlideExecutor diskCacheExecutor;
    private final GlideExecutor sourceExecutor;
    private final GlideExecutor sourceUnlimitedExecutor;
    private final GlideExecutor animationExecutor;
    private final AtomicInteger pendingCallbacks = new AtomicInteger();
    private Key key;
    private boolean isCacheable;
    private boolean useUnlimitedSourceGeneratorPool;
    private boolean useAnimationPool;
    private boolean onlyRetrieveFromCache;
    private Resource<?> resource;
    private PerformanceData performanceData;
    DataSource dataSource;
    private boolean hasResource;
    GlideException exception;
    private boolean hasLoadFailed;
    EngineResource<?> engineResource;
    private DecodeJob<R> decodeJob;
    private volatile boolean isCancelled;

    EngineJob(GlideExecutor diskCacheExecutor, GlideExecutor sourceExecutor, GlideExecutor sourceUnlimitedExecutor, GlideExecutor animationExecutor, EngineJobListener listener, Pools.Pool<EngineJob<?>> pool) {
        this(diskCacheExecutor, sourceExecutor, sourceUnlimitedExecutor, animationExecutor, listener, pool, DEFAULT_FACTORY);
    }

    @VisibleForTesting
    EngineJob(GlideExecutor diskCacheExecutor, GlideExecutor sourceExecutor, GlideExecutor sourceUnlimitedExecutor, GlideExecutor animationExecutor, EngineJobListener listener, Pools.Pool<EngineJob<?>> pool, EngineResourceFactory engineResourceFactory) {
        this.diskCacheExecutor = diskCacheExecutor;
        this.sourceExecutor = sourceExecutor;
        this.sourceUnlimitedExecutor = sourceUnlimitedExecutor;
        this.animationExecutor = animationExecutor;
        this.listener = listener;
        this.pool = pool;
        this.engineResourceFactory = engineResourceFactory;
    }

    @VisibleForTesting
    synchronized EngineJob<R> init(Key key, boolean isCacheable, boolean useUnlimitedSourceGeneratorPool, boolean useAnimationPool, boolean onlyRetrieveFromCache) {
        this.key = key;
        this.isCacheable = isCacheable;
        this.useUnlimitedSourceGeneratorPool = useUnlimitedSourceGeneratorPool;
        this.useAnimationPool = useAnimationPool;
        this.onlyRetrieveFromCache = onlyRetrieveFromCache;
        return this;
    }

    public synchronized void start(DecodeJob<R> decodeJob) {
        this.decodeJob = decodeJob;
        GlideExecutor executor = decodeJob.willDecodeFromCache() ? this.diskCacheExecutor : this.getActiveSourceExecutor();
        executor.execute(decodeJob);
    }

    synchronized void addCallback(ResourceCallback cb, Executor callbackExecutor) {
        this.stateVerifier.throwIfRecycled();
        this.cbs.add(cb, callbackExecutor);
        if (this.hasResource) {
            this.incrementPendingCallbacks(1);
            callbackExecutor.execute(new CallResourceReady(cb));
        } else if (this.hasLoadFailed) {
            this.incrementPendingCallbacks(1);
            callbackExecutor.execute(new CallLoadFailed(cb));
        } else {
            Preconditions.checkArgument(!this.isCancelled, "Cannot add callbacks to a cancelled EngineJob");
        }
    }

    synchronized void callCallbackOnResourceReady(ResourceCallback cb) {
        try {
            cb.onResourceReady(this.engineResource, this.dataSource, this.performanceData);
        }
        catch (Throwable t) {
            throw new CallbackException(t);
        }
    }

    synchronized void callCallbackOnLoadFailed(ResourceCallback cb) {
        try {
            cb.onLoadFailed(this.exception);
        }
        catch (Throwable t) {
            throw new CallbackException(t);
        }
    }

    synchronized void removeCallback(ResourceCallback cb) {
        this.stateVerifier.throwIfRecycled();
        this.cbs.remove(cb);
        if (this.cbs.isEmpty()) {
            boolean isFinishedRunning;
            this.cancel();
            boolean bl = isFinishedRunning = this.hasResource || this.hasLoadFailed;
            if (isFinishedRunning && this.pendingCallbacks.get() == 0) {
                this.release();
            }
        }
    }

    boolean onlyRetrieveFromCache() {
        return this.onlyRetrieveFromCache;
    }

    private GlideExecutor getActiveSourceExecutor() {
        return this.useUnlimitedSourceGeneratorPool ? this.sourceUnlimitedExecutor : (this.useAnimationPool ? this.animationExecutor : this.sourceExecutor);
    }

    void cancel() {
        if (this.isDone()) {
            return;
        }
        this.isCancelled = true;
        this.decodeJob.cancel();
        this.listener.onEngineJobCancelled(this, this.key);
    }

    synchronized boolean isCancelled() {
        return this.isCancelled;
    }

    private boolean isDone() {
        return this.hasLoadFailed || this.hasResource || this.isCancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyCallbacksOfResult() {
        EngineResource<?> localResource;
        Key localKey;
        ResourceCallbacksAndExecutors copy;
        EngineJob engineJob = this;
        synchronized (engineJob) {
            this.stateVerifier.throwIfRecycled();
            if (this.isCancelled) {
                this.resource.recycle();
                this.release();
                return;
            }
            if (this.cbs.isEmpty()) {
                throw new IllegalStateException("Received a resource without any callbacks to notify");
            }
            if (this.hasResource) {
                throw new IllegalStateException("Already have resource");
            }
            this.engineResource = this.engineResourceFactory.build(this.resource, this.isCacheable);
            this.hasResource = true;
            copy = this.cbs.copy();
            this.incrementPendingCallbacks(copy.size() + 1);
            localKey = this.key;
            localResource = this.engineResource;
        }
        this.listener.onEngineJobComplete(this, localKey, localResource);
        for (ResourceCallbackAndExecutor entry : copy) {
            entry.executor.execute(new CallResourceReady(entry.cb));
        }
        this.decrementPendingCallbacks();
    }

    synchronized void incrementPendingCallbacks(int count) {
        Preconditions.checkArgument(this.isDone(), "Not yet complete!");
        if (this.pendingCallbacks.getAndAdd(count) == 0 && this.engineResource != null) {
            this.engineResource.acquire();
        }
    }

    synchronized void decrementPendingCallbacks() {
        this.stateVerifier.throwIfRecycled();
        Preconditions.checkArgument(this.isDone(), "Not yet complete!");
        int decremented = this.pendingCallbacks.decrementAndGet();
        Preconditions.checkArgument(decremented >= 0, "Can't decrement below 0");
        if (decremented == 0) {
            if (this.engineResource != null) {
                this.engineResource.release();
            }
            this.release();
        }
    }

    private synchronized void release() {
        if (this.key == null) {
            throw new IllegalArgumentException();
        }
        this.cbs.clear();
        this.key = null;
        this.engineResource = null;
        this.resource = null;
        this.hasLoadFailed = false;
        this.isCancelled = false;
        this.hasResource = false;
        this.decodeJob.release(false);
        this.decodeJob = null;
        this.exception = null;
        this.dataSource = null;
        this.pool.release((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResourceReady(Resource<R> resource, DataSource dataSource, PerformanceData performanceData) {
        EngineJob engineJob = this;
        synchronized (engineJob) {
            this.resource = resource;
            this.dataSource = dataSource;
            this.performanceData = performanceData;
        }
        this.notifyCallbacksOfResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLoadFailed(GlideException e) {
        EngineJob engineJob = this;
        synchronized (engineJob) {
            this.exception = e;
        }
        this.notifyCallbacksOfException();
    }

    @Override
    public void reschedule(DecodeJob<?> job) {
        if (SettingFlags.getBoolean("key_glide_executor", false)) {
            this.getActiveSourceExecutor().execute(job);
        } else if (this.useUnlimitedSourceGeneratorPool) {
            this.sourceUnlimitedExecutor.execute(job);
        } else if (this.useAnimationPool) {
            this.animationExecutor.execute(job);
        } else {
            YYTaskExecutor.execute(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyCallbacksOfException() {
        ResourceCallbacksAndExecutors copy;
        Key localKey;
        EngineJob engineJob = this;
        synchronized (engineJob) {
            this.stateVerifier.throwIfRecycled();
            if (this.isCancelled) {
                this.release();
                return;
            }
            if (this.cbs.isEmpty()) {
                throw new IllegalStateException("Received an exception without any callbacks to notify");
            }
            if (this.hasLoadFailed) {
                throw new IllegalStateException("Already failed once");
            }
            this.hasLoadFailed = true;
            localKey = this.key;
            copy = this.cbs.copy();
            this.incrementPendingCallbacks(copy.size() + 1);
        }
        this.listener.onEngineJobComplete(this, localKey, null);
        for (ResourceCallbackAndExecutor entry : copy) {
            entry.executor.execute(new CallLoadFailed(entry.cb));
        }
        this.decrementPendingCallbacks();
    }

    @Override
    @NonNull
    public StateVerifier getVerifier() {
        return this.stateVerifier;
    }

    @VisibleForTesting
    static class EngineResourceFactory {
        EngineResourceFactory() {
        }

        public <R> EngineResource<R> build(Resource<R> resource, boolean isMemoryCacheable) {
            return new EngineResource<R>(resource, isMemoryCacheable, true);
        }
    }

    static final class ResourceCallbackAndExecutor {
        final ResourceCallback cb;
        final Executor executor;

        ResourceCallbackAndExecutor(ResourceCallback cb, Executor executor) {
            this.cb = cb;
            this.executor = executor;
        }

        public boolean equals(Object o) {
            if (o instanceof ResourceCallbackAndExecutor) {
                ResourceCallbackAndExecutor other = (ResourceCallbackAndExecutor)o;
                return this.cb.equals(other.cb);
            }
            return false;
        }

        public int hashCode() {
            return this.cb.hashCode();
        }
    }

    static final class ResourceCallbacksAndExecutors
    implements Iterable<ResourceCallbackAndExecutor> {
        private final List<ResourceCallbackAndExecutor> callbacksAndExecutors;

        ResourceCallbacksAndExecutors() {
            this(new ArrayList<ResourceCallbackAndExecutor>(2));
        }

        ResourceCallbacksAndExecutors(List<ResourceCallbackAndExecutor> callbacksAndExecutors) {
            this.callbacksAndExecutors = callbacksAndExecutors;
        }

        void add(ResourceCallback cb, Executor executor) {
            this.callbacksAndExecutors.add(new ResourceCallbackAndExecutor(cb, executor));
        }

        void remove(ResourceCallback cb) {
            this.callbacksAndExecutors.remove(ResourceCallbacksAndExecutors.defaultCallbackAndExecutor(cb));
        }

        boolean contains(ResourceCallback cb) {
            return this.callbacksAndExecutors.contains(ResourceCallbacksAndExecutors.defaultCallbackAndExecutor(cb));
        }

        boolean isEmpty() {
            return this.callbacksAndExecutors.isEmpty();
        }

        int size() {
            return this.callbacksAndExecutors.size();
        }

        void clear() {
            this.callbacksAndExecutors.clear();
        }

        ResourceCallbacksAndExecutors copy() {
            return new ResourceCallbacksAndExecutors(new ArrayList<ResourceCallbackAndExecutor>(this.callbacksAndExecutors));
        }

        private static ResourceCallbackAndExecutor defaultCallbackAndExecutor(ResourceCallback cb) {
            return new ResourceCallbackAndExecutor(cb, Executors.directExecutor());
        }

        @Override
        @NonNull
        public Iterator<ResourceCallbackAndExecutor> iterator() {
            return this.callbacksAndExecutors.iterator();
        }
    }

    private class CallResourceReady
    implements Runnable {
        private final ResourceCallback cb;

        CallResourceReady(ResourceCallback cb) {
            this.cb = cb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            EngineJob engineJob = EngineJob.this;
            synchronized (engineJob) {
                if (EngineJob.this.cbs.contains(this.cb)) {
                    EngineJob.this.engineResource.acquire();
                    EngineJob.this.callCallbackOnResourceReady(this.cb);
                    EngineJob.this.removeCallback(this.cb);
                }
                EngineJob.this.decrementPendingCallbacks();
            }
        }
    }

    private class CallLoadFailed
    implements Runnable {
        private final ResourceCallback cb;

        CallLoadFailed(ResourceCallback cb) {
            this.cb = cb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            EngineJob engineJob = EngineJob.this;
            synchronized (engineJob) {
                if (EngineJob.this.cbs.contains(this.cb)) {
                    EngineJob.this.callCallbackOnLoadFailed(this.cb);
                }
                EngineJob.this.decrementPendingCallbacks();
            }
        }
    }
}

