/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.util.Pools;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.ResourceDecoder;
import com.bumptech.glide.load.data.DataRewinder;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.resource.transcode.ResourceTranscoder;
import com.bumptech.glide.util.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DecodePath<DataType, ResourceType, Transcode> {
    private static final String TAG = "DecodePath";
    private final Class<DataType> dataClass;
    private final List<? extends ResourceDecoder<DataType, ResourceType>> decoders;
    private final ResourceTranscoder<ResourceType, Transcode> transcoder;
    private final Pools.Pool<List<Throwable>> listPool;
    private final String failureMessage;

    public DecodePath(Class<DataType> dataClass, Class<ResourceType> resourceClass, Class<Transcode> transcodeClass, List<? extends ResourceDecoder<DataType, ResourceType>> decoders, ResourceTranscoder<ResourceType, Transcode> transcoder, Pools.Pool<List<Throwable>> listPool) {
        this.dataClass = dataClass;
        this.decoders = decoders;
        this.transcoder = transcoder;
        this.listPool = listPool;
        this.failureMessage = "Failed DecodePath{" + dataClass.getSimpleName() + "->" + resourceClass.getSimpleName() + "->" + transcodeClass.getSimpleName() + "}";
    }

    public Resource<Transcode> decode(Key key, DataRewinder<DataType> rewinder, int width, int height, @NonNull Options options, DecodeCallback<ResourceType> callback) throws GlideException {
        Resource<ResourceType> decoded = this.decodeResource(key, rewinder, width, height, options);
        long start = System.currentTimeMillis();
        Resource<ResourceType> transformed = callback.onResourceDecoded(decoded);
        long during = System.currentTimeMillis() - start;
        return this.transcoder.transcode(transformed, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private Resource<ResourceType> decodeResource(Key key, DataRewinder<DataType> rewinder, int width, int height, @NonNull Options options) throws GlideException {
        List exceptions = (List)Preconditions.checkNotNull(this.listPool.acquire());
        try {
            Resource<ResourceType> resource = this.decodeResourceWithList(key, rewinder, width, height, options, exceptions);
            return resource;
        }
        finally {
            this.listPool.release((Object)exceptions);
        }
    }

    @NonNull
    private Resource<ResourceType> decodeResourceWithList(Key key, DataRewinder<DataType> rewinder, int width, int height, @NonNull Options options, List<Throwable> exceptions) throws GlideException {
        Resource<ResourceType> result = null;
        int size = this.decoders.size();
        for (int i = 0; i < size; ++i) {
            ResourceDecoder<DataType, ResourceType> decoder = this.decoders.get(i);
            long start = 0L;
            try {
                DataType data = rewinder.rewindAndGet();
                if (decoder.handles(data, options)) {
                    data = rewinder.rewindAndGet();
                    start = System.currentTimeMillis();
                    result = decoder.decode(data, width, height, options);
                }
            }
            catch (IOException | OutOfMemoryError | RuntimeException e) {
                if (Log.isLoggable((String)TAG, (int)2)) {
                    Log.v((String)TAG, (String)("Failed to decode data for " + decoder), (Throwable)e);
                }
                exceptions.add(e);
            }
            if (result != null) break;
        }
        if (result == null) {
            throw new GlideException(this.failureMessage, new ArrayList<Throwable>(exceptions));
        }
        return result;
    }

    public String toString() {
        return "DecodePath{ dataClass=" + this.dataClass + ", decoders=" + this.decoders + ", transcoder=" + this.transcoder + '}';
    }

    static interface DecodeCallback<ResourceType> {
        @NonNull
        public Resource<ResourceType> onResourceDecoded(@NonNull Resource<ResourceType> var1);
    }
}

