/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.data;

import android.content.res.AssetManager;
import android.util.Log;
import androidx.annotation.NonNull;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.data.DataFetcher;
import java.io.IOException;

public abstract class AssetPathFetcher<T>
implements DataFetcher<T> {
    private static final String TAG = "AssetPathFetcher";
    private final String assetPath;
    private final AssetManager assetManager;
    private T data;

    public AssetPathFetcher(AssetManager assetManager, String assetPath) {
        this.assetManager = assetManager;
        this.assetPath = assetPath;
    }

    @Override
    public void loadData(@NonNull Priority priority, @NonNull DataFetcher.DataCallback<? super T> callback) {
        try {
            this.data = this.loadResource(this.assetManager, this.assetPath);
        }
        catch (IOException e) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)"Failed to load data from asset manager", (Throwable)e);
            }
            callback.onLoadFailed(e);
            return;
        }
        callback.onDataReady(this.data);
    }

    @Override
    public void cleanup() {
        if (this.data == null) {
            return;
        }
        try {
            this.close(this.data);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void cancel() {
    }

    @Override
    @NonNull
    public DataSource getDataSource() {
        return DataSource.LOCAL;
    }

    protected abstract T loadResource(AssetManager var1, String var2) throws IOException;

    protected abstract void close(T var1) throws IOException;
}

